/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.tile;

import com.raoulvdberge.refinedstorage.apiimpl.network.node.diskmanipulator.NetworkNodeDiskManipulator;
import com.raoulvdberge.refinedstorage.tile.TileDiskDrive;
import com.raoulvdberge.refinedstorage.tile.TileNode;
import com.raoulvdberge.refinedstorage.tile.config.IComparable;
import com.raoulvdberge.refinedstorage.tile.config.IFilterable;
import com.raoulvdberge.refinedstorage.tile.config.IType;
import com.raoulvdberge.refinedstorage.tile.data.TileDataParameter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileDiskManipulator
extends TileNode<NetworkNodeDiskManipulator> {
    public static final TileDataParameter<Integer, TileDiskManipulator> COMPARE = IComparable.createParameter();
    public static final TileDataParameter<Integer, TileDiskManipulator> MODE = IFilterable.createParameter();
    public static final TileDataParameter<Integer, TileDiskManipulator> TYPE = IType.createParameter();
    public static final TileDataParameter<Integer, TileDiskManipulator> IO_MODE = new TileDataParameter<Integer, TileDiskManipulator>(DataSerializers.field_187192_b, 0, t -> ((NetworkNodeDiskManipulator)t.getNode()).getIoMode(), (t, v) -> {
        ((NetworkNodeDiskManipulator)t.getNode()).setIoMode((int)v);
        ((NetworkNodeDiskManipulator)t.getNode()).markDirty();
    });
    private Integer[] diskState = new Integer[6];

    public TileDiskManipulator() {
        this.dataManager.addWatchedParameter(COMPARE);
        this.dataManager.addWatchedParameter(MODE);
        this.dataManager.addWatchedParameter(TYPE);
        this.dataManager.addWatchedParameter(IO_MODE);
        TileDiskDrive.initDiskState(this.diskState);
    }

    @Override
    public NBTTagCompound writeUpdate(NBTTagCompound tag) {
        super.writeUpdate(tag);
        TileDiskDrive.writeDiskState(tag, 6, ((NetworkNodeDiskManipulator)this.getNode()).getNetwork() != null, ((NetworkNodeDiskManipulator)this.getNode()).getItemStorages(), ((NetworkNodeDiskManipulator)this.getNode()).getFluidStorages());
        return tag;
    }

    @Override
    public void readUpdate(NBTTagCompound tag) {
        super.readUpdate(tag);
        TileDiskDrive.readDiskState(tag, this.diskState);
    }

    public Integer[] getDiskState() {
        return this.diskState;
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)((NetworkNodeDiskManipulator)this.getNode()).getDisks());
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    @Nonnull
    public NetworkNodeDiskManipulator createNode(World world, BlockPos pos) {
        return new NetworkNodeDiskManipulator(world, pos);
    }

    @Override
    public String getNodeId() {
        return "disk_manipulator";
    }
}

