/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.tile;

import com.raoulvdberge.refinedstorage.api.storage.AccessType;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.externalstorage.NetworkNodeExternalStorage;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.externalstorage.StorageFluidExternal;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.externalstorage.StorageItemExternal;
import com.raoulvdberge.refinedstorage.tile.TileNode;
import com.raoulvdberge.refinedstorage.tile.config.IAccessType;
import com.raoulvdberge.refinedstorage.tile.config.IComparable;
import com.raoulvdberge.refinedstorage.tile.config.IFilterable;
import com.raoulvdberge.refinedstorage.tile.config.IPrioritizable;
import com.raoulvdberge.refinedstorage.tile.config.IType;
import com.raoulvdberge.refinedstorage.tile.data.TileDataParameter;
import javax.annotation.Nonnull;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileExternalStorage
extends TileNode<NetworkNodeExternalStorage> {
    public static final TileDataParameter<Integer, TileExternalStorage> PRIORITY = IPrioritizable.createParameter();
    public static final TileDataParameter<Integer, TileExternalStorage> COMPARE = IComparable.createParameter();
    public static final TileDataParameter<Integer, TileExternalStorage> MODE = IFilterable.createParameter();
    public static final TileDataParameter<Integer, TileExternalStorage> TYPE = IType.createParameter();
    public static final TileDataParameter<AccessType, TileExternalStorage> ACCESS_TYPE = IAccessType.createParameter();
    public static final TileDataParameter<Integer, TileExternalStorage> STORED = new TileDataParameter<Integer, TileExternalStorage>(DataSerializers.field_187192_b, 0, t -> {
        int stored = 0;
        for (StorageItemExternal storageItemExternal : ((NetworkNodeExternalStorage)t.getNode()).getItemStorages()) {
            stored += storageItemExternal.getStored();
        }
        for (StorageFluidExternal storageFluidExternal : ((NetworkNodeExternalStorage)t.getNode()).getFluidStorages()) {
            stored += storageFluidExternal.getStored();
        }
        return stored;
    });
    public static final TileDataParameter<Integer, TileExternalStorage> CAPACITY = new TileDataParameter<Integer, TileExternalStorage>(DataSerializers.field_187192_b, 0, t -> {
        int capacity = 0;
        for (StorageItemExternal storageItemExternal : ((NetworkNodeExternalStorage)t.getNode()).getItemStorages()) {
            capacity += storageItemExternal.getCapacity();
        }
        for (StorageFluidExternal storageFluidExternal : ((NetworkNodeExternalStorage)t.getNode()).getFluidStorages()) {
            capacity += storageFluidExternal.getCapacity();
        }
        return capacity;
    });

    public TileExternalStorage() {
        this.dataManager.addWatchedParameter(PRIORITY);
        this.dataManager.addWatchedParameter(COMPARE);
        this.dataManager.addWatchedParameter(MODE);
        this.dataManager.addWatchedParameter(STORED);
        this.dataManager.addWatchedParameter(CAPACITY);
        this.dataManager.addWatchedParameter(TYPE);
        this.dataManager.addWatchedParameter(ACCESS_TYPE);
    }

    @Override
    @Nonnull
    public NetworkNodeExternalStorage createNode(World world, BlockPos pos) {
        return new NetworkNodeExternalStorage(world, pos);
    }

    @Override
    public String getNodeId() {
        return "external_storage";
    }
}

