/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.tile;

import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNodeSolderer;
import com.raoulvdberge.refinedstorage.tile.TileNode;
import com.raoulvdberge.refinedstorage.tile.data.TileDataParameter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileSolderer
extends TileNode<NetworkNodeSolderer> {
    public static final TileDataParameter<Integer, TileSolderer> DURATION = new TileDataParameter<Integer, TileSolderer>(DataSerializers.field_187192_b, 0, t -> ((NetworkNodeSolderer)t.getNode()).getDuration());
    public static final TileDataParameter<Integer, TileSolderer> PROGRESS = new TileDataParameter<Integer, TileSolderer>(DataSerializers.field_187192_b, 0, t -> ((NetworkNodeSolderer)t.getNode()).getProgress());
    public static final TileDataParameter<Boolean, TileSolderer> WORKING = new TileDataParameter<Boolean, TileSolderer>(DataSerializers.field_187198_h, false, t -> ((NetworkNodeSolderer)t.getNode()).isWorking());
    private boolean working;

    public TileSolderer() {
        this.dataManager.addWatchedParameter(DURATION);
        this.dataManager.addWatchedParameter(PROGRESS);
        this.dataManager.addWatchedParameter(WORKING);
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)((NetworkNodeSolderer)this.getNode()).getItems());
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    public NBTTagCompound writeUpdate(NBTTagCompound tag) {
        super.writeUpdate(tag);
        tag.func_74757_a("Working", ((NetworkNodeSolderer)this.getNode()).isWorking());
        return tag;
    }

    @Override
    public void readUpdate(NBTTagCompound tag) {
        super.readUpdate(tag);
        if (tag.func_74764_b("Working")) {
            this.working = tag.func_74767_n("Working");
        }
    }

    public boolean isWorking() {
        return this.working;
    }

    @Override
    protected boolean canCauseRenderUpdate(NBTTagCompound tag) {
        EnumFacing receivedDirection = EnumFacing.func_82600_a((int)tag.func_74762_e("Direction"));
        return receivedDirection != this.getDirection();
    }

    @Override
    @Nonnull
    public NetworkNodeSolderer createNode(World world, BlockPos pos) {
        return new NetworkNodeSolderer(world, pos);
    }

    @Override
    public String getNodeId() {
        return "solderer";
    }
}

