/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.tile.config;

import com.raoulvdberge.refinedstorage.RSItems;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNodeProxy;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.inventory.ItemHandlerFluid;
import com.raoulvdberge.refinedstorage.item.ItemFilter;
import com.raoulvdberge.refinedstorage.tile.data.TileDataParameter;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandler;

public interface IFilterable {
    public static final int WHITELIST = 0;
    public static final int BLACKLIST = 1;

    public static <T extends TileEntity> TileDataParameter<Integer, T> createParameter() {
        return new TileDataParameter<Integer, TileEntity>(DataSerializers.field_187192_b, 0, t -> ((IFilterable)((INetworkNodeProxy)t).getNode()).getMode(), (t, v) -> {
            if (v == 0 || v == 1) {
                ((IFilterable)((INetworkNodeProxy)t).getNode()).setMode((int)v);
            }
        });
    }

    public static boolean canTake(IItemHandler filters, int mode, int compare, ItemStack stack) {
        if (mode == 0) {
            int slots = 0;
            for (int i = 0; i < filters.getSlots(); ++i) {
                ItemStack slot = filters.getStackInSlot(i);
                if (slot.func_190926_b()) continue;
                ++slots;
                if (slot.func_77973_b() == RSItems.FILTER) {
                    for (ItemStack slotInFilter : ItemFilter.getFilterItemsFromCache(slot)) {
                        if (slotInFilter.func_190926_b() || !API.instance().getComparer().isEqual(slotInFilter, stack, compare)) continue;
                        return true;
                    }
                    continue;
                }
                if (!API.instance().getComparer().isEqual(slot, stack, compare)) continue;
                return true;
            }
            return slots == 0;
        }
        if (mode == 1) {
            for (int i = 0; i < filters.getSlots(); ++i) {
                ItemStack slot = filters.getStackInSlot(i);
                if (slot.func_190926_b()) continue;
                if (slot.func_77973_b() == RSItems.FILTER) {
                    for (ItemStack slotInFilter : ItemFilter.getFilterItemsFromCache(slot)) {
                        if (slotInFilter.func_190926_b() || !API.instance().getComparer().isEqual(slotInFilter, stack, compare)) continue;
                        return false;
                    }
                    continue;
                }
                if (!API.instance().getComparer().isEqual(slot, stack, compare)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean canTakeFluids(ItemHandlerFluid filters, int mode, int compare, FluidStack stack) {
        if (mode == 0) {
            int slots = 0;
            for (int i = 0; i < filters.getSlots(); ++i) {
                FluidStack slot = filters.getFluidStackInSlot(i);
                if (slot == null) continue;
                ++slots;
                if (!API.instance().getComparer().isEqual(slot, stack, compare)) continue;
                return true;
            }
            return slots == 0;
        }
        if (mode == 1) {
            for (int i = 0; i < filters.getSlots(); ++i) {
                FluidStack slot = filters.getFluidStackInSlot(i);
                if (slot == null || !API.instance().getComparer().isEqual(slot, stack, compare)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isEmpty(IItemHandler filter) {
        for (int i = 0; i < filter.getSlots(); ++i) {
            if (filter.getStackInSlot(i).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public void setMode(int var1);

    public int getMode();
}

