/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.util;

import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.storage.IStorageDisk;
import com.raoulvdberge.refinedstorage.api.storage.IStorageDiskProvider;
import com.raoulvdberge.refinedstorage.api.util.IStackList;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;

public final class StackUtils {
    public static final ItemStack EMPTY_BUCKET = new ItemStack(Items.field_151133_ar);
    public static final ItemStack EMPTY_BOTTLE = new ItemStack(Items.field_151069_bo);
    public static final ItemStack WATER_BOTTLE = PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)PotionTypes.field_185230_b);
    private static final String NBT_INVENTORY = "Inventory_%d";
    private static final String NBT_SLOT = "Slot";
    private static final Map<Integer, List<ItemStack>> OREDICT_CACHE = new HashMap<Integer, List<ItemStack>>();
    private static final Map<Integer, Boolean> OREDICT_EQUIVALENCY_CACHE = new HashMap<Integer, Boolean>();
    private static final NonNullList<Object> EMPTY_NON_NULL_LIST = NonNullList.func_191196_a();

    public static List<ItemStack> getEquivalentStacks(ItemStack stack) {
        int hash = API.instance().getItemStackHashCode(stack, false);
        if (OREDICT_CACHE.containsKey(hash)) {
            return OREDICT_CACHE.get(hash);
        }
        ArrayList<ItemStack> ores = new ArrayList<ItemStack>();
        for (int id : OreDictionary.getOreIDs((ItemStack)stack)) {
            ores.addAll((Collection<ItemStack>)OreDictionary.getOres((String)OreDictionary.getOreName((int)id)));
        }
        OREDICT_CACHE.put(hash, ores);
        return ores;
    }

    public static boolean areStacksEquivalent(ItemStack left, ItemStack right) {
        int[] rightIds;
        int code = API.instance().getItemStackHashCode(left, false);
        if (OREDICT_EQUIVALENCY_CACHE.containsKey(code = 31 * code + API.instance().getItemStackHashCode(right, false))) {
            return OREDICT_EQUIVALENCY_CACHE.get(code);
        }
        int[] leftIds = OreDictionary.getOreIDs((ItemStack)left);
        for (int i : rightIds = OreDictionary.getOreIDs((ItemStack)right)) {
            if (!ArrayUtils.contains((int[])leftIds, (int)i)) continue;
            OREDICT_EQUIVALENCY_CACHE.put(code, true);
            return true;
        }
        OREDICT_EQUIVALENCY_CACHE.put(code, false);
        return false;
    }

    public static void writeItemStack(ByteBuf buf, ItemStack stack) {
        buf.writeInt(Item.func_150891_b((Item)stack.func_77973_b()));
        buf.writeInt(stack.func_190916_E());
        buf.writeShort(stack.func_77952_i());
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)stack.func_77973_b().getNBTShareTag(stack));
    }

    public static ItemStack readItemStack(ByteBuf buf) {
        ItemStack stack = new ItemStack(Item.func_150899_d((int)buf.readInt()), buf.readInt(), (int)buf.readShort());
        stack.func_77982_d(ByteBufUtils.readTag((ByteBuf)buf));
        return stack;
    }

    public static void writeItemStack(ByteBuf buf, ItemStack stack, @Nullable INetwork network, boolean displayCraftText) {
        StackUtils.writeItemStack(buf, stack);
        buf.writeInt(API.instance().getItemStackHashCode(stack));
        if (network != null) {
            buf.writeBoolean(network.getCraftingManager().hasPattern(stack));
            buf.writeBoolean(displayCraftText);
        } else {
            buf.writeBoolean(false);
            buf.writeBoolean(false);
        }
    }

    public static void writeFluidStack(ByteBuf buf, FluidStack stack) {
        buf.writeInt(API.instance().getFluidStackHashCode(stack));
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)FluidRegistry.getFluidName((Fluid)stack.getFluid()));
        buf.writeInt(stack.amount);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)stack.tag);
    }

    public static Pair<Integer, FluidStack> readFluidStack(ByteBuf buf) {
        return Pair.of((Object)buf.readInt(), (Object)new FluidStack(FluidRegistry.getFluid((String)ByteBufUtils.readUTF8String((ByteBuf)buf)), buf.readInt(), ByteBufUtils.readTag((ByteBuf)buf)));
    }

    public static ItemStack nullToEmpty(@Nullable ItemStack stack) {
        return stack == null ? ItemStack.field_190927_a : stack;
    }

    @Nullable
    public static ItemStack emptyToNull(@Nonnull ItemStack stack) {
        return stack.func_190926_b() ? null : stack;
    }

    public static void createStorages(ItemStack disk, int slot, IStorageDisk<ItemStack>[] itemStorages, IStorageDisk<FluidStack>[] fluidStorages, Function<IStorageDisk<ItemStack>, IStorageDisk> itemStorageWrapper, Function<IStorageDisk<FluidStack>, IStorageDisk> fluidStorageWrapper) {
        if (disk.func_190926_b()) {
            itemStorages[slot] = null;
            fluidStorages[slot] = null;
        } else {
            IStorageDiskProvider provider = (IStorageDiskProvider)disk.func_77973_b();
            IStorageDisk storage = provider.create(disk);
            storage.readFromNBT();
            switch (storage.getType()) {
                case ITEMS: {
                    itemStorages[slot] = itemStorageWrapper.apply(storage);
                    break;
                }
                case FLUIDS: {
                    fluidStorages[slot] = fluidStorageWrapper.apply(storage);
                }
            }
        }
    }

    public static NonNullList<ItemStack> toNonNullList(List<ItemStack> list) {
        NonNullList other = NonNullList.func_191196_a();
        for (ItemStack item : list) {
            if (item == null) continue;
            other.add((Object)item);
        }
        return other;
    }

    public static <T> NonNullList<T> emptyNonNullList() {
        return EMPTY_NON_NULL_LIST;
    }

    public static void writeItems(IItemHandler handler, int id, NBTTagCompound tag) {
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (handler.getStackInSlot(i).func_190926_b()) continue;
            NBTTagCompound stackTag = new NBTTagCompound();
            stackTag.func_74768_a(NBT_SLOT, i);
            handler.getStackInSlot(i).func_77955_b(stackTag);
            tagList.func_74742_a((NBTBase)stackTag);
        }
        tag.func_74782_a(String.format(NBT_INVENTORY, id), (NBTBase)tagList);
    }

    public static void readItems(IItemHandlerModifiable handler, int id, NBTTagCompound tag) {
        String name = String.format(NBT_INVENTORY, id);
        if (tag.func_74764_b(name)) {
            NBTTagList tagList = tag.func_150295_c(name, 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                int slot = tagList.func_150305_b(i).func_74762_e(NBT_SLOT);
                if (slot < 0 || slot >= handler.getSlots()) continue;
                handler.setStackInSlot(slot, new ItemStack(tagList.func_150305_b(i)));
            }
        }
    }

    public static void writeItems(IInventory inventory, int id, NBTTagCompound tag) {
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            if (inventory.func_70301_a(i).func_190926_b()) continue;
            NBTTagCompound stackTag = new NBTTagCompound();
            stackTag.func_74768_a(NBT_SLOT, i);
            inventory.func_70301_a(i).func_77955_b(stackTag);
            tagList.func_74742_a((NBTBase)stackTag);
        }
        tag.func_74782_a(String.format(NBT_INVENTORY, id), (NBTBase)tagList);
    }

    public static void readItems(IInventory inventory, int id, NBTTagCompound tag) {
        String name = String.format(NBT_INVENTORY, id);
        if (tag.func_74764_b(name)) {
            NBTTagList tagList = tag.func_150295_c(name, 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                int slot = tagList.func_150305_b(i).func_74762_e(NBT_SLOT);
                ItemStack stack = new ItemStack(tagList.func_150305_b(i));
                if (stack.func_190926_b()) continue;
                inventory.func_70299_a(slot, stack);
            }
        }
    }

    public static NBTTagList serializeFluidStackList(IStackList<FluidStack> list) {
        NBTTagList tagList = new NBTTagList();
        for (FluidStack stack : list.getStacks()) {
            tagList.func_74742_a((NBTBase)stack.writeToNBT(new NBTTagCompound()));
        }
        return tagList;
    }

    public static IStackList<FluidStack> readFluidStackList(NBTTagList tagList) {
        IStackList<FluidStack> list = API.instance().createFluidStackList();
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            FluidStack stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tagList.func_150305_b(i));
            if (stack == null) continue;
            list.add(stack, stack.amount);
        }
        return list;
    }

    public static boolean hasFluidBucket(FluidStack stack) {
        return stack.getFluid() == FluidRegistry.WATER || stack.getFluid() == FluidRegistry.LAVA || stack.getFluid().getName().equals("milk") || FluidRegistry.getBucketFluids().contains(stack.getFluid());
    }

    public static FluidStack copy(FluidStack stack, int size) {
        FluidStack copy = stack.copy();
        copy.amount = size;
        return copy;
    }

    public static FluidStack copy(@Nullable FluidStack stack) {
        return stack == null ? null : stack.copy();
    }

    public static Pair<ItemStack, FluidStack> getFluid(ItemStack stack, boolean simulate) {
        if (stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
            IFluidHandlerItem fluidHandler = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
            FluidStack result = fluidHandler.drain(1000, !simulate);
            return Pair.of((Object)fluidHandler.getContainer(), (Object)result);
        }
        return Pair.of(null, null);
    }
}

