/*
 * Decompiled with CFR 0.152.
 */
package uk.kihira.tails.common.network;

import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import uk.kihira.tails.common.LibraryEntryData;
import uk.kihira.tails.common.Tails;

public class LibraryEntriesMessage
implements IMessage {
    private List<LibraryEntryData> entries;
    private boolean delete;

    public LibraryEntriesMessage() {
    }

    public LibraryEntriesMessage(List<LibraryEntryData> entries, boolean delete) {
        this.entries = entries;
        this.delete = delete;
    }

    public void fromBytes(ByteBuf buf) {
        String dataJson = ByteBufUtils.readUTF8String((ByteBuf)buf);
        try {
            this.entries = (List)Tails.gson.fromJson(dataJson, new TypeToken<List<LibraryEntryData>>(){}.getType());
        }
        catch (JsonParseException e) {
            e.printStackTrace();
        }
        this.delete = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)Tails.gson.toJson(this.entries, new TypeToken<List<LibraryEntryData>>(){}.getType()));
        buf.writeBoolean(this.delete);
    }

    public static class Handler
    implements IMessageHandler<LibraryEntriesMessage, IMessage> {
        public IMessage onMessage(LibraryEntriesMessage message, MessageContext ctx) {
            if (ctx.side.isClient()) {
                for (LibraryEntryData entry : message.entries) {
                    entry.remoteEntry = true;
                }
                Tails.proxy.getLibraryManager().removeRemoteEntries();
                Tails.proxy.getLibraryManager().addEntries(message.entries);
            } else {
                if (message.delete) {
                    Tails.logger.debug("Removing Library Entries: " + message.entries.size());
                    Tails.proxy.getLibraryManager().libraryEntries.removeAll(message.entries);
                } else {
                    Tails.logger.debug("Adding Library Entries: " + message.entries.size());
                    Tails.proxy.getLibraryManager().addEntries(message.entries);
                }
                Tails.proxy.getLibraryManager().saveLibrary();
            }
            return null;
        }
    }
}

