/*
 * Decompiled with CFR 0.152.
 */
package openmods.calc;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import info.openmods.calc.Calculator;
import info.openmods.calc.ExprType;
import info.openmods.calc.Frame;
import info.openmods.calc.IValuePrinter;
import info.openmods.calc.symbol.ICallable;
import info.openmods.calc.symbol.IGettable;
import info.openmods.calc.symbol.NullaryFunction;
import info.openmods.calc.symbol.UnaryFunction;
import info.openmods.calc.types.bigint.BigIntCalculatorFactory;
import info.openmods.calc.types.bool.BoolCalculatorFactory;
import info.openmods.calc.types.fp.DoubleCalculatorFactory;
import info.openmods.calc.types.fraction.FractionCalculatorFactory;
import info.openmods.calc.types.multi.StructWrapper;
import info.openmods.calc.types.multi.TypeDomain;
import info.openmods.calc.types.multi.TypedValue;
import info.openmods.calc.types.multi.TypedValueCalculatorFactory;
import info.openmods.calc.utils.OptionalInt;
import info.openmods.calc.utils.Stack;
import info.openmods.calc.utils.StackValidationException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import openmods.calc.EntityPlayerWrapper;
import org.apache.commons.lang3.math.Fraction;

public class CalcState {
    private final SenderHolder senderHolder = new SenderHolder();
    private Calculator<?, ExprType> active = CalculatorType.DOUBLE.createCalculator(this.senderHolder);
    private Calculator<?, ExprType> prev;
    public ExprType exprType = ExprType.INFIX;
    private Stack<Calculator<?, ExprType>> calculatorStack = Stack.create();
    private Map<String, Calculator<?, ExprType>> calculatorMap = Maps.newHashMap();

    public Calculator<?, ExprType> getActiveCalculator() {
        return this.active;
    }

    private void setActiveCalculator(Calculator<?, ExprType> newCalculator) {
        this.prev = this.active;
        this.active = newCalculator;
    }

    public void restorePreviousCalculator() {
        Calculator<?, ExprType> tmp = this.active;
        this.active = this.prev;
        this.prev = tmp;
    }

    public void createCalculator(CalculatorType type) {
        this.setActiveCalculator(type.createCalculator(this.senderHolder));
    }

    public int pushCalculator() {
        this.calculatorStack.push(this.active);
        return this.calculatorStack.size();
    }

    public int popCalculator() {
        this.setActiveCalculator(this.calculatorStack.pop());
        return this.calculatorStack.size();
    }

    public void nameCalculator(String name) {
        this.calculatorMap.put(name, this.active);
    }

    public Set<String> getCalculatorsNames() {
        return Collections.unmodifiableSet(this.calculatorMap.keySet());
    }

    public void loadCalculator(String name) {
        Calculator<?, ExprType> newCalculator = this.calculatorMap.get(name);
        if (newCalculator == null) {
            throw new NoSuchNameException(name);
        }
        this.setActiveCalculator(newCalculator);
    }

    public void compileAndExecute(ICommandSender sender, final String expr) {
        this.senderHolder.call(sender, new IFunction<Void>(){

            @Override
            public Void call() {
                CalcState.this.active.compileAndExecute(CalcState.this.exprType, expr);
                return null;
            }
        });
    }

    public String compileExecuteAndPrint(ICommandSender sender, final String expr) {
        return this.senderHolder.call(sender, new IFunction<String>(){

            @Override
            public String call() {
                return CalcState.this.active.compileExecuteAndPrint(CalcState.this.exprType, expr);
            }
        });
    }

    public Object compileAndSetGlobalSymbol(ICommandSender sender, final String id, final String expr) {
        return this.senderHolder.call(sender, new IFunction<Object>(){

            @Override
            public Object call() {
                return CalcState.this.active.compileAndSetGlobalSymbol(CalcState.this.exprType, id, expr);
            }
        });
    }

    public void compileAndDefineGlobalFunction(ICommandSender sender, final String id, final int argCount, final String expr) {
        this.senderHolder.call(sender, new IFunction<Void>(){

            @Override
            public Void call() {
                CalcState.this.active.compileAndDefineGlobalFunction(CalcState.this.exprType, id, argCount, expr);
                return null;
            }
        });
    }

    public static enum CalculatorType {
        DOUBLE{

            @Override
            public Calculator<?, ExprType> newCalculator(final SenderHolder holder) {
                Calculator<Double, ExprType> calculator = DoubleCalculatorFactory.createDefault();
                calculator.environment.setGlobalSymbol("_x", new IGettable<Double>(){

                    @Override
                    public Double get() {
                        return holder.getX();
                    }
                });
                calculator.environment.setGlobalSymbol("_y", new IGettable<Double>(){

                    @Override
                    public Double get() {
                        return holder.getY();
                    }
                });
                calculator.environment.setGlobalSymbol("_z", new IGettable<Double>(){

                    @Override
                    public Double get() {
                        return holder.getZ();
                    }
                });
                return calculator;
            }
        }
        ,
        FRACTION{

            @Override
            public Calculator<?, ExprType> newCalculator(final SenderHolder holder) {
                Calculator<Fraction, ExprType> calculator = FractionCalculatorFactory.createDefault();
                calculator.environment.setGlobalSymbol("_x", new IGettable<Fraction>(){

                    @Override
                    public Fraction get() {
                        return Fraction.getFraction((int)holder.getX(), (int)1);
                    }
                });
                calculator.environment.setGlobalSymbol("_y", new IGettable<Fraction>(){

                    @Override
                    public Fraction get() {
                        return Fraction.getFraction((int)holder.getY(), (int)1);
                    }
                });
                calculator.environment.setGlobalSymbol("_z", new IGettable<Fraction>(){

                    @Override
                    public Fraction get() {
                        return Fraction.getFraction((int)holder.getZ(), (int)1);
                    }
                });
                return calculator;
            }
        }
        ,
        BIGINT{

            @Override
            public Calculator<?, ExprType> newCalculator(final SenderHolder holder) {
                Calculator<BigInteger, ExprType> calculator = BigIntCalculatorFactory.createDefault();
                calculator.environment.setGlobalSymbol("_x", new IGettable<BigInteger>(){

                    @Override
                    public BigInteger get() {
                        return BigInteger.valueOf(holder.getX());
                    }
                });
                calculator.environment.setGlobalSymbol("_y", new IGettable<BigInteger>(){

                    @Override
                    public BigInteger get() {
                        return BigInteger.valueOf(holder.getY());
                    }
                });
                calculator.environment.setGlobalSymbol("_z", new IGettable<BigInteger>(){

                    @Override
                    public BigInteger get() {
                        return BigInteger.valueOf(holder.getZ());
                    }
                });
                return calculator;
            }
        }
        ,
        MULTI{

            @Override
            protected Calculator<?, ExprType> newCalculator(final SenderHolder holder) {
                Calculator<TypedValue, ExprType> calculator = TypedValueCalculatorFactory.create();
                final TypedValue nullValue = (TypedValue)calculator.environment.nullValue();
                final TypeDomain domain = nullValue.domain;
                calculator.environment.setGlobalSymbol("player", new NullaryFunction.Direct<TypedValue>(){

                    @Override
                    protected TypedValue call() {
                        if (holder.sender instanceof EntityPlayer) {
                            EntityPlayerWrapper wrapper = new EntityPlayerWrapper((EntityPlayer)holder.sender, nullValue);
                            return StructWrapper.create(domain, wrapper);
                        }
                        return nullValue;
                    }
                });
                return calculator;
            }
        }
        ,
        BOOL{

            @Override
            protected Calculator<?, ExprType> newCalculator(SenderHolder holder) {
                return BoolCalculatorFactory.createDefault();
            }
        };


        public Calculator<?, ExprType> createCalculator(SenderHolder holder) {
            return holder.addPrinter(this.newCalculator(holder));
        }

        protected abstract Calculator<?, ExprType> newCalculator(SenderHolder var1);
    }

    private static class SenderHolder {
        private ICommandSender sender;

        private SenderHolder() {
        }

        public int getX() {
            Preconditions.checkNotNull((Object)this.sender, (Object)"DERP");
            return this.sender.func_180425_c().func_177958_n();
        }

        public int getY() {
            Preconditions.checkNotNull((Object)this.sender, (Object)"DERP");
            return this.sender.func_180425_c().func_177956_o();
        }

        public int getZ() {
            Preconditions.checkNotNull((Object)this.sender, (Object)"DERP");
            return this.sender.func_180425_c().func_177952_p();
        }

        public <E> Calculator<E, ExprType> addPrinter(Calculator<E, ExprType> calculator) {
            final IValuePrinter printer = calculator.printer;
            calculator.environment.setGlobalSymbol("p", new ICallable<E>(){

                @Override
                public void call(Frame<E> frame, OptionalInt argumentsCount, OptionalInt returnsCount) {
                    Preconditions.checkNotNull((Object)sender, (Object)"DERP");
                    if (!returnsCount.compareIfPresent(0)) {
                        throw new StackValidationException("This function does not return any values");
                    }
                    Stack stack = frame.stack();
                    int in = argumentsCount.or(1);
                    ArrayList results = Lists.newArrayListWithExpectedSize((int)in);
                    for (int i = 0; i < in; ++i) {
                        Object value = stack.pop();
                        results.add(printer.repr(value));
                    }
                    String result = ": " + Joiner.on((String)" ").join((Iterable)results);
                    sender.func_145747_a((ITextComponent)new TextComponentString(result));
                }
            });
            calculator.environment.setGlobalSymbol("print", new UnaryFunction.Direct<E>(){

                @Override
                protected E call(E value) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(printer.str(value)));
                    return value;
                }
            });
            return calculator;
        }

        public synchronized <E> E call(ICommandSender sender, IFunction<E> function) {
            this.sender = sender;
            E result = function.call();
            this.sender = null;
            return result;
        }
    }

    private static interface IFunction<E> {
        public E call();
    }

    public static class NoSuchNameException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public NoSuchNameException(String message) {
            super(message);
        }
    }
}

