/*
 * Decompiled with CFR 0.152.
 */
package openmods.model.eval;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import openmods.model.ModelUpdater;
import openmods.model.eval.EvaluatorFactory;
import openmods.utils.CollectionUtils;

public abstract class EvalModelBase
implements IModel {
    protected final Optional<ResourceLocation> baseModel;
    protected final EvaluatorFactory evaluatorFactory;

    protected EvalModelBase(Optional<ResourceLocation> baseModel, EvaluatorFactory evaluator) {
        this.baseModel = baseModel;
        this.evaluatorFactory = evaluator;
    }

    public Collection<ResourceLocation> getDependencies() {
        return CollectionUtils.asSet(this.baseModel);
    }

    public Collection<ResourceLocation> getTextures() {
        return ImmutableList.of();
    }

    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }

    protected IModel loadBaseModel(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        if (this.baseModel.isPresent()) {
            return ModelLoaderRegistry.getModelOrLogError((ResourceLocation)this.baseModel.get(), (String)("Couldn't load eval model dependency: " + this.baseModel.get()));
        }
        return ModelLoaderRegistry.getMissingModel();
    }

    public IModel process(ImmutableMap<String, String> customData) {
        ModelUpdater updater = new ModelUpdater((Map<String, String>)customData);
        Optional<ResourceLocation> baseModel = updater.get("base", ModelUpdater.MODEL_LOCATION, this.baseModel);
        EvaluatorFactory evaluatorFactory = updater.get("transforms", new ModelUpdater.ValueConverter<EvaluatorFactory>(){

            @Override
            public EvaluatorFactory convert(String name, JsonElement element) {
                EvaluatorFactory result = new EvaluatorFactory();
                if (element.isJsonArray()) {
                    for (JsonElement e : element.getAsJsonArray()) {
                        this.appendStatement(result, e);
                    }
                } else {
                    this.appendStatement(result, element);
                }
                return result;
            }

            private void appendStatement(EvaluatorFactory factory, JsonElement statement) {
                factory.appendStatement(statement.getAsString());
            }
        }, this.evaluatorFactory);
        return this.update((Map<String, String>)customData, updater, baseModel, evaluatorFactory);
    }

    protected abstract IModel update(Map<String, String> var1, ModelUpdater var2, Optional<ResourceLocation> var3, EvaluatorFactory var4);
}

