/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.blocks.absorbers;

import java.util.List;
import mcjty.lib.container.BaseBlock;
import mcjty.lib.container.EmptyContainer;
import mcjty.rftoolsdim.blocks.GenericRFToolsBlock;
import mcjty.rftoolsdim.blocks.absorbers.TimeAbsorberTileEntity;
import mcjty.rftoolsdim.config.DimletConstructionConfiguration;
import mcjty.rftoolsdim.dimensions.dimlets.DimletKey;
import mcjty.rftoolsdim.dimensions.dimlets.KnownDimletConfiguration;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class TimeAbsorberBlock
extends GenericRFToolsBlock<TimeAbsorberTileEntity, EmptyContainer> {
    public TimeAbsorberBlock() {
        super(Material.field_151573_f, TimeAbsorberTileEntity.class, EmptyContainer.class, "time_absorber", false);
    }

    public BaseBlock.RotationType getRotationType() {
        return BaseBlock.RotationType.NONE;
    }

    public boolean needsRedstoneCheck() {
        return true;
    }

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        TileEntity te = world.func_175625_s(data.getPos());
        if (te instanceof TimeAbsorberTileEntity) {
            TimeAbsorberTileEntity timeAbsorberTileEntity = (TimeAbsorberTileEntity)te;
            float angle = timeAbsorberTileEntity.getAngle();
            if (angle >= -0.01f) {
                DimletKey key = TimeAbsorberTileEntity.findBestTimeDimlet(angle);
                String name = KnownDimletConfiguration.getDisplayName(key);
                if (name == null) {
                    name = "<unknown>";
                }
                int absorbing = timeAbsorberTileEntity.getAbsorbing();
                int pct = (DimletConstructionConfiguration.maxTimeAbsorbtion - absorbing) * 100 / DimletConstructionConfiguration.maxTimeAbsorbtion;
                probeInfo.text(TextFormatting.GREEN + "Time: " + name).progress(pct, 100, probeInfo.defaultProgressStyle().suffix("%"));
            } else {
                probeInfo.text(TextFormatting.GREEN + "Give this block a redstone signal");
                probeInfo.text(TextFormatting.GREEN + "at the right time you want to absorb");
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currenttip, accessor, config);
        TileEntity te = accessor.getTileEntity();
        if (te instanceof TimeAbsorberTileEntity) {
            TimeAbsorberTileEntity timeAbsorberTileEntity = (TimeAbsorberTileEntity)te;
            float angle = timeAbsorberTileEntity.getAngle();
            if (angle >= -0.01f) {
                DimletKey key = TimeAbsorberTileEntity.findBestTimeDimlet(angle);
                String name = KnownDimletConfiguration.getDisplayName(key);
                if (name == null) {
                    name = "<unknown>";
                }
                int absorbing = timeAbsorberTileEntity.getAbsorbing();
                int pct = (DimletConstructionConfiguration.maxTimeAbsorbtion - absorbing) * 100 / DimletConstructionConfiguration.maxTimeAbsorbtion;
                currenttip.add(TextFormatting.GREEN + "Dimlet: " + name + " (" + angle + ", " + pct + "%)");
            } else {
                currenttip.add(TextFormatting.GREEN + "Give this block a redstone signal");
                currenttip.add(TextFormatting.GREEN + "at the right time you want to absorb");
            }
        }
        return currenttip;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack itemStack, World player, List<String> list, ITooltipFlag whatIsThis) {
        super.func_190948_a(itemStack, player, list, whatIsThis);
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null && tagCompound.func_74764_b("angle") && tagCompound.func_74760_g("angle") > -0.001f) {
            float angle = tagCompound.func_74760_g("angle");
            DimletKey key = TimeAbsorberTileEntity.findBestTimeDimlet(angle);
            String name = KnownDimletConfiguration.getDisplayName(key);
            if (name == null) {
                name = "<unknown>";
            }
            list.add(TextFormatting.GREEN + "Dimlet: " + name + " (" + angle + ")");
            int absorbing = tagCompound.func_74762_e("absorbing");
            int pct = (DimletConstructionConfiguration.maxTimeAbsorbtion - absorbing) * 100 / DimletConstructionConfiguration.maxTimeAbsorbtion;
            list.add(TextFormatting.GREEN + "Absorbed: " + pct + "%");
            int timeout = tagCompound.func_74762_e("registerTimeout");
            list.add(TextFormatting.GREEN + "Timeout: " + timeout);
        }
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add(TextFormatting.WHITE + "Place this block outside and give it a redstone");
            list.add(TextFormatting.WHITE + "signal around the time that you want to absorb.");
            list.add(TextFormatting.WHITE + "You can use the end result in the Dimlet Workbench.");
        } else {
            list.add(TextFormatting.WHITE + "<Press Shift>");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public int getGuiID() {
        return -1;
    }
}

