/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.blocks.absorbers;

import java.util.Random;
import mcjty.lib.entity.GenericTileEntity;
import mcjty.rftoolsdim.config.DimletConstructionConfiguration;
import mcjty.rftoolsdim.dimensions.dimlets.DimletKey;
import mcjty.rftoolsdim.dimensions.dimlets.DimletObjectMapping;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;

public class TimeAbsorberTileEntity
extends GenericTileEntity
implements ITickable {
    private int absorbing = 0;
    private float angle = -1.0f;
    private boolean prevIn = false;
    private int registerTimeout = 0;

    public void func_73660_a() {
        if (this.func_145831_w().field_72995_K) {
            this.checkStateClient();
        } else {
            this.checkStateServer();
        }
    }

    private void checkStateClient() {
        if (this.absorbing > 0) {
            Random rand = this.func_145831_w().field_73012_v;
            double u = rand.nextFloat() * 2.0f - 1.0f;
            double v = (float)((double)(rand.nextFloat() * 2.0f) * Math.PI);
            double x = Math.sqrt(1.0 - u * u) * Math.cos(v);
            double y = Math.sqrt(1.0 - u * u) * Math.sin(v);
            double z = u;
            double r = 1.0;
            this.func_145831_w().func_175688_a(EnumParticleTypes.PORTAL, (double)((float)this.func_174877_v().func_177958_n() + 0.5f) + x * r, (double)((float)this.func_174877_v().func_177956_o() + 0.5f) + y * r, (double)((float)this.func_174877_v().func_177952_p() + 0.5f) + z * r, -x, -y, -z, new int[0]);
        }
    }

    private void checkStateServer() {
        boolean newvalue = this.powerLevel > 0;
        boolean pulse = newvalue && !this.prevIn;
        this.prevIn = newvalue;
        this.func_70296_d();
        if (this.registerTimeout > 0) {
            --this.registerTimeout;
            return;
        }
        if (pulse) {
            this.registerTime();
        }
    }

    public int getAbsorbing() {
        return this.absorbing;
    }

    public float getAngle() {
        return this.angle;
    }

    public int getRegisterTimeout() {
        return this.registerTimeout;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74757_a("prevIn", this.prevIn);
        return tagCompound;
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        tagCompound.func_74768_a("absorbing", this.absorbing);
        tagCompound.func_74776_a("angle", this.angle);
        tagCompound.func_74768_a("registerTimeout", this.registerTimeout);
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.prevIn = tagCompound.func_74767_n("prevIn");
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.absorbing = tagCompound.func_74762_e("absorbing");
        this.angle = tagCompound.func_74764_b("angle") ? tagCompound.func_74760_g("angle") : -1.0f;
        this.registerTimeout = tagCompound.func_74762_e("registerTimeout");
    }

    private void registerTime() {
        if (this.func_145831_w().func_175710_j(this.func_174877_v())) {
            float a = this.func_145831_w().func_72826_c(1.0f);
            DimletKey bestDimlet = TimeAbsorberTileEntity.findBestTimeDimlet(a);
            float besta = DimletObjectMapping.getCelestialAngle(bestDimlet).floatValue();
            if (this.angle < -0.001f) {
                this.angle = besta;
                this.absorbing = DimletConstructionConfiguration.maxTimeAbsorbtion - 1;
            } else if (Math.abs(besta - this.angle) < 0.1f) {
                --this.absorbing;
                if (this.absorbing < 0) {
                    this.absorbing = 0;
                }
                this.registerTimeout = 3000;
            } else {
                ++this.absorbing;
                if (this.absorbing >= DimletConstructionConfiguration.maxTimeAbsorbtion) {
                    this.absorbing = DimletConstructionConfiguration.maxTimeAbsorbtion - 1;
                }
            }
        }
    }

    public static DimletKey findBestTimeDimlet(float a) {
        float bestDiff = 10000.0f;
        DimletKey bestDimlet = null;
        for (DimletKey dimlet : DimletObjectMapping.getCelestialAngles()) {
            Float celangle = DimletObjectMapping.getCelestialAngle(dimlet);
            if (celangle == null) continue;
            float diff = Math.abs(a - celangle.floatValue());
            if (diff < bestDiff) {
                bestDiff = diff;
                bestDimlet = dimlet;
            }
            if ((diff = Math.abs(a - 1.0f - celangle.floatValue())) < bestDiff) {
                bestDiff = diff;
                bestDimlet = dimlet;
            }
            if (!((diff = Math.abs(a + 1.0f - celangle.floatValue())) < bestDiff)) continue;
            bestDiff = diff;
            bestDimlet = dimlet;
        }
        return bestDimlet;
    }
}

