/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.blocks.enscriber;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import mcjty.lib.container.DefaultSidedInventory;
import mcjty.lib.container.InventoryHelper;
import mcjty.lib.entity.GenericTileEntity;
import mcjty.lib.network.Argument;
import mcjty.lib.varia.Logging;
import mcjty.rftoolsdim.blocks.enscriber.DimensionEnscriberContainer;
import mcjty.rftoolsdim.config.GeneralConfiguration;
import mcjty.rftoolsdim.config.Settings;
import mcjty.rftoolsdim.dimensions.DimensionInformation;
import mcjty.rftoolsdim.dimensions.RfToolsDimensionManager;
import mcjty.rftoolsdim.dimensions.description.DimensionDescriptor;
import mcjty.rftoolsdim.dimensions.dimlets.DimletKey;
import mcjty.rftoolsdim.dimensions.dimlets.DimletObjectMapping;
import mcjty.rftoolsdim.dimensions.dimlets.KnownDimletConfiguration;
import mcjty.rftoolsdim.dimensions.dimlets.types.DimletType;
import mcjty.rftoolsdim.dimensions.types.SpecialType;
import mcjty.rftoolsdim.items.ModItems;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public class DimensionEnscriberTileEntity
extends GenericTileEntity
implements DefaultSidedInventory {
    public static final String CMD_STORE = "store";
    public static final String CMD_EXTRACT = "extract";
    public static final String CMD_SETNAME = "setName";
    private boolean tabSlotHasChanged = false;
    private InventoryHelper inventoryHelper = new InventoryHelper((TileEntity)this, DimensionEnscriberContainer.factory, 92);

    protected boolean needsCustomInvWrapper() {
        return true;
    }

    public int[] func_180463_a(EnumFacing side) {
        return DimensionEnscriberContainer.factory.getAccessibleSlots();
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return DimensionEnscriberContainer.factory.isInputSlot(index);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return DimensionEnscriberContainer.factory.isOutputSlot(index);
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_191420_l() {
        return false;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.canPlayerAccess(player);
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
    }

    public InventoryHelper getInventoryHelper() {
        return this.inventoryHelper;
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.readBufferFromNBT(tagCompound, this.inventoryHelper);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        return tagCompound;
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.writeBufferToNBT(tagCompound, this.inventoryHelper);
    }

    private void storeDimlets(EntityPlayerMP player) {
        if (GeneralConfiguration.ownerDimletsNeeded && this.checkOwnerDimlet()) {
            Logging.warn((EntityPlayer)player, (String)"You need an owner dimlet to make a dimension!");
            return;
        }
        DimensionDescriptor descriptor = this.convertToDimensionDescriptor((EntityPlayer)player);
        ItemStack realizedTab = DimensionEnscriberTileEntity.createRealizedTab(descriptor, this.func_145831_w());
        this.inventoryHelper.setStackInSlot(91, realizedTab);
        this.func_70296_d();
    }

    private boolean checkOwnerDimlet() {
        boolean owner = false;
        for (int i = 0; i < 91; ++i) {
            DimletKey key;
            ItemStack stack = this.inventoryHelper.getStackInSlot(i + 0);
            if (stack.func_190926_b() || (key = KnownDimletConfiguration.getDimletKey(stack)).getType() != DimletType.DIMLET_SPECIAL || DimletObjectMapping.getSpecial(key) != SpecialType.SPECIAL_OWNER) continue;
            owner = true;
            break;
        }
        return !owner;
    }

    public static ItemStack createRealizedTab(DimensionDescriptor descriptor, World world) {
        ItemStack realizedTab = new ItemStack((Item)ModItems.realizedDimensionTabItem, 1, 0);
        NBTTagCompound tagCompound = new NBTTagCompound();
        descriptor.writeToNBT(tagCompound);
        RfToolsDimensionManager manager = RfToolsDimensionManager.getDimensionManager(world);
        Integer id = manager.getDimensionID(descriptor);
        if (id != null) {
            tagCompound.func_74768_a("ticksLeft", 0);
            tagCompound.func_74768_a("id", id.intValue());
        }
        realizedTab.func_77982_d(tagCompound);
        return realizedTab;
    }

    private DimensionDescriptor convertToDimensionDescriptor(EntityPlayer player) {
        ArrayList<DimletKey> descriptors = new ArrayList<DimletKey>();
        long forcedSeed = 0L;
        for (int i = 0; i < 91; ++i) {
            ItemStack stack = this.inventoryHelper.getStackInSlot(i + 0);
            if (stack.func_190926_b()) continue;
            DimletKey key = KnownDimletConfiguration.getDimletKey(stack);
            Settings settings = KnownDimletConfiguration.getSettings(key);
            if (settings != null) {
                descriptors.add(key);
                NBTTagCompound tagCompound = stack.func_77978_p();
                if (tagCompound != null && tagCompound.func_74763_f("forcedSeed") != 0L) {
                    forcedSeed = tagCompound.func_74763_f("forcedSeed");
                }
                this.inventoryHelper.setStackInSlot(i + 0, ItemStack.field_190927_a);
                continue;
            }
            Logging.warn((EntityPlayer)player, (String)("Dimlet " + key.getType().dimletType.getName() + "." + key.getId() + " was not included in the tab because it is blacklisted"));
        }
        return new DimensionDescriptor(descriptors, forcedSeed);
    }

    private void extractDimlets() {
        ItemStack realizedTab = this.inventoryHelper.getStackInSlot(91);
        NBTTagCompound tagCompound = realizedTab.func_77978_p();
        if (tagCompound != null) {
            int skip;
            int idx;
            long forcedSeed = tagCompound.func_74763_f("forcedSeed");
            List<DimletKey> descriptors = DimensionDescriptor.parseDescriptionString(tagCompound.func_74779_i("descriptionString"));
            if (91 >= 2 * descriptors.size()) {
                idx = 1;
                skip = 2;
            } else {
                idx = 0;
                skip = 1;
            }
            for (DimletKey descriptor : descriptors) {
                int id = tagCompound.func_74762_e("id");
                if (GeneralConfiguration.ownerDimletsNeeded && id != 0 && descriptor.getType() == DimletType.DIMLET_SPECIAL && DimletObjectMapping.getSpecial(descriptor) == SpecialType.SPECIAL_OWNER) continue;
                ItemStack dimletStack = KnownDimletConfiguration.getDimletStack(descriptor);
                if (descriptor.getType() == DimletType.DIMLET_SPECIAL && DimletObjectMapping.getSpecial(descriptor) == SpecialType.SPECIAL_SEED) {
                    dimletStack.func_77978_p().func_74772_a("forcedSeed", forcedSeed);
                }
                this.inventoryHelper.setStackInSlot(idx, dimletStack);
                idx += skip;
            }
        }
        this.inventoryHelper.setStackInSlot(91, new ItemStack((Item)ModItems.emptyDimensionTabItem));
        this.func_70296_d();
    }

    private void setName(String name) {
        ItemStack realizedTab = this.inventoryHelper.getStackInSlot(91);
        if (!realizedTab.func_190926_b()) {
            NBTTagCompound tagCompound = realizedTab.func_77978_p();
            if (tagCompound == null) {
                tagCompound = new NBTTagCompound();
                realizedTab.func_77982_d(tagCompound);
            }
            tagCompound.func_74778_a("name", name);
            if (tagCompound.func_74764_b("id")) {
                Integer id = tagCompound.func_74762_e("id");
                RfToolsDimensionManager dimensionManager = RfToolsDimensionManager.getDimensionManager(this.func_145831_w());
                DimensionInformation information = dimensionManager.getDimensionInformation(id);
                if (information != null) {
                    information.setName(name);
                    dimensionManager.save(this.func_145831_w());
                }
            }
            this.func_70296_d();
        }
    }

    public void onSlotChanged(int index, ItemStack stack) {
        if (this.func_145831_w().field_72995_K && index == 91) {
            this.tabSlotHasChanged = true;
        }
    }

    public boolean hasTabSlotChangedAndClear() {
        boolean rc = this.tabSlotHasChanged;
        this.tabSlotHasChanged = false;
        return rc;
    }

    public boolean execute(EntityPlayerMP playerMP, String command, Map<String, Argument> args) {
        boolean rc = super.execute(playerMP, command, args);
        if (rc) {
            return true;
        }
        if (CMD_STORE.equals(command)) {
            this.storeDimlets(playerMP);
            this.setName(args.get("name").getString());
            return true;
        }
        if (CMD_EXTRACT.equals(command)) {
            this.extractDimlets();
            return true;
        }
        if (CMD_SETNAME.equals(command)) {
            this.setName(args.get("name").getString());
            return true;
        }
        return false;
    }
}

