/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.dimensions.dimlets;

import mcjty.rftoolsdim.dimensions.dimlets.types.DimletType;

public class DimletKey
implements Comparable<DimletKey> {
    private final DimletType type;
    private final String id;

    public DimletKey(DimletType type, String id) {
        this.type = type;
        this.id = id;
    }

    public DimletType getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DimletKey dimletKey = (DimletKey)o;
        if (this.type != dimletKey.type) {
            return false;
        }
        return this.id.equals(dimletKey.id);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        if (this.id != null) {
            result = 31 * result + this.id.hashCode();
        }
        return result;
    }

    public String toString() {
        return this.type.dimletType.getOpcode() + this.id;
    }

    public static DimletKey parseKey(String skey) {
        String opcode = skey.substring(0, 1);
        String name = skey.substring(1);
        return new DimletKey(DimletType.getTypeByOpcode(opcode), name);
    }

    @Override
    public int compareTo(DimletKey o) {
        int result = this.type.compareTo(o.type);
        if (result != 0) {
            return result;
        }
        return this.id.compareTo(o.id);
    }
}

