/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.items;

import java.util.List;
import mcjty.lib.varia.Logging;
import mcjty.rftoolsdim.config.PowerConfiguration;
import mcjty.rftoolsdim.dimensions.DimensionInformation;
import mcjty.rftoolsdim.dimensions.DimensionStorage;
import mcjty.rftoolsdim.dimensions.RfToolsDimensionManager;
import mcjty.rftoolsdim.items.GenericRFToolsItem;
import mcjty.rftoolsdim.network.PacketGetDimensionEnergy;
import mcjty.rftoolsdim.network.RFToolsDimMessages;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class DimensionMonitorItem
extends GenericRFToolsItem {
    private static long lastTime = 0L;

    public DimensionMonitorItem() {
        super("dimension_monitor");
        this.func_77625_d(1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        for (int i = 0; i <= 8; ++i) {
            ResourceLocation registryName = this.getRegistryName();
            registryName = new ResourceLocation(registryName.func_110624_b(), registryName.func_110623_a() + i);
            ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation(registryName, "inventory")});
        }
        ModelLoader.setCustomMeshDefinition((Item)this, stack -> {
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            int id = world.field_73011_w.getDimension();
            DimensionStorage storage = DimensionStorage.getDimensionStorage((World)world);
            int energyLevel = storage.getEnergyLevel(id);
            int level = 9 * energyLevel / PowerConfiguration.MAX_DIMENSION_POWER;
            if (level < 0) {
                level = 0;
            } else if (level > 8) {
                level = 8;
            }
            ResourceLocation registryName = this.getRegistryName();
            registryName = new ResourceLocation(registryName.func_110624_b(), registryName.func_110623_a() + (8 - level));
            return new ModelResourceLocation(registryName, "inventory");
        });
    }

    public int func_77626_a(ItemStack stack) {
        return 1;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            int id = player.func_130014_f_().field_73011_w.getDimension();
            RfToolsDimensionManager dimensionManager = RfToolsDimensionManager.getDimensionManager(player.func_130014_f_());
            DimensionInformation dimensionInformation = dimensionManager.getDimensionInformation(id);
            if (dimensionInformation == null) {
                Logging.message((EntityPlayer)player, (String)"Not an RFTools dimension!");
            } else {
                String name = dimensionInformation.getName();
                DimensionStorage storage = DimensionStorage.getDimensionStorage(player.func_130014_f_());
                int power = storage != null ? storage.getEnergyLevel(id) : 0;
                Logging.message((EntityPlayer)player, (String)(TextFormatting.BLUE + "Name: " + name + " (Id " + id + ")" + TextFormatting.YELLOW + "    Power: " + power + " RF"));
                if (player.func_70093_af()) {
                    Logging.message((EntityPlayer)player, (String)(TextFormatting.RED + "Description: " + dimensionInformation.getDescriptor().getDescriptionString()));
                    System.out.println("Description:  = " + dimensionInformation.getDescriptor().getDescriptionString());
                }
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, World world, List<String> list, ITooltipFlag whatIsThis) {
        DimensionInformation dimensionInformation;
        super.func_77624_a(itemStack, world, list, whatIsThis);
        if (world == null || world.field_73011_w == null) {
            return;
        }
        int id = world.field_73011_w.getDimension();
        RfToolsDimensionManager dimensionManager = RfToolsDimensionManager.getDimensionManagerClientNullable(world);
        DimensionInformation dimensionInformation2 = dimensionInformation = dimensionManager == null ? null : dimensionManager.getDimensionInformation(id);
        if (dimensionInformation == null) {
            list.add("Not an RFTools dimension!");
        } else {
            if (System.currentTimeMillis() - lastTime > 500L) {
                lastTime = System.currentTimeMillis();
                RFToolsDimMessages.INSTANCE.sendToServer((IMessage)new PacketGetDimensionEnergy(id));
            }
            String name = dimensionInformation.getName();
            DimensionStorage storage = DimensionStorage.getDimensionStorage(world);
            int power = storage != null ? storage.getEnergyLevel(id) : 0;
            list.add(TextFormatting.BLUE + "Name: " + name + " (Id " + id + ")");
            list.add(TextFormatting.YELLOW + "Power: " + power + " RF");
        }
    }
}

