/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorageaddons;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.config.IConfigElement;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public final class RSAddonsConfig {
    private Configuration config;
    public int networkPickerUsage;
    public boolean networkPickerUsesEnergy;
    public int networkBagUsage;
    public boolean networkBagUsesEnergy;
    public int infiniteWirelessTransmitterUsage;
    public int infiniteWirelessTransmitterRange;
    public boolean wirelessCraftingGridUsesEnergy;
    public int wirelessCraftingGridOpenUsage;
    public int wirelessCraftingGridExtractUsage;
    public int wirelessCraftingGridInsertUsage;
    public int wirelessCraftingGridCraftUsage;
    private static final String NETWORK_PICKER = "networkPicker";
    private static final String NETWORK_BAG = "networkBag";
    private static final String INFINITE_WIRELESS_TRANSMITTER = "infiniteWirelessTransmitter";
    private static final String WIRELESS_CRAFTING_GRID = "wirelessCraftingGrid";

    public RSAddonsConfig(File configFile) {
        this.config = new Configuration(configFile);
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.loadConfig();
    }

    public Configuration getConfig() {
        return this.config;
    }

    @SubscribeEvent
    public void onConfigChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equalsIgnoreCase("refinedstorageaddons")) {
            this.loadConfig();
        }
    }

    private void loadConfig() {
        this.networkPickerUsesEnergy = this.config.getBoolean("usesEnergy", NETWORK_PICKER, true, "Whether the Network Picker uses energy");
        this.networkPickerUsage = this.config.getInt("usage", NETWORK_PICKER, 45, 0, Integer.MAX_VALUE, "The energy used by the Network Picker");
        this.networkBagUsesEnergy = this.config.getBoolean("usesEnergy", NETWORK_BAG, true, "Whether the Network Bag uses energy");
        this.networkBagUsage = this.config.getInt("usage", NETWORK_BAG, 15, 0, Integer.MAX_VALUE, "The energy used by the Network Bag");
        this.infiniteWirelessTransmitterUsage = this.config.getInt("infiniteWirelessTransmitterUsage", INFINITE_WIRELESS_TRANSMITTER, 1000, 0, Integer.MAX_VALUE, "The energy used by the Infinite Wireless Transmitter");
        this.infiniteWirelessTransmitterRange = this.config.getInt("infiniteWirelessTransmitterRange", INFINITE_WIRELESS_TRANSMITTER, Integer.MAX_VALUE, 0, Integer.MAX_VALUE, "The range of the Infinite Wireless Transmitter");
        this.wirelessCraftingGridUsesEnergy = this.config.getBoolean("usesEnergy", WIRELESS_CRAFTING_GRID, true, "Whether the Wireless Crafting Grid uses energy");
        this.wirelessCraftingGridOpenUsage = this.config.getInt("open", WIRELESS_CRAFTING_GRID, 30, 0, Integer.MAX_VALUE, "The energy used by the Wireless Crafting Grid to open");
        this.wirelessCraftingGridInsertUsage = this.config.getInt("insert", WIRELESS_CRAFTING_GRID, 3, 0, Integer.MAX_VALUE, "The energy used by the Wireless Crafting Grid to insert items");
        this.wirelessCraftingGridExtractUsage = this.config.getInt("extract", WIRELESS_CRAFTING_GRID, 3, 0, Integer.MAX_VALUE, "The energy used by the Wireless Crafting Grid to extract items");
        this.wirelessCraftingGridCraftUsage = this.config.getInt("craft", WIRELESS_CRAFTING_GRID, 1, 0, Integer.MAX_VALUE, "The energy used by the Wireless Crafting Grid to craft a single item");
        if (this.config.hasChanged()) {
            this.config.save();
        }
    }

    public List<IConfigElement> getConfigElements() {
        ArrayList<IConfigElement> list = new ArrayList<IConfigElement>();
        list.addAll(new ConfigElement(this.config.getCategory(NETWORK_PICKER)).getChildElements());
        list.addAll(new ConfigElement(this.config.getCategory(NETWORK_BAG)).getChildElements());
        list.addAll(new ConfigElement(this.config.getCategory(INFINITE_WIRELESS_TRANSMITTER)).getChildElements());
        list.addAll(new ConfigElement(this.config.getCategory(WIRELESS_CRAFTING_GRID)).getChildElements());
        return list;
    }
}

