/*
 * Decompiled with CFR 0.152.
 */
package com.mrtrollnugnug.ropebridge.handler;

import com.mrtrollnugnug.ropebridge.handler.ConfigurationHandler;
import com.mrtrollnugnug.ropebridge.handler.ContentHandler;
import com.mrtrollnugnug.ropebridge.handler.SlabPosHandler;
import com.mrtrollnugnug.ropebridge.lib.ModUtils;
import java.util.LinkedList;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.block.Block;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BridgeBuildingHandler {
    private static String woodSlab = "tile.woodSlab";

    public static void newBridge(EntityPlayer player, ItemStack stack, int inputType, BlockPos pos1, BlockPos pos2) {
        int type;
        int z2;
        int y2;
        int x2;
        int z1;
        int y1;
        int x1;
        LinkedList<SlabPosHandler> bridge = new LinkedList<SlabPosHandler>();
        boolean allClear = true;
        boolean rotate = BridgeBuildingHandler.getRotate(pos1, pos2);
        if (!rotate) {
            x1 = pos1.func_177958_n();
            y1 = pos1.func_177956_o();
            z1 = pos1.func_177952_p();
            x2 = pos2.func_177958_n();
            y2 = pos2.func_177956_o();
            z2 = pos2.func_177952_p();
        } else {
            x1 = pos1.func_177952_p();
            y1 = pos1.func_177956_o();
            z1 = pos1.func_177958_n();
            x2 = pos2.func_177952_p();
            y2 = pos2.func_177956_o();
            z2 = pos2.func_177958_n();
        }
        if (Math.abs(z2 - z1) > 3) {
            ModUtils.tellPlayer((ICommandSender)player, "chat.ropebridge.info.notcardinal", new Object[0]);
            return;
        }
        double m = (double)(y2 - y1) / (double)(x2 - x1);
        if (!ConfigurationHandler.isIgnoreSlopeWarnings() && Math.abs(m) > 0.2) {
            ModUtils.tellPlayer((ICommandSender)player, "chat.ropebridge.info.greatslope", new Object[0]);
            return;
        }
        double b = (double)y1 - m * (double)x1;
        double distance = Math.abs(x2 - x1);
        int distInt = Math.abs(x2 - x1);
        if (distInt < 2) {
            return;
        }
        if (!player.field_71075_bZ.field_75098_d && !BridgeBuildingHandler.hasMaterials(player, distInt - 1)) {
            return;
        }
        for (int x = Math.min(x1, x2) + 1; x <= Math.max(x1, x2) - 1; ++x) {
            for (int y = Math.max(y1, y2); y >= Math.min(y1, y2) - distInt / 8 - 1; --y) {
                double funcVal = m * (double)x + b - distance / 1000.0 * Math.sin((double)(x - Math.min(x1, x2)) * (Math.PI / distance)) * (double)ConfigurationHandler.getBridgeDroopFactor() + (double)ConfigurationHandler.getBridgeYOffset();
                if (!((double)y + 0.5 > funcVal) || !((double)y - 0.5 <= funcVal)) continue;
                int level = funcVal >= (double)y ? (funcVal >= (double)y + 0.25 ? 4 : 3) : (funcVal >= (double)y - 0.25 ? 2 : 1);
                allClear = !BridgeBuildingHandler.addSlab(player.field_70170_p, bridge, x, y + 1, z1, level, rotate) ? false : allClear;
            }
        }
        if (allClear) {
            int n = type = inputType == -1 ? BridgeBuildingHandler.getWoodType(player) : inputType;
            if (inputType == -1 && !player.field_71075_bZ.field_75098_d) {
                BridgeBuildingHandler.takeMaterials(player, distInt - 1);
                stack.func_77972_a(1, (EntityLivingBase)player);
            }
        } else {
            ModUtils.tellPlayer((ICommandSender)player, "chat.ropebridge.info.obstruction", new Object[0]);
            return;
        }
        BridgeBuildingHandler.buildBridge(player.field_70170_p, bridge, type);
    }

    private static boolean getRotate(BlockPos p1, BlockPos p2) {
        return Math.abs(p1.func_177958_n() - p2.func_177958_n()) <= Math.abs(p1.func_177952_p() - p2.func_177952_p());
    }

    private static boolean hasMaterials(EntityPlayer player, int dist) {
        if (player.field_71075_bZ.field_75098_d) {
            return true;
        }
        int slabsNeeded = dist;
        int stringNeeded = 1 + dist / 2;
        int slabsHad = 0;
        int stringHad = 0;
        for (int i = 0; i < 36; ++i) {
            ItemStack stack = (ItemStack)player.field_71071_by.field_70462_a.get(i);
            if (stack == null) continue;
            Item item = stack.func_77973_b();
            if (item == ContentHandler.itemRope) {
                stringHad += stack.func_190916_E();
            }
            if (!item.func_77658_a().equals(woodSlab)) continue;
            slabsHad += stack.func_190916_E();
        }
        if (slabsHad >= slabsNeeded && stringHad >= stringNeeded) {
            return true;
        }
        ModUtils.tellPlayer((ICommandSender)player, "chat.ropebridge.info.underfunded_bridge", slabsNeeded, stringNeeded);
        return false;
    }

    private static void takeMaterials(EntityPlayer player, int dist) {
        if (player.field_71075_bZ.field_75098_d) {
            return;
        }
        int slabsNeeded = dist;
        int stringNeeded = 1 + dist / 2;
        for (int i = 0; i < 36; ++i) {
            ItemStack stack = (ItemStack)player.field_71071_by.field_70462_a.get(i);
            if (stack == null) continue;
            Item item = stack.func_77973_b();
            String name = item.func_77658_a();
            if (item == ContentHandler.itemRope) {
                if (stack.func_190916_E() <= stringNeeded) continue;
                stack.func_190918_g(stringNeeded);
                stringNeeded = 0;
                continue;
            }
            if (!name.equals(woodSlab) || stack.func_190916_E() <= slabsNeeded) continue;
            stack.func_190918_g(stringNeeded);
            slabsNeeded = 0;
        }
    }

    private static boolean addSlab(World world, LinkedList<SlabPosHandler> list, int x, int y, int z, int level, boolean rotate) {
        BlockPos pos = rotate ? new BlockPos(z, y, x) : new BlockPos(x, y, z);
        boolean isClear = ConfigurationHandler.isBreakThroughBlocks() || world.func_175623_d(pos) || world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos);
        list.add(new SlabPosHandler(pos, level, rotate));
        if (!isClear) {
            BridgeBuildingHandler.spawnSmoke(world, pos, 15);
        }
        return isClear;
    }

    private static void spawnSmoke(World world, BlockPos pos, int times) {
        if (times > 0) {
            world.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 0.0, 0.0, 0.0, new int[0]);
            final World finworld = world;
            final BlockPos finPos = pos;
            final int finTimes = times - 1;
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    BridgeBuildingHandler.spawnSmoke(finworld, finPos, finTimes);
                }
            }, 1000L);
        }
    }

    private static void buildBridge(final World world, final LinkedList<SlabPosHandler> bridge, final int type) {
        if (!bridge.isEmpty()) {
            Block block;
            SlabPosHandler slab = bridge.pop();
            switch (slab.getLevel()) {
                case 1: {
                    block = ContentHandler.blockBridgeSlab1;
                    break;
                }
                case 2: {
                    block = ContentHandler.blockBridgeSlab2;
                    break;
                }
                case 3: {
                    block = ContentHandler.blockBridgeSlab3;
                    break;
                }
                case 4: {
                    block = ContentHandler.blockBridgeSlab4;
                    break;
                }
                default: {
                    block = Blocks.field_150350_a;
                }
            }
            world.func_180501_a(slab.getBlockPos(), block.func_176203_a((slab.getRotate() ? 1 : 0) + 2 * type), 3);
            BridgeBuildingHandler.spawnSmoke(world, new BlockPos(slab.getBlockPos().func_177958_n(), slab.getBlockPos().func_177956_o(), slab.getBlockPos().func_177952_p()), 1);
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    BridgeBuildingHandler.buildBridge(world, bridge, type);
                }
            }, 100L);
        }
    }

    private static int getWoodType(EntityPlayer player) {
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            String name;
            if (stack == null || !(name = stack.func_77973_b().func_77658_a()).equals(woodSlab)) continue;
            return stack.func_77952_i();
        }
        return 0;
    }
}

