/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.model;

import com.google.common.collect.Lists;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.init.Items;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import openmods.geometry.AabbBuilder;
import openmods.renderer.DisplayListWrapper;
import org.lwjgl.opengl.GL11;

public class ModelCartographer
extends ModelBase {
    private static final float SCALE = 0.0625f;
    private final ModelRenderer body;
    private final ModelRenderer base;
    private DisplayListWrapper eyeList;

    public ModelCartographer() {
        this.field_78090_t = 32;
        this.field_78089_u = 32;
        this.body = new ModelRenderer((ModelBase)this, 0, 0);
        this.body.func_78789_a(-2.5f, -1.5f, -2.5f, 5, 2, 5);
        this.base = new ModelRenderer((ModelBase)this);
        this.body.func_78792_a(this.base);
        this.base.func_78784_a(0, 7);
        this.base.func_78789_a(-1.5f, 0.5f, -1.5f, 3, 1, 3);
        this.base.func_78784_a(0, 11);
        this.base.func_78789_a(-0.5f, 0.5f, -2.5f, 1, 4, 1);
        this.base.func_78784_a(4, 11);
        this.base.func_78789_a(-0.5f, 0.5f, 1.5f, 1, 4, 1);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void renderEye(float baseRotation, float eyeRotation) {
        if (this.eyeList != null) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)0.25f, (float)0.0f);
            GL11.glRotated((double)(Math.toDegrees(baseRotation) + 90.0), (double)0.0, (double)1.0, (double)0.0);
            GL11.glRotated((double)Math.toDegrees(eyeRotation), (double)1.0, (double)0.0, (double)0.0);
            GL11.glScalef((float)0.1875f, (float)0.1875f, (float)0.1875f);
            this.eyeList.compile();
            GL11.glPopMatrix();
        }
    }

    public void renderBase(float baseRotation) {
        this.base.field_78796_g = baseRotation;
        this.body.func_78785_a(0.0625f);
    }

    @SubscribeEvent
    public void onModelBake(ModelBakeEvent evt) {
        ModelResourceLocation modelLocation = new ModelResourceLocation(Items.field_151061_bv.getRegistryName(), "inventory");
        IBakedModel bakedModel = (IBakedModel)evt.getModelRegistry().func_82594_a((Object)modelLocation);
        this.setEyeRender(bakedModel);
    }

    private void setEyeRender(IBakedModel model) {
        final ArrayList quads = Lists.newArrayList();
        quads.addAll(model.func_188616_a(null, EnumFacing.WEST, 0L));
        quads.addAll(model.func_188616_a(null, EnumFacing.EAST, 0L));
        quads.addAll(model.func_188616_a(null, EnumFacing.NORTH, 0L));
        quads.addAll(model.func_188616_a(null, EnumFacing.SOUTH, 0L));
        quads.addAll(model.func_188616_a(null, EnumFacing.UP, 0L));
        quads.addAll(model.func_188616_a(null, EnumFacing.DOWN, 0L));
        quads.addAll(model.func_188616_a(null, null, 0L));
        AabbBuilder allBoundsBuilder = AabbBuilder.create();
        AabbBuilder horizontalBoundsBuilder = AabbBuilder.create();
        for (BakedQuad quad : quads) {
            if (quad.func_178210_d() == EnumFacing.EAST || quad.func_178210_d() == EnumFacing.WEST) {
                ModelCartographer.addQuad(quad, horizontalBoundsBuilder);
            }
            ModelCartographer.addQuad(quad, allBoundsBuilder);
        }
        AxisAlignedBB horizontalBounds = horizontalBoundsBuilder.build();
        AxisAlignedBB allBounds = allBoundsBuilder.build();
        AxisAlignedBB scaleBounds = !horizontalBounds.func_181656_b() ? horizontalBounds : allBounds;
        final double scale = 1.0 / (scaleBounds.field_72336_d - scaleBounds.field_72340_a);
        final double middleX = (allBounds.field_72336_d + allBounds.field_72340_a) / 2.0;
        final double middleY = (allBounds.field_72337_e + allBounds.field_72338_b) / 2.0;
        final double middleZ = (allBounds.field_72334_f + allBounds.field_72339_c) / 2.0;
        this.eyeList = new DisplayListWrapper(){

            public void compile() {
                GL11.glPushMatrix();
                GL11.glScaled((double)scale, (double)scale, (double)scale);
                GL11.glTranslated((double)(-middleX), (double)(-middleY), (double)(-middleZ));
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder vertexBuffer = tessellator.func_178180_c();
                vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_176599_b);
                for (BakedQuad quad : quads) {
                    vertexBuffer.func_178981_a(quad.func_178209_a());
                }
                tessellator.func_78381_a();
                GL11.glPopMatrix();
            }
        };
    }

    private static void addQuad(BakedQuad quad, AabbBuilder aabbBuilder) {
        int[] vertexData = quad.func_178209_a();
        ByteBuffer buffer = ByteBuffer.allocate(vertexData.length * 4);
        buffer.asIntBuffer().put(vertexData);
        int vertexSize = quad.getFormat().func_177338_f();
        buffer.limit(vertexData.length * 4);
        for (int i = 0; i < 4; ++i) {
            buffer.position(vertexSize * i);
            float x = buffer.getFloat();
            float y = buffer.getFloat();
            float z = buffer.getFloat();
            aabbBuilder.addPoint(x, y, z);
        }
    }
}

