/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.renderer;

import com.google.common.collect.Queues;
import java.util.Queue;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import openmods.utils.TextureUtils;

public class TextureUploader {
    public static final TextureUploader INSTANCE = new TextureUploader();
    private final Queue<IUploadableTexture> texturesToUpload = Queues.newConcurrentLinkedQueue();

    public void scheduleTextureUpload(IUploadableTexture texture) {
        this.texturesToUpload.add(texture);
    }

    @SubscribeEvent
    public void onRenderEnd(RenderWorldLastEvent evt) {
        IUploadableTexture t;
        TextureUtils.bindTextureToClient((ResourceLocation)TextureMap.field_110575_b);
        while ((t = this.texturesToUpload.poll()) != null) {
            t.upload();
        }
    }

    @SubscribeEvent
    public void onTextureStitchEvent(TextureStitchEvent.Pre evt) {
        this.texturesToUpload.clear();
    }

    public static interface IUploadableTexture {
        public void upload();
    }
}

