/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common;

import com.google.common.base.Function;
import net.minecraftforge.fluids.FluidStack;
import openblocks.Config;
import openmods.utils.EnchantmentUtils;

public class LiquidXpUtils {
    public static final int XP_PER_BOTTLE = 8;
    public static final Function<FluidStack, FluidStack> FLUID_TO_LEVELS = input -> {
        if (input == null) {
            return null;
        }
        FluidStack result = input.copy();
        result.amount = EnchantmentUtils.getLevelForExperience((int)LiquidXpUtils.liquidToXpRatio(input.amount));
        return result;
    };

    public static int liquidToXpRatio(int liquid) {
        return liquid / Config.xpToLiquidRatio;
    }

    public static int xpToLiquidRatio(int xp) {
        return xp * Config.xpToLiquidRatio;
    }

    public static int getLiquidForLevel(int level) {
        int xp = EnchantmentUtils.getExperienceForLevel((int)level);
        return LiquidXpUtils.xpToLiquidRatio(xp);
    }
}

