/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.block;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.common.property.Properties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import openblocks.common.tileentity.TileEntityPaintMixer;
import openmods.block.OpenBlock;
import openmods.colors.RGB;
import openmods.infobook.BookDocumentation;
import openmods.utils.SimpleUnlistedProperty;

@BookDocumentation(hasVideo=true)
public class BlockPaintMixer
extends OpenBlock.FourDirections {
    private static final IUnlistedProperty<Integer> CAN_COLOR = SimpleUnlistedProperty.create(Integer.class, (String)"can_color");
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 1.0, 0.875);

    public BlockPaintMixer() {
        super(Material.field_151576_e);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)Properties.StaticProperty, (Comparable)Boolean.valueOf(true)));
    }

    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{this.getPropertyOrientation(), Properties.StaticProperty}, new IUnlistedProperty[]{Properties.AnimationProperty, CAN_COLOR});
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntityPaintMixer mixer;
        if (state instanceof IExtendedBlockState && (mixer = (TileEntityPaintMixer)BlockPaintMixer.getTileEntity((IBlockAccess)world, (BlockPos)pos, TileEntityPaintMixer.class)) != null) {
            int currentColor;
            int progress = (Integer)mixer.getProgress().getValue();
            if (progress != 0) {
                RGB startColor = new RGB(mixer.getCanColor());
                RGB endColor = new RGB(((Integer)mixer.getColor().getValue()).intValue());
                float scaledProgress = (float)progress / 300.0f;
                currentColor = startColor.interpolate(endColor, (double)scaledProgress).getColor();
            } else {
                currentColor = mixer.getCanColor();
            }
            return ((IExtendedBlockState)state).withProperty(CAN_COLOR, (Object)currentColor);
        }
        return state;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public static class BlockColorHandler
    implements IBlockColor {
        private static final int WHITE = -1;

        public int func_186720_a(IBlockState state, @Nullable IBlockAccess worldIn, @Nullable BlockPos pos, int tintIndex) {
            IExtendedBlockState extendedState;
            Integer canColor;
            if (tintIndex == 0 && state instanceof IExtendedBlockState && (canColor = (Integer)(extendedState = (IExtendedBlockState)state).getValue(CAN_COLOR)) != null) {
                return canColor;
            }
            return -1;
        }
    }
}

