/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.block;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import openblocks.common.tileentity.TileEntityVillageHighlighter;
import openmods.block.OpenBlock;
import openmods.infobook.BookDocumentation;

@BookDocumentation
public class BlockVillageHighlighter
extends OpenBlock.FourDirections {
    private static final int MASK_POWERED = 8;
    public static final PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");

    public BlockVillageHighlighter() {
        super(Material.field_151576_e);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
        this.setRequiresInitialization(true);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{this.getPropertyOrientation(), POWERED});
    }

    public IBlockState func_176203_a(int meta) {
        return super.func_176203_a(meta).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf((meta & 8) != 0));
    }

    public int func_176201_c(IBlockState state) {
        return super.func_176201_c(state) | ((Boolean)state.func_177229_b((IProperty)POWERED) != false ? 8 : 0);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        TileEntityVillageHighlighter tile = (TileEntityVillageHighlighter)((Object)BlockVillageHighlighter.getTileEntity((IBlockAccess)blockAccess, (BlockPos)pos, TileEntityVillageHighlighter.class));
        return tile != null ? tile.getSignalStrength() : 0;
    }

    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return this.func_180656_a(blockState, blockAccess, pos, side);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos blockPos, Block neighbour, BlockPos neigbourPos) {
        BlockVillageHighlighter.updateRedstone(world, blockPos, state);
        super.func_189540_a(state, world, blockPos, neighbour, neigbourPos);
    }

    protected boolean onBlockAddedNextTick(World world, BlockPos blockPos, IBlockState state) {
        BlockVillageHighlighter.updateRedstone(world, blockPos, state);
        return super.onBlockAddedNextTick(world, blockPos, state);
    }

    private static void updateRedstone(World world, BlockPos blockPos, IBlockState state) {
        if (!(world instanceof WorldServer)) {
            return;
        }
        boolean isPowered = world.func_175687_A(blockPos) > 0;
        IBlockState newState = state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(isPowered));
        if (state != newState) {
            world.func_180501_a(blockPos, newState, 3);
        }
    }
}

