/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.entity;

import com.google.common.base.Predicate;
import io.netty.buffer.ByteBuf;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import openblocks.Config;
import openblocks.api.IMagnetAware;
import openblocks.common.CraneRegistry;
import openblocks.common.MagnetWhitelists;
import openblocks.common.entity.EntityMountedBlock;
import openblocks.common.entity.EntitySmoothMove;
import openblocks.common.item.ItemCraneBackpack;
import openmods.entity.DelayedEntityLoadManager;
import openmods.entity.EntityBlock;
import openmods.entity.IEntityLoadListener;

public class EntityMagnet
extends EntitySmoothMove
implements IEntityAdditionalSpawnData {
    private static final float MAGNET_HEIGHT = 0.5f;
    private static final float MAGNET_WIDTH = 0.5f;
    private static final Random RANDOM = new Random();
    private IOwner owner;
    private boolean isAboveTarget;
    private boolean isMagic;

    public EntityMagnet(World world) {
        super(world);
        this.func_70105_a(0.5f, 0.5f);
    }

    public EntityMagnet(World world, IOwner owner, boolean isMagic) {
        this(world);
        this.owner = owner;
        this.isMagic = isMagic;
        Vec3d initialTarget = owner.getTarget();
        this.func_70107_b(initialTarget.field_72450_a, initialTarget.field_72448_b, initialTarget.field_72449_c);
    }

    public boolean func_180431_b(DamageSource source) {
        return true;
    }

    protected void func_70081_e(int i) {
    }

    public boolean func_90999_ad() {
        return false;
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound tag) {
    }

    protected void func_70014_b(NBTTagCompound tag) {
    }

    public void writeSpawnData(ByteBuf data) {
        data.writeBoolean(this.isMagic);
    }

    public void readSpawnData(ByteBuf data) {
        this.isMagic = data.readBoolean();
    }

    public void func_70071_h_() {
        this.fixSize();
        if (!this.field_70170_p.field_72995_K) {
            if (this.owner == null || !this.owner.isValid(this)) {
                this.func_70106_y();
                return;
            }
            if (this.owner != null) {
                Vec3d target = this.owner.getTarget().func_72441_c(0.0, (double)(-this.field_70131_O), 0.0);
                this.smoother.setTarget(target);
            }
        }
        this.updatePrevPosition();
        this.smoother.update();
        boolean bl = this.isAboveTarget = !this.detectEntityTargets().isEmpty();
        if (this.isMagic && this.field_70170_p.field_72995_K && RANDOM.nextDouble() < 0.2) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, this.field_70165_t + RANDOM.nextDouble() * 0.1, this.field_70163_u - RANDOM.nextDouble() * 0.2, this.field_70161_v + RANDOM.nextDouble() * 0.1, RANDOM.nextGaussian(), -Math.abs(RANDOM.nextGaussian()), RANDOM.nextGaussian(), new int[0]);
        }
    }

    protected void fixSize() {
        List passengers = this.func_184188_bt();
        if (!passengers.isEmpty()) {
            Entity passenger = (Entity)passengers.get(0);
            float width = Math.max(0.5f, passenger.field_70130_N);
            float height = 0.5f + passenger.field_70131_O;
            this.func_70105_a(width, height);
        } else {
            this.func_70105_a(0.5f, 0.5f);
        }
    }

    public double func_70042_X() {
        List passengers = this.func_184188_bt();
        if (passengers.isEmpty()) {
            return 0.0;
        }
        return EntityMagnet.getMountedYOffset((Entity)passengers.get(0));
    }

    private static double getMountedYOffset(Entity rider) {
        return 0.0;
    }

    public boolean toggleMagnet() {
        List passengers = this.func_184188_bt();
        if (!passengers.isEmpty()) {
            Entity passenger = (Entity)passengers.get(0);
            if (passenger instanceof IMagnetAware && !((IMagnetAware)passenger).canRelease()) {
                return false;
            }
            double tmpPosY = passenger.field_70163_u;
            this.func_184226_ay();
            passenger.func_70107_b(passenger.field_70165_t, tmpPosY, passenger.field_70161_v);
            return true;
        }
        if (!this.field_70170_p.field_72995_K) {
            Entity target = null;
            if (Config.canMagnetPickEntities) {
                target = this.findEntityToPick();
            }
            if (target == null && Config.canMagnetPickBlocks) {
                target = this.createBlockEntity();
            }
            if (target != null) {
                target.func_184220_m((Entity)this);
                return true;
            }
        }
        return false;
    }

    private Entity findEntityToPick() {
        List<Entity> result = this.detectEntityTargets();
        Iterator<Entity> it = result.iterator();
        return it.hasNext() ? it.next() : null;
    }

    protected List<Entity> detectEntityTargets() {
        AxisAlignedBB aabb = this.func_174813_aQ().func_72314_b(0.25, 0.0, 0.25).func_72317_d(0.0, -1.0, 0.0);
        return this.field_70170_p.func_175674_a((Entity)this, aabb, this.createPickTargetPredicate());
    }

    protected Predicate<Entity> createPickTargetPredicate() {
        return new PickTargetPredicate();
    }

    private Entity createBlockEntity() {
        int z;
        int y;
        int x = MathHelper.func_76128_c((double)this.field_70165_t);
        final BlockPos pos = new BlockPos(x, y = MathHelper.func_76128_c((double)(this.field_70163_u - 0.5)), z = MathHelper.func_76128_c((double)this.field_70161_v));
        if (!this.field_70170_p.func_175667_e(pos) || this.field_70170_p.func_175623_d(pos)) {
            return null;
        }
        EntityBlock result = null;
        if (MagnetWhitelists.instance.testBlock(this.field_70170_p, pos)) {
            result = this.owner.createByPlayer(new IEntityBlockFactory(){

                @Override
                public EntityBlock create(EntityLivingBase player) {
                    return EntityBlock.create((EntityLivingBase)player, (World)EntityMagnet.this.field_70170_p, (BlockPos)pos, (EntityBlock.EntityFactory)new EntityBlock.EntityFactory(){

                        public EntityBlock create(World world) {
                            return new EntityMountedBlock(world);
                        }
                    });
                }
            });
        }
        if (result != null) {
            result.func_70107_b(this.field_70165_t, this.field_70163_u + EntityMagnet.getMountedYOffset((Entity)result), this.field_70161_v);
            this.field_70170_p.func_72838_d((Entity)result);
        }
        return result;
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public boolean shouldDismountInWater(Entity rider) {
        return false;
    }

    public boolean canRiderInteract() {
        return false;
    }

    public boolean isAboveTarget() {
        return this.isAboveTarget && Config.canMagnetPickEntities;
    }

    public boolean isLocked() {
        return this.func_184207_aI();
    }

    public boolean isValid() {
        return this.owner != null ? this.owner.isValid(this) : false;
    }

    public static class PlayerBound
    extends EntityMagnet
    implements IEntityLoadListener {
        private WeakReference<Entity> owner;

        public PlayerBound(World world) {
            super(world);
            this.owner = new WeakReference<Object>(null);
        }

        public PlayerBound(World world, EntityLivingBase owner) {
            super(world, new EntityPlayerTarget(owner), false);
            this.owner = new WeakReference<EntityLivingBase>(owner);
            CraneRegistry.instance.bindMagnetToPlayer((Entity)owner, this);
        }

        @Override
        public void writeSpawnData(ByteBuf data) {
            super.writeSpawnData(data);
            Entity owner = (Entity)this.owner.get();
            data.writeInt(owner != null ? owner.func_145782_y() : -1);
        }

        @Override
        public void readSpawnData(ByteBuf data) {
            super.readSpawnData(data);
            int entityId = data.readInt();
            if (entityId >= 0) {
                DelayedEntityLoadManager.instance.registerLoadListener(this.field_70170_p, (IEntityLoadListener)this, entityId);
            }
        }

        public void onEntityLoaded(Entity entity) {
            if (entity instanceof EntityPlayer) {
                this.owner = new WeakReference<Entity>(entity);
                CraneRegistry.instance.bindMagnetToPlayer(entity, this);
            }
        }

        @Override
        protected Predicate<Entity> createPickTargetPredicate() {
            return new PickTargetPredicate(){

                @Override
                public boolean apply(@Nullable Entity entity) {
                    return entity != owner.get() && super.apply(entity);
                }
            };
        }
    }

    private static class EntityPlayerTarget
    implements IOwner {
        private WeakReference<EntityLivingBase> owner;

        public EntityPlayerTarget(EntityLivingBase owner) {
            this.owner = new WeakReference<EntityLivingBase>(owner);
        }

        @Override
        public boolean isValid(EntityMagnet magnet) {
            EntityLivingBase player = (EntityLivingBase)this.owner.get();
            if (player == null || player.field_70128_L) {
                return false;
            }
            if (magnet.field_70170_p != player.field_70170_p) {
                return false;
            }
            return ItemCraneBackpack.isWearingCrane(player);
        }

        @Override
        public Vec3d getTarget() {
            EntityLivingBase player = (EntityLivingBase)this.owner.get();
            if (player == null) {
                return null;
            }
            double posX = player.field_70165_t + 2.0 * (double)MathHelper.func_76134_b((float)((player.field_70177_z + 90.0f) * (float)Math.PI / 180.0f));
            double posZ = player.field_70161_v + 2.0 * (double)MathHelper.func_76126_a((float)((player.field_70177_z + 90.0f) * (float)Math.PI / 180.0f));
            double posY = player.field_70163_u + (double)player.field_70131_O - CraneRegistry.instance.getCraneMagnetDistance(player);
            return new Vec3d(posX, posY, posZ);
        }

        @Override
        public EntityBlock createByPlayer(IEntityBlockFactory factory) {
            EntityLivingBase player = (EntityLivingBase)this.owner.get();
            if (player == null) {
                return null;
            }
            return factory.create(player);
        }
    }

    public static interface IOwner {
        public boolean isValid(EntityMagnet var1);

        public Vec3d getTarget();

        public EntityBlock createByPlayer(IEntityBlockFactory var1);
    }

    public static interface IEntityBlockFactory {
        public EntityBlock create(EntityLivingBase var1);
    }

    protected static class PickTargetPredicate
    implements Predicate<Entity> {
        protected PickTargetPredicate() {
        }

        public boolean apply(@Nullable Entity entity) {
            return entity instanceof EntityLivingBase || MagnetWhitelists.instance.entityWhitelist.check((Object)entity);
        }
    }
}

