/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.item;

import javax.annotation.Nonnull;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IDataWalker;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import openblocks.OpenBlocks;
import openblocks.common.entity.EntityAssistant;
import openblocks.common.entity.EntityCartographer;
import openmods.fixers.NestedItemStackWalker;

public class ItemCartographer
extends Item {
    public ItemCartographer() {
        this.func_77656_e(0);
        this.func_77627_a(true);
        this.func_77625_d(1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> result) {
        if (this.func_194125_a(tab)) {
            for (AssistantType type : AssistantType.VALUES) {
                result.add((Object)new ItemStack((Item)this, 1, type.ordinal()));
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        AssistantType type;
        ItemStack stack = player.func_184586_b(hand);
        if (!player.field_71075_bZ.field_75098_d) {
            stack.func_190918_g(1);
        }
        if (!world.field_72995_K && (type = ItemCartographer.getTypeFromItem(stack)) != null) {
            EntityAssistant cartographer = type.createAssistant(world, player, stack);
            world.func_72838_d((Entity)cartographer);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    public static AssistantType getTypeFromItem(@Nonnull ItemStack stack) {
        int typeId = stack.func_77952_i();
        if (typeId < 0 || typeId > AssistantType.VALUES.length) {
            typeId = 0;
        }
        return AssistantType.VALUES[typeId];
    }

    @Nonnull
    public ItemStack createStack(AssistantType type) {
        return new ItemStack((Item)this, 1, type.ordinal());
    }

    public static void registerFixes(DataFixer dataFixer) {
        if (OpenBlocks.Items.cartographer != null) {
            dataFixer.func_188258_a(FixTypes.ITEM_INSTANCE, (IDataWalker)new NestedItemStackWalker((IForgeRegistryEntry)OpenBlocks.Items.cartographer, new String[]{"MapItem"}));
        }
    }

    public static enum AssistantType {
        CARTOGRAPHER("cartographer", "cartographer"){

            @Override
            public EntityAssistant createAssistant(World world, EntityPlayer owner, ItemStack stack) {
                return new EntityCartographer(world, owner, stack);
            }
        };

        public final String untranslatedName;
        public static final AssistantType[] VALUES;

        private AssistantType(String name, String iconName) {
            this.untranslatedName = "openblocks.assistant_" + name;
        }

        public abstract EntityAssistant createAssistant(World var1, EntityPlayer var2, ItemStack var3);

        static {
            VALUES = AssistantType.values();
        }
    }
}

