/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.item;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import openblocks.Config;
import openmods.infobook.BookDocumentation;
import openmods.utils.EnchantmentUtils;
import openmods.utils.ItemUtils;
import openmods.utils.NbtUtils;

@BookDocumentation(hasVideo=true)
public class ItemCursor
extends Item {
    public ItemCursor() {
        this.func_77625_d(1);
    }

    public int func_77626_a(@Nonnull ItemStack par1ItemStack) {
        return 50;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        NBTTagCompound tag = ItemUtils.getItemTag((ItemStack)stack);
        tag.func_74768_a("dimension", world.field_73011_w.getDimension());
        NbtUtils.store((NBTTagCompound)tag, (BlockPos)pos);
        tag.func_74768_a("side", facing.ordinal());
        return EnumActionResult.SUCCESS;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        NBTTagCompound tag;
        if (!world.field_72995_K && (tag = player.func_184586_b(hand).func_77978_p()) != null && NbtUtils.hasCoordinates((NBTTagCompound)tag) && tag.func_74764_b("dimension")) {
            int dimension = tag.func_74762_e("dimension");
            BlockPos pos = NbtUtils.readBlockPos((NBTTagCompound)tag);
            if (world.field_73011_w.getDimension() == dimension && world.func_175667_e(pos)) {
                EnumFacing side = (EnumFacing)NbtUtils.readEnum((NBTTagCompound)tag, (String)"side", (Enum)EnumFacing.UP);
                ItemCursor.clickBlock(world, player, hand, pos, side);
            }
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    private static void clickBlock(World world, EntityPlayer player, EnumHand hand, BlockPos pos, EnumFacing side) {
        if (!world.func_175623_d(pos)) {
            IBlockState state = world.func_180495_p(pos);
            double distanceToLinkedBlock = player.func_174818_b(pos);
            if (distanceToLinkedBlock < (double)Config.cursorDistanceLimit) {
                Block block = state.func_177230_c();
                if (player.field_71075_bZ.field_75098_d) {
                    block.func_180639_a(world, pos, state, player, hand, side, 0.0f, 0.0f, 0.0f);
                } else {
                    int playerExperience;
                    int cost = (int)Math.max(0.0, distanceToLinkedBlock - 10.0);
                    if (cost <= (playerExperience = EnchantmentUtils.getPlayerXP((EntityPlayer)player))) {
                        block.func_180639_a(world, pos, state, player, hand, side, 0.0f, 0.0f, 0.0f);
                        EnchantmentUtils.addPlayerXP((EntityPlayer)player, (int)(-cost));
                    }
                }
            }
        }
    }
}

