/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.item;

import com.google.common.collect.MapMaker;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import openblocks.common.entity.EntityHangGlider;
import openmods.infobook.BookDocumentation;
import openmods.model.itemstate.IStateItem;
import openmods.state.State;
import openmods.state.StateContainer;

@BookDocumentation(hasVideo=true)
public class ItemHangGlider
extends Item
implements IStateItem {
    private static Map<EntityPlayer, EntityHangGlider> spawnedGlidersMap = new MapMaker().weakKeys().weakValues().makeMap();
    public static final IProperty<Boolean> deployedProperty = PropertyBool.func_177716_a((String)"deployed");
    private final StateContainer stateContainer = new StateContainer(new IProperty[]{deployedProperty});
    private final State deployedState = this.stateContainer.getBaseState().withProperty(deployedProperty, (Comparable)Boolean.valueOf(true));
    private final State inHandState = this.stateContainer.getBaseState().withProperty(deployedProperty, (Comparable)Boolean.valueOf(false));

    public ItemHangGlider() {
        this.func_185043_a(new ResourceLocation("hidden"), new IItemPropertyGetter(){

            public float func_185085_a(@Nonnull ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                return EntityHangGlider.isHeldStackDeployedGlider(entityIn, stack) ? 2.0f : 0.0f;
            }
        });
    }

    public StateContainer getStateContainer() {
        return this.stateContainer;
    }

    public State getState(ItemStack stack, World world, EntityLivingBase entity) {
        return EntityHangGlider.isHeldStackDeployedGlider(entity, stack) ? this.deployedState : this.inHandState;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            EntityHangGlider glider = spawnedGlidersMap.get(player);
            if (glider != null && !glider.field_70128_L) {
                if (glider.getHandHeld() == hand) {
                    ItemHangGlider.despawnGlider(player, glider);
                }
            } else {
                ItemHangGlider.spawnGlider(player, hand);
            }
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    private static void despawnGlider(EntityPlayer player, EntityHangGlider glider) {
        glider.func_70106_y();
        spawnedGlidersMap.remove(player);
    }

    private static void spawnGlider(EntityPlayer player, EnumHand hand) {
        EntityHangGlider glider = new EntityHangGlider(player.field_70170_p, player, hand);
        glider.func_70080_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70125_A, player.field_70177_z);
        player.field_70170_p.func_72838_d((Entity)glider);
        spawnedGlidersMap.put(player, glider);
    }
}

