/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.item;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import openblocks.Config;
import openblocks.OpenBlocks;
import openblocks.common.block.BlockImaginary;
import openblocks.common.tileentity.TileEntityImaginary;
import openmods.colors.ColorMeta;
import openmods.config.game.ICustomItemModelProvider;
import openmods.item.ItemOpenBlock;
import openmods.utils.ItemUtils;
import openmods.utils.TranslationUtils;

public class ItemImaginary
extends ItemOpenBlock {
    public static final float CRAFTING_COST = 1.0f;
    public static final String TAG_COLOR = "Color";
    public static final String TAG_USES = "Uses";
    public static final String TAG_MODE = "Mode";
    public static final int DAMAGE_PENCIL = 0;
    public static final int DAMAGE_CRAYON = 1;
    private static final Table<BlockImaginary.Shape, Boolean, PlacementMode> shapeToMode;

    public static float getUses(NBTTagCompound tag) {
        NBTBase value = tag.func_74781_a(TAG_USES);
        if (value == null) {
            return 0.0f;
        }
        if (value instanceof NBTPrimitive) {
            return ((NBTPrimitive)value).func_150288_h();
        }
        throw new IllegalStateException("Invalid tag type: " + value);
    }

    public static float getUses(@Nonnull ItemStack stack) {
        NBTTagCompound tag = ItemUtils.getItemTag((ItemStack)stack);
        return ItemImaginary.getUses(tag);
    }

    public static PlacementMode getMode(NBTTagCompound tag) {
        byte value = tag.func_74771_c(TAG_MODE);
        return PlacementMode.VALUES[value];
    }

    public static PlacementMode getMode(@Nonnull ItemStack stack) {
        NBTTagCompound tag = ItemUtils.getItemTag((ItemStack)stack);
        return ItemImaginary.getMode(tag);
    }

    public static Integer getColor(NBTTagCompound tag) {
        if (!tag.func_150297_b(TAG_COLOR, 99)) {
            return null;
        }
        return tag.func_74762_e(TAG_COLOR);
    }

    public static Integer getColor(@Nonnull ItemStack stack) {
        NBTTagCompound tag = ItemUtils.getItemTag((ItemStack)stack);
        return ItemImaginary.getColor(tag);
    }

    public static boolean isCrayon(@Nonnull ItemStack stack) {
        return stack.func_77973_b() instanceof ItemImaginary && stack.func_77952_i() == 1;
    }

    public ItemImaginary(Block block) {
        super(block);
        this.func_77625_d(1);
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_185043_a(new ResourceLocation("mode"), new IItemPropertyGetter(){

            public float func_185085_a(@Nonnull ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                NBTTagCompound tag = ItemUtils.getItemTag((ItemStack)stack);
                return tag.func_74771_c(ItemImaginary.TAG_MODE);
            }
        });
    }

    @Nonnull
    public static ItemStack setupValues(@Nonnull ItemStack result, Integer color, BlockImaginary.Shape shape, boolean isInverted) {
        return ItemImaginary.setupValues(result, color, shape, isInverted, Config.imaginaryItemUseCount);
    }

    @Nonnull
    public static ItemStack setupValues(@Nonnull ItemStack result, Integer color, BlockImaginary.Shape shape, boolean isInverted, float uses) {
        return ItemImaginary.setupValues(result, color, (PlacementMode)((Object)MoreObjects.firstNonNull((Object)shapeToMode.get((Object)shape, (Object)isInverted), (Object)((Object)PlacementMode.BLOCK))), uses);
    }

    @Nonnull
    public static ItemStack setupValues(@Nonnull ItemStack result, Integer color) {
        return ItemImaginary.setupValues(result, color, PlacementMode.BLOCK);
    }

    @Nonnull
    public static ItemStack setupValues(@Nonnull ItemStack result, Integer color, PlacementMode mode) {
        return ItemImaginary.setupValues(result, color, mode, Config.imaginaryItemUseCount);
    }

    @Nonnull
    public static ItemStack setupValues(@Nonnull ItemStack result, Integer color, PlacementMode mode, float uses) {
        NBTTagCompound tag = ItemUtils.getItemTag((ItemStack)result);
        if (color != null) {
            tag.func_74768_a(TAG_COLOR, color.intValue());
            result.func_77964_b(1);
        }
        tag.func_74768_a(TAG_MODE, mode.ordinal());
        tag.func_74776_a(TAG_USES, uses);
        return result;
    }

    protected void afterBlockPlaced(@Nonnull ItemStack stack, EntityPlayer player, World world, BlockPos pos) {
        NBTTagCompound tag = ItemUtils.getItemTag((ItemStack)stack);
        NBTTagInt color = (NBTTagInt)tag.func_74781_a(TAG_COLOR);
        PlacementMode mode = ItemImaginary.getMode(tag);
        world.func_175690_a(pos, (TileEntity)new TileEntityImaginary(color == null ? null : Integer.valueOf(color.func_150287_d()), mode.isInverted, mode.shape));
        if (!player.field_71075_bZ.field_75098_d) {
            float uses = Math.max(ItemImaginary.getUses(tag) - mode.cost, 0.0f);
            tag.func_74776_a(TAG_USES, uses);
            if (uses <= 0.0f) {
                stack.func_190920_e(0);
            }
        }
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        NBTTagCompound tag = ItemUtils.getItemTag((ItemStack)stack);
        float uses = ItemImaginary.getUses(tag);
        if (uses <= 0.0f) {
            stack.func_190920_e(0);
            return EnumActionResult.FAIL;
        }
        if (uses < ItemImaginary.getMode((NBTTagCompound)tag).cost) {
            return EnumActionResult.FAIL;
        }
        return super.func_180614_a(player, world, pos, hand, facing, hitX, hitY, hitZ);
    }

    public String func_77667_c(@Nonnull ItemStack stack) {
        NBTTagCompound tag = ItemUtils.getItemTag((ItemStack)stack);
        return tag.func_74764_b(TAG_COLOR) ? "item.openblocks.crayon" : "item.openblocks.pencil";
    }

    public String func_77658_a() {
        return "item.openblocks.imaginary";
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World worldIn, List<String> result, ITooltipFlag flagIn) {
        NBTTagCompound tag = ItemUtils.getItemTag((ItemStack)stack);
        result.add(TranslationUtils.translateToLocalFormatted((String)"openblocks.misc.uses", (Object[])new Object[]{Float.valueOf(ItemImaginary.getUses(tag))}));
        NBTTagInt color = (NBTTagInt)tag.func_74781_a(TAG_COLOR);
        if (color != null) {
            result.add(TranslationUtils.translateToLocalFormatted((String)"openblocks.misc.color", (Object[])new Object[]{color.func_150287_d()}));
        }
        PlacementMode mode = ItemImaginary.getMode(tag);
        String translatedMode = TranslationUtils.translateToLocal((String)mode.name);
        result.add(TranslationUtils.translateToLocalFormatted((String)"openblocks.misc.mode", (Object[])new Object[]{translatedMode}));
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> result) {
        if (this.func_194125_a(tab)) {
            result.add((Object)ItemImaginary.setupValues(new ItemStack((Item)this, 1, 0), null, PlacementMode.BLOCK));
            for (ColorMeta color : ColorMeta.getAllColors()) {
                result.add((Object)ItemImaginary.setupValues(new ItemStack((Item)this, 1, 1), color.rgb, PlacementMode.BLOCK));
            }
        }
    }

    public boolean hasContainerItem(@Nonnull ItemStack stack) {
        return true;
    }

    @Nonnull
    public ItemStack getContainerItem(@Nonnull ItemStack stack) {
        NBTTagCompound tag = ItemUtils.getItemTag((ItemStack)stack);
        float uses = ItemImaginary.getUses(tag) - 1.0f;
        if (uses <= 0.0f) {
            return ItemStack.field_190927_a;
        }
        ItemStack copy = stack.func_77946_l();
        NBTTagCompound copyTag = ItemUtils.getItemTag((ItemStack)copy);
        copyTag.func_74776_a(TAG_USES, uses);
        return copy;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        NBTTagCompound tag = ItemUtils.getItemTag((ItemStack)stack);
        if (ItemImaginary.getUses(tag) <= 0.0f) {
            stack.func_190920_e(0);
        } else if (player.func_70093_af()) {
            byte modeId = tag.func_74771_c(TAG_MODE);
            modeId = (byte)((modeId + 1) % PlacementMode.VALUES.length);
            tag.func_74774_a(TAG_MODE, modeId);
            if (world.field_72995_K) {
                PlacementMode mode = PlacementMode.VALUES[modeId];
                TextComponentTranslation modeName = new TextComponentTranslation(mode.name, new Object[0]);
                player.func_145747_a((ITextComponent)new TextComponentTranslation("openblocks.misc.mode", new Object[]{modeName}));
            }
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    static {
        ImmutableTable.Builder shapeToModeBuilder = ImmutableTable.builder();
        for (PlacementMode mode : PlacementMode.VALUES) {
            shapeToModeBuilder.put((Object)mode.shape, (Object)mode.isInverted, (Object)mode);
        }
        shapeToMode = shapeToModeBuilder.build();
    }

    public static enum PlacementMode {
        BLOCK(1.0f, "block", false, BlockImaginary.Shape.BLOCK),
        PANEL(0.5f, "panel", false, BlockImaginary.Shape.PANEL),
        HALF_PANEL(0.5f, "half_panel", false, BlockImaginary.Shape.HALF_PANEL),
        STAIRS(0.75f, "stairs", false, BlockImaginary.Shape.STAIRS),
        INV_BLOCK(1.5f, "inverted_block", true, BlockImaginary.Shape.BLOCK),
        INV_PANEL(1.0f, "inverted_panel", true, BlockImaginary.Shape.PANEL),
        INV_HALF_PANEL(1.0f, "inverted_half_panel", true, BlockImaginary.Shape.HALF_PANEL),
        INV_STAIRS(1.25f, "inverted_stairs", true, BlockImaginary.Shape.STAIRS);

        public final float cost;
        public final String name;
        public final boolean isInverted;
        public final BlockImaginary.Shape shape;
        public static final PlacementMode[] VALUES;

        private PlacementMode(float cost, String name, boolean isInverted, BlockImaginary.Shape shape) {
            this.cost = cost;
            this.name = "openblocks.misc.mode." + name;
            this.isInverted = isInverted;
            this.shape = shape;
        }

        static {
            VALUES = PlacementMode.values();
        }
    }

    public static class ModelProvider
    implements ICustomItemModelProvider {
        public void addCustomItemModels(Item item, ResourceLocation itemId, ICustomItemModelProvider.IModelRegistrationSink modelsOut) {
            ResourceLocation location = OpenBlocks.location("imaginary");
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)1, (ModelResourceLocation)new ModelResourceLocation(location, "inventory_crayon"));
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(location, "inventory_pencil"));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class CrayonColorHandler
    implements IItemColor {
        public int func_186726_a(@Nonnull ItemStack stack, int tintIndex) {
            if (tintIndex == 1 && ItemImaginary.isCrayon(stack)) {
                return ItemUtils.getItemTag((ItemStack)stack).func_74762_e(ItemImaginary.TAG_COLOR);
            }
            return -1;
        }
    }
}

