/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import openblocks.Config;
import openmods.api.IActivateAwareTile;
import openmods.api.IAddAwareTile;
import openmods.api.INeighbourAwareTile;
import openmods.api.IPlaceAwareTile;
import openmods.model.eval.EvalModelState;
import openmods.sync.ISyncListener;
import openmods.sync.ISyncableObject;
import openmods.sync.SyncMap;
import openmods.sync.SyncableByte;
import openmods.sync.SyncableFloat;
import openmods.tileentity.SyncedTileEntity;
import openmods.utils.BlockUtils;

public class TileEntityFan
extends SyncedTileEntity
implements IPlaceAwareTile,
INeighbourAwareTile,
IAddAwareTile,
ITickable,
IActivateAwareTile {
    private static final int ANGLE_SPEED_PER_REDSTONE_POWER = 45;
    private static final double CONE_HALF_APERTURE = 0.6;
    private SyncableFloat angle;
    private SyncableByte power;
    private float bladeRotation;
    private float bladeSpeed;
    private EvalModelState baseClipState = EvalModelState.EMPTY;

    protected void createSyncedFields() {
        this.angle = new SyncableFloat();
        this.power = new SyncableByte();
    }

    protected void onSyncMapCreate(SyncMap syncMap) {
        syncMap.addUpdateListener(new ISyncListener(){

            public void onSync(Set<ISyncableObject> changes) {
                if (changes.contains(TileEntityFan.this.angle)) {
                    TileEntityFan.this.setStateAngle(TileEntityFan.this.angle.get());
                    TileEntityFan.this.markBlockForRenderUpdate(TileEntityFan.this.func_174877_v());
                }
            }
        });
    }

    public void func_73660_a() {
        float redstonePower = (float)this.power.get() / 15.0f;
        this.bladeSpeed = 45.0f * redstonePower;
        this.bladeRotation += this.bladeSpeed;
        double maxForce = Config.fanForce * (double)redstonePower;
        if (maxForce <= 0.0) {
            return;
        }
        List entities = this.field_145850_b.func_72872_a(Entity.class, this.getEntitySearchBoundingBox());
        if (entities.isEmpty()) {
            return;
        }
        double angle = Math.toRadians(this.getAngle() - 90.0f);
        Vec3d blockPos = this.getConeApex(angle);
        Vec3d basePos = this.getConeBaseCenter(angle);
        Vec3d coneAxis = new Vec3d(basePos.field_72450_a - blockPos.field_72450_a, basePos.field_72448_b - blockPos.field_72448_b, basePos.field_72449_c - blockPos.field_72449_c);
        for (Entity entity : entities) {
            double distToOrigin;
            double force;
            Vec3d directionVec;
            if (entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71075_bZ.field_75098_d || !TileEntityFan.isLyingInSphericalCone(coneAxis, directionVec = new Vec3d(entity.field_70165_t - blockPos.field_72450_a, entity.field_70163_u - blockPos.field_72448_b, entity.field_70161_v - blockPos.field_72449_c), 0.6) || (force = (1.0 - (distToOrigin = directionVec.func_72433_c()) / Config.fanRange) * maxForce) <= 0.0) continue;
            Vec3d normal = directionVec.func_72432_b();
            entity.field_70159_w += force * normal.field_72450_a;
            entity.field_70179_y += force * normal.field_72449_c;
        }
    }

    private Vec3d getConeBaseCenter(double angle) {
        return new Vec3d((Vec3i)this.field_174879_c).func_72441_c(Math.cos(angle) * Config.fanRange, 0.5, Math.sin(angle) * Config.fanRange);
    }

    private Vec3d getConeApex(double angle) {
        return new Vec3d((Vec3i)this.field_174879_c).func_72441_c(0.5 - Math.cos(angle) * 1.1, 0.5, 0.5 - Math.sin(angle) * 1.1);
    }

    private AxisAlignedBB getEntitySearchBoundingBox() {
        AxisAlignedBB boundingBox = BlockUtils.aabbOffset((BlockPos)this.field_174879_c, (double)0.0, (double)-2.0, (double)0.0, (double)1.0, (double)3.0, (double)1.0);
        return boundingBox.func_186662_g(Config.fanRange);
    }

    private static boolean isLyingInSphericalCone(Vec3d coneAxis, Vec3d originToTarget, double halfAperture) {
        double angleToAxisCos = originToTarget.func_72430_b(coneAxis) / originToTarget.func_72433_c() / coneAxis.func_72433_c();
        return angleToAxisCos > Math.cos(halfAperture);
    }

    public void onBlockPlacedBy(IBlockState state, EntityLivingBase placer, @Nonnull ItemStack stack) {
        float placeAngle = placer.field_70759_as;
        this.angle.set(placeAngle);
        this.setStateAngle(placeAngle);
    }

    public float getAngle() {
        return this.angle.get();
    }

    public float getBladeRotation(float partialTickTime) {
        return (this.bladeRotation + this.bladeSpeed * partialTickTime) % 360.0f;
    }

    public void onNeighbourChanged(BlockPos neighbourPos, Block neighbourBlock) {
        this.updateRedstone();
    }

    public void onAdded() {
        this.updateRedstone();
    }

    private void updateRedstone() {
        if (!this.field_145850_b.field_72995_K) {
            int power = Config.redstoneActivatedFan ? this.field_145850_b.func_175687_A(this.field_174879_c) : 15;
            this.power.set((byte)power);
            this.sync();
        }
    }

    public boolean onBlockActivated(EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!this.field_145850_b.field_72995_K && hand == EnumHand.MAIN_HAND) {
            this.angle.set(this.angle.get() + (player.func_70093_af() ? -10.0f : 10.0f));
            this.sync();
            return true;
        }
        return false;
    }

    public boolean hasFastRenderer() {
        return true;
    }

    private void setStateAngle(float angle) {
        this.baseClipState = this.baseClipState.withArg("base_rotation", angle);
    }

    public EvalModelState getStaticRenderState() {
        return this.baseClipState;
    }

    public EvalModelState getTesrRenderState(float partialTickTime) {
        return this.baseClipState.withArg("blade_rotation", this.getBladeRotation(partialTickTime), true);
    }
}

