/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;
import openblocks.OpenBlocks;
import openmods.api.IActivateAwareTile;
import openmods.api.ICustomHarvestDrops;
import openmods.api.IPlaceAwareTile;
import openmods.colors.ColorMeta;
import openmods.model.eval.EvalModelState;
import openmods.sync.ISyncListener;
import openmods.sync.ISyncableObject;
import openmods.sync.SyncMap;
import openmods.sync.SyncableEnum;
import openmods.sync.SyncableFloat;
import openmods.tileentity.SyncedTileEntity;

public class TileEntityFlag
extends SyncedTileEntity
implements IPlaceAwareTile,
IActivateAwareTile,
ICustomHarvestDrops {
    private SyncableFloat angle;
    private SyncableEnum<ColorMeta> colorIndex;
    private EvalModelState clipsState = EvalModelState.EMPTY;

    protected void createSyncedFields() {
        this.angle = new SyncableFloat();
        this.colorIndex = SyncableEnum.create((Enum)ColorMeta.GREEN);
    }

    protected void onSyncMapCreate(SyncMap syncMap) {
        syncMap.addUpdateListener(new ISyncListener(){

            public void onSync(Set<ISyncableObject> changes) {
                if (changes.contains(TileEntityFlag.this.angle)) {
                    TileEntityFlag.this.setStateAngle(TileEntityFlag.this.angle.get());
                    TileEntityFlag.this.markBlockForRenderUpdate(TileEntityFlag.this.func_174877_v());
                }
            }
        });
    }

    public ColorMeta getColor() {
        return (ColorMeta)this.colorIndex.get();
    }

    public float getAngle() {
        return this.angle.get();
    }

    public boolean onBlockActivated(EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!this.field_145850_b.field_72995_K && hand == EnumHand.MAIN_HAND) {
            ItemStack heldItem = player.func_184614_ca();
            if (heldItem.func_77973_b() == Item.func_150898_a((Block)OpenBlocks.Blocks.flag)) {
                return false;
            }
            if (this.getOrientation().down() == EnumFacing.DOWN) {
                this.angle.set(this.angle.get() + (player.func_70093_af() ? -10.0f : 10.0f));
                this.sync();
                return true;
            }
        }
        return false;
    }

    public void onBlockPlacedBy(IBlockState state, EntityLivingBase placer, @Nonnull ItemStack stack) {
        EnumFacing rotation = this.getOrientation().up();
        if (rotation == EnumFacing.UP) {
            float playerAngle = placer.field_70759_as;
            int angle = MathHelper.func_76141_d((float)(playerAngle / 10.0f)) * 10;
            this.angle.set((float)angle);
            this.setStateAngle(angle);
        }
        this.colorIndex.set((Enum)ColorMeta.fromBlockMeta((int)(stack.func_77952_i() & 0xF)));
    }

    public EvalModelState getRenderState() {
        return this.clipsState;
    }

    private void setStateAngle(float angle) {
        this.clipsState = this.clipsState.withArg("rotation", angle);
    }

    public boolean suppressBlockHarvestDrops() {
        return true;
    }

    public void addHarvestDrops(EntityPlayer player, List<ItemStack> drops, IBlockState blockState, int fortune, boolean isSilkTouch) {
        drops.add(new ItemStack((Block)OpenBlocks.Blocks.flag, 1, ((ColorMeta)this.colorIndex.get()).vanillaBlockId));
    }
}

