/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import openblocks.Config;
import openblocks.OpenBlocks;
import openblocks.client.gui.GuiSprinkler;
import openblocks.common.container.ContainerSprinkler;
import openmods.api.IHasGui;
import openmods.api.INeighbourAwareTile;
import openmods.api.ISurfaceAttachment;
import openmods.fakeplayer.FakePlayerPool;
import openmods.fakeplayer.OpenModsFakePlayer;
import openmods.fixers.GenericInventoryTeFixerWalker;
import openmods.fixers.RegisterFixer;
import openmods.include.IncludeInterface;
import openmods.inventory.GenericInventory;
import openmods.inventory.IInventoryProvider;
import openmods.inventory.TileEntityInventory;
import openmods.liquids.GenericFluidCapabilityWrapper;
import openmods.model.eval.EvalModelState;
import openmods.sync.SyncableFlags;
import openmods.sync.SyncableTank;
import openmods.tileentity.SyncedTileEntity;

@RegisterFixer(value=GenericInventoryTeFixerWalker.class)
public class TileEntitySprinkler
extends SyncedTileEntity
implements ISurfaceAttachment,
IInventoryProvider,
IHasGui,
ITickable,
INeighbourAwareTile {
    private static final ItemStack BONEMEAL = new ItemStack(Items.field_151100_aR, 1, 15);
    private static final Random RANDOM = new Random();
    private static final double[] SPRINKER_DELTA = new double[]{0.2, 0.25, 0.5};
    private static final int[] SPRINKER_MOD = new int[]{1, 5, 20};
    private boolean hasBonemeal = false;
    private boolean needsTankUpdate;
    private SyncableFlags flags;
    private SyncableTank tank;
    public int ticks;
    private final GenericInventory inventory = this.registerInventoryCallback((GenericInventory)new TileEntityInventory((TileEntity)this, "sprinkler", true, 9){

        public boolean func_94041_b(int i, @Nonnull ItemStack itemstack) {
            return !itemstack.func_190926_b() && itemstack.func_77969_a(BONEMEAL);
        }
    });
    private final IFluidHandler tankWrapper = new GenericFluidCapabilityWrapper.Drain((IFluidHandler)this.tank);
    private static final double SPRAY_SIDE_SCATTER = Math.toRadians(25.0);

    protected void createSyncedFields() {
        this.flags = SyncableFlags.create((int)Flags.values().length);
        this.tank = new SyncableTank(Config.sprinklerInternalTank, new Fluid[]{FluidRegistry.WATER, OpenBlocks.Fluids.xpJuice});
    }

    private static int selectFromRange(int range) {
        return RANDOM.nextInt(2 * range + 1) - range;
    }

    private void attemptFertilize() {
        int fertilizerChance;
        if (!(this.field_145850_b instanceof WorldServer)) {
            return;
        }
        int n = fertilizerChance = this.hasBonemeal ? Config.sprinklerBonemealFertizizeChance : Config.sprinklerFertilizeChance;
        if (RANDOM.nextDouble() < 1.0 / (double)fertilizerChance) {
            FakePlayerPool.instance.executeOnPlayer((WorldServer)this.field_145850_b, new FakePlayerPool.PlayerUser(){

                public void usePlayer(OpenModsFakePlayer fakePlayer) {
                    int x = TileEntitySprinkler.selectFromRange(Config.sprinklerEffectiveRange);
                    int z = TileEntitySprinkler.selectFromRange(Config.sprinklerEffectiveRange);
                    for (int y = -1; y <= 1; ++y) {
                        BlockPos target = TileEntitySprinkler.this.field_174879_c.func_177982_a(x, y, z);
                        if (ItemDye.applyBonemeal((ItemStack)BONEMEAL.func_77946_l(), (World)TileEntitySprinkler.this.field_145850_b, (BlockPos)target, (EntityPlayer)fakePlayer, (EnumHand)EnumHand.MAIN_HAND)) break;
                    }
                }
            });
        }
    }

    public Object getServerGui(EntityPlayer player) {
        return new ContainerSprinkler((IInventory)player.field_71071_by, this);
    }

    public Object getClientGui(EntityPlayer player) {
        return new GuiSprinkler(new ContainerSprinkler((IInventory)player.field_71071_by, this));
    }

    public boolean canOpenGui(EntityPlayer player) {
        return true;
    }

    private void sprayParticles() {
        if (this.tank.getFluidAmount() > 0) {
            int particleSetting = OpenBlocks.proxy.getParticleSettings();
            if (particleSetting > 2) {
                return;
            }
            int fillFactor = SPRINKER_MOD[particleSetting];
            if (this.ticks % fillFactor != 0) {
                return;
            }
            EnumFacing blockYawRotation = this.getOrientation().north();
            double nozzleAngle = this.getSprayDirection();
            double sprayForwardVelocity = Math.sin(Math.toRadians(nozzleAngle * 25.0));
            int offsetZ = blockYawRotation.func_82599_e();
            int offsetX = blockYawRotation.func_82601_c();
            double forwardVelocityX = sprayForwardVelocity * (double)offsetZ / -2.0;
            double forwardVelocityZ = sprayForwardVelocity * (double)offsetX / 2.0;
            double sprinklerDelta = SPRINKER_DELTA[particleSetting];
            for (double outletPosition = -0.5; outletPosition <= 0.5; outletPosition += sprinklerDelta) {
                double spraySideVelocity = Math.sin(SPRAY_SIDE_SCATTER * (RANDOM.nextDouble() - 0.5));
                double sideVelocityX = spraySideVelocity * (double)offsetX;
                double sideVelocityZ = spraySideVelocity * (double)offsetZ;
                Vec3d vec = new Vec3d(forwardVelocityX + sideVelocityX, 0.35, forwardVelocityZ + sideVelocityZ);
                OpenBlocks.proxy.spawnLiquidSpray(this.field_145850_b, this.tank.getFluid(), (double)this.field_174879_c.func_177958_n() + 0.5 + outletPosition * 0.6 * (double)offsetX, (double)this.field_174879_c.func_177956_o() + 0.2, (double)this.field_174879_c.func_177952_p() + 0.5 + outletPosition * 0.6 * (double)offsetZ, 0.3f, 0.7f, vec);
            }
        }
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.tank.getFluidAmount() <= 0) {
                if (this.needsTankUpdate) {
                    this.tank.updateNeighbours(this.field_145850_b, this.field_174879_c);
                    this.needsTankUpdate = false;
                }
                this.tank.fillFromSide(this.field_145850_b, this.field_174879_c, EnumFacing.DOWN);
            }
            if (this.ticks % Config.sprinklerBonemealConsumeRate == 0) {
                this.hasBonemeal = this.consumeFirstInventoryItem();
            }
            if (this.ticks % Config.sprinklerWaterConsumeRate == 0) {
                this.setEnabled(this.tank.drain(1, true) != null);
                this.sync();
            }
        }
        ++this.ticks;
        if (this.isEnabled()) {
            if (this.field_145850_b.field_72995_K) {
                this.sprayParticles();
            } else {
                this.attemptFertilize();
            }
        }
    }

    private boolean consumeFirstInventoryItem() {
        for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
            ItemStack contents = this.inventory.func_70301_a(i);
            if (contents.func_190926_b() || !BONEMEAL.func_77969_a(contents)) continue;
            contents.func_190918_g(1);
            this.inventory.func_70299_a(i, contents);
            return true;
        }
        return false;
    }

    private void setEnabled(boolean b) {
        this.flags.set((Enum)Flags.enabled, b);
    }

    private boolean isEnabled() {
        return this.flags.get((Enum)Flags.enabled);
    }

    public EnumFacing getSurfaceDirection() {
        return EnumFacing.DOWN;
    }

    public float getSprayDirection() {
        if (this.isEnabled()) {
            return MathHelper.func_76126_a((float)((float)this.ticks * 0.02f));
        }
        return 0.0f;
    }

    @IncludeInterface
    public IInventory getInventory() {
        return this.inventory;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        this.inventory.writeToNBT(tag);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.inventory.readFromNBT(tag);
    }

    public void func_145829_t() {
        super.func_145829_t();
        this.needsTankUpdate = true;
    }

    public void onNeighbourChanged(BlockPos neighbourPos, Block neighbourBlock) {
        this.needsTankUpdate = true;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.tankWrapper;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.inventory.getHandler();
        }
        return (T)super.getCapability(capability, facing);
    }

    public EvalModelState getRenderState() {
        return EvalModelState.create().withArg("direction", this.getSprayDirection());
    }

    public boolean hasFastRenderer() {
        return true;
    }

    public static enum Flags {
        enabled;

    }
}

