/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import openblocks.Config;
import openblocks.OpenBlocks;
import openblocks.client.renderer.tileentity.tank.ITankConnections;
import openblocks.client.renderer.tileentity.tank.ITankRenderFluidData;
import openblocks.client.renderer.tileentity.tank.NeighbourMap;
import openblocks.client.renderer.tileentity.tank.TankRenderLogic;
import openblocks.common.LiquidXpUtils;
import openmods.api.IActivateAwareTile;
import openmods.api.ICustomHarvestDrops;
import openmods.api.INeighbourAwareTile;
import openmods.api.IPlaceAwareTile;
import openmods.liquids.GenericTank;
import openmods.model.variant.VariantModelState;
import openmods.sync.ISyncListener;
import openmods.sync.ISyncableObject;
import openmods.sync.SyncMap;
import openmods.sync.SyncableTank;
import openmods.tileentity.SyncedTileEntity;
import openmods.utils.EnchantmentUtils;
import openmods.utils.ItemUtils;

public class TileEntityTank
extends SyncedTileEntity
implements IActivateAwareTile,
IPlaceAwareTile,
INeighbourAwareTile,
ICustomHarvestDrops,
ITickable {
    private final TankRenderLogic renderLogic;
    private boolean needsTankUpdate;
    private static final int SYNC_THRESHOLD = 8;
    private static final int UPDATE_THRESHOLD = 20;
    private SyncableTank tank;
    private boolean forceUpdate = true;
    private int ticksSinceLastSync = ((Object)((Object)this)).hashCode() % 8;
    private boolean needsSync;
    private int ticksSinceLastUpdate = ((Object)((Object)this)).hashCode() % 20;
    private boolean needsUpdate;
    private final IFluidHandler tankCapabilityWrapper = new IFluidHandler(){

        public IFluidTankProperties[] getTankProperties() {
            return TileEntityTank.this.tank.getTankProperties();
        }

        public int fill(FluidStack resource, boolean doFill) {
            if (resource == null) {
                return 0;
            }
            FluidStack copy = resource.copy();
            TileEntityTank.this.fillColumn(copy, doFill);
            return resource.amount - copy.amount;
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            if (maxDrain <= 0) {
                return null;
            }
            FluidStack contents = TileEntityTank.this.tank.getFluid();
            if (contents == null || contents.amount <= 0) {
                return null;
            }
            FluidStack needed = contents.copy();
            needed.amount = maxDrain;
            TileEntityTank.this.drainFromColumn(needed, doDrain);
            needed.amount = maxDrain - needed.amount;
            return needed;
        }

        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            if (resource == null) {
                return null;
            }
            FluidStack needed = resource.copy();
            TileEntityTank.this.drainFromColumn(needed, doDrain);
            needed.amount = resource.amount - needed.amount;
            return needed;
        }
    };

    public void func_145829_t() {
        super.func_145829_t();
        this.needsTankUpdate = true;
        if (this.field_145850_b.field_72995_K) {
            this.renderLogic.initialize(this.field_145850_b, this.field_174879_c);
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.field_145850_b.field_72995_K) {
            this.renderLogic.invalidateConnections();
        }
    }

    protected TileEntityTank getNeighourTank(BlockPos pos) {
        if (!this.field_145850_b.func_175667_e(pos)) {
            return null;
        }
        Chunk chunk = this.field_145850_b.func_175726_f(pos);
        TileEntity te = chunk.func_177424_a(pos, Chunk.EnumCreateEntityType.CHECK);
        return te instanceof TileEntityTank ? (TileEntityTank)te : null;
    }

    public TileEntityTank() {
        this.renderLogic = new TankRenderLogic((GenericTank)this.tank);
    }

    protected void onSyncMapCreate(SyncMap syncMap) {
        syncMap.addSyncListener(new ISyncListener(){

            public void onSync(Set<ISyncableObject> changes) {
                TileEntityTank.this.ticksSinceLastSync = 0;
            }
        });
        syncMap.addUpdateListener((ISyncListener)new RenderUpdateListeners());
    }

    protected void createSyncedFields() {
        this.tank = new SyncableTank(TileEntityTank.getTankCapacity());
    }

    public double getFluidRatio() {
        return (double)this.tank.getFluidAmount() / (double)this.tank.getCapacity();
    }

    public static int getTankCapacity() {
        return 1000 * Config.bucketsPerTank;
    }

    public int getFluidLightLevel() {
        Fluid fluid;
        FluidStack stack = this.tank.getFluid();
        if (stack != null && (fluid = stack.getFluid()) != null) {
            return fluid.getLuminosity();
        }
        return 0;
    }

    public ITankRenderFluidData getRenderFluidData() {
        return this.renderLogic.getTankRenderData();
    }

    public ITankConnections getTankConnections() {
        return this.renderLogic.getTankConnections();
    }

    public VariantModelState getModelState() {
        return new NeighbourMap(this.field_145850_b, this.field_174879_c, this.tank.getFluid()).getState();
    }

    public boolean accepts(FluidStack liquid) {
        if (liquid == null) {
            return true;
        }
        FluidStack ownFluid = this.tank.getFluid();
        return ownFluid == null || ownFluid.isFluidEqual(liquid);
    }

    private boolean containsFluid(FluidStack liquid) {
        if (liquid == null) {
            return false;
        }
        FluidStack ownFluid = this.tank.getFluid();
        return ownFluid != null && ownFluid.isFluidEqual(liquid);
    }

    public IFluidTank getTank() {
        return this.tank;
    }

    public NBTTagCompound getItemNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.tank.writeToNBT(nbt);
        return nbt;
    }

    public void onNeighbourChanged(BlockPos neighbourPos, Block neighbourBlock) {
        this.forceUpdate = true;
        this.needsTankUpdate = true;
    }

    public void onBlockPlacedBy(IBlockState state, EntityLivingBase placer, @Nonnull ItemStack stack) {
        NBTTagCompound itemTag = stack.func_77978_p();
        if (itemTag != null && itemTag.func_74764_b("tank")) {
            this.tank.readFromNBT(itemTag.func_74775_l("tank"));
        }
    }

    private static TileEntityTank getValidTank(TileEntity neighbor) {
        return neighbor instanceof TileEntityTank && !neighbor.func_145837_r() ? (TileEntityTank)neighbor : null;
    }

    private TileEntityTank getTankInDirection(EnumFacing direction) {
        TileEntity neighbor = this.getTileInDirection(direction);
        return TileEntityTank.getValidTank(neighbor);
    }

    public TileEntityTank getTankInDirection(int dx, int dy, int dz) {
        TileEntity neighbor = this.getTileEntity(this.field_174879_c.func_177982_a(dx, dy, dz));
        return TileEntityTank.getValidTank(neighbor);
    }

    public boolean onBlockActivated(EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (this.field_145850_b.field_72995_K) {
            return true;
        }
        if (hand == EnumHand.MAIN_HAND) {
            ItemStack heldItem = player.func_184614_ca();
            if (!heldItem.func_190926_b()) {
                FluidActionResult result = this.tryEmptyItem(player, heldItem.func_77946_l());
                if (result.success) {
                    if (!player.func_184812_l_()) {
                        player.func_184611_a(EnumHand.MAIN_HAND, result.result);
                    }
                    return true;
                }
            } else {
                return this.tryDrainXp(player);
            }
        }
        return false;
    }

    protected boolean tryDrainXp(EntityPlayer player) {
        int xp;
        int requiredXp;
        int requiredXPJuice;
        FluidStack drained;
        FluidStack fluid = this.tank.getFluid();
        if (fluid != null && fluid.isFluidEqual(new FluidStack(OpenBlocks.Fluids.xpJuice, 0)) && (drained = this.tankCapabilityWrapper.drain(requiredXPJuice = LiquidXpUtils.xpToLiquidRatio(requiredXp = MathHelper.func_76123_f((float)((float)player.func_71050_bK() * (1.0f - player.field_71106_cc)))), false)) != null && (xp = LiquidXpUtils.liquidToXpRatio(drained.amount)) > 0) {
            int actualDrain = LiquidXpUtils.xpToLiquidRatio(xp);
            EnchantmentUtils.addPlayerXP((EntityPlayer)player, (int)xp);
            this.tankCapabilityWrapper.drain(actualDrain, true);
            return true;
        }
        return false;
    }

    protected FluidActionResult tryEmptyItem(EntityPlayer player, @Nonnull ItemStack container) {
        FluidStack transfer;
        IFluidHandlerItem containerFluidHandler = FluidUtil.getFluidHandler((ItemStack)container);
        if (containerFluidHandler != null && (transfer = FluidUtil.tryFluidTransfer((IFluidHandler)this.tankCapabilityWrapper, (IFluidHandler)containerFluidHandler, (int)1000, (boolean)true)) != null) {
            SoundEvent soundevent = transfer.getFluid().getEmptySound(transfer);
            player.func_184185_a(soundevent, 1.0f, 1.0f);
            return new FluidActionResult(containerFluidHandler.getContainer());
        }
        return FluidActionResult.FAILURE;
    }

    public void func_73660_a() {
        ++this.ticksSinceLastSync;
        ++this.ticksSinceLastUpdate;
        if (Config.shouldTanksUpdate && !this.field_145850_b.field_72995_K && this.forceUpdate) {
            if (this.needsTankUpdate) {
                this.tank.updateNeighbours(this.field_145850_b, this.field_174879_c);
                this.needsTankUpdate = false;
            }
            this.forceUpdate = false;
            FluidStack contents = this.tank.getFluid();
            if (contents != null && contents.amount > 0 && this.field_174879_c.func_177956_o() > 0) {
                this.tryFillBottomTank(contents);
                contents = this.tank.getFluid();
            }
            if (contents != null && contents.amount > 0) {
                this.tryBalanceNeighbors(contents);
            }
            this.needsSync = true;
            this.markUpdated();
        }
        if (this.needsSync && !this.field_145850_b.field_72995_K && this.ticksSinceLastSync > 8) {
            this.needsSync = false;
            this.sync();
        }
        if (this.needsUpdate && this.ticksSinceLastUpdate > 20) {
            this.needsUpdate = false;
            this.ticksSinceLastUpdate = 0;
            this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q(), false);
        }
        if (this.field_145850_b.field_72995_K) {
            this.renderLogic.validateConnections(this.field_145850_b, this.func_174877_v());
        }
    }

    private void tryGetNeighbor(List<TileEntityTank> result, FluidStack fluid, EnumFacing side) {
        TileEntityTank neighbor = this.getTankInDirection(side);
        if (neighbor != null && neighbor.accepts(fluid)) {
            result.add(neighbor);
        }
    }

    private void tryBalanceNeighbors(FluidStack contents) {
        ArrayList neighbors = Lists.newArrayList();
        this.tryGetNeighbor(neighbors, contents, EnumFacing.NORTH);
        this.tryGetNeighbor(neighbors, contents, EnumFacing.SOUTH);
        this.tryGetNeighbor(neighbors, contents, EnumFacing.EAST);
        this.tryGetNeighbor(neighbors, contents, EnumFacing.WEST);
        int count = neighbors.size();
        if (count == 0) {
            return;
        }
        int sum = contents.amount;
        for (TileEntityTank n : neighbors) {
            sum += n.tank.getFluidAmount();
        }
        int suggestedAmount = sum / (count + 1);
        if (Math.abs(suggestedAmount - contents.amount) < Config.tankFluidUpdateThreshold) {
            return;
        }
        FluidStack suggestedStack = contents.copy();
        suggestedStack.amount = suggestedAmount;
        for (TileEntityTank n : neighbors) {
            int amount = n.tank.getFluidAmount();
            int diff = amount - suggestedAmount;
            if (diff != 1 && diff != 0 && diff != -1) {
                n.tank.setFluid(suggestedStack.copy());
                n.tankChanged();
                sum -= suggestedAmount;
                n.forceUpdate = true;
                continue;
            }
            sum -= amount;
        }
        FluidStack s = this.tank.getFluid();
        if (sum != s.amount) {
            s.amount = sum;
            this.tankChanged();
        }
    }

    private void notifyNeigbours() {
        this.needsUpdate = true;
    }

    private void tankChanged() {
        this.notifyNeigbours();
        this.tank.markDirty();
    }

    private void markContentsUpdated() {
        this.notifyNeigbours();
        this.forceUpdate = true;
    }

    private void tryFillBottomTank(FluidStack fluid) {
        int amount;
        TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b());
        if (te instanceof TileEntityTank && (amount = ((TileEntityTank)te).internalFill(fluid, true)) > 0) {
            this.internalDrain(amount, true);
        }
    }

    private FluidStack internalDrain(int amount, boolean doDrain) {
        FluidStack drained = this.tank.drain(amount, doDrain);
        if (drained != null && doDrain) {
            this.markContentsUpdated();
        }
        return drained;
    }

    private void drainFromColumn(FluidStack needed, boolean doDrain) {
        TileEntity te;
        if (!this.containsFluid(needed) || needed.amount <= 0) {
            return;
        }
        if (this.field_174879_c.func_177956_o() < 255 && (te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177984_a())) instanceof TileEntityTank) {
            ((TileEntityTank)te).drainFromColumn(needed, doDrain);
        }
        if (needed.amount <= 0) {
            return;
        }
        FluidStack drained = this.internalDrain(needed.amount, doDrain);
        if (drained == null) {
            return;
        }
        needed.amount -= drained.amount;
    }

    private int internalFill(FluidStack resource, boolean doFill) {
        int amount = this.tank.fill(resource, doFill);
        if (amount > 0 && doFill) {
            this.markContentsUpdated();
        }
        return amount;
    }

    private void fillColumn(FluidStack resource, boolean doFill) {
        TileEntity te;
        if (!this.accepts(resource) || resource.amount <= 0) {
            return;
        }
        int amount = this.internalFill(resource, doFill);
        resource.amount -= amount;
        if (resource.amount > 0 && this.field_174879_c.func_177956_o() < 255 && (te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177984_a())) instanceof TileEntityTank) {
            ((TileEntityTank)te).fillColumn(resource, doFill);
        }
    }

    public boolean suppressBlockHarvestDrops() {
        return true;
    }

    public void addHarvestDrops(EntityPlayer player, List<ItemStack> drops, IBlockState blockState, int fortune, boolean isSilkTouch) {
        ItemStack stack = new ItemStack((Block)OpenBlocks.Blocks.tank);
        if (this.tank.getFluidAmount() > 0) {
            NBTTagCompound tankTag = this.getItemNBT();
            NBTTagCompound itemTag = ItemUtils.getItemTag((ItemStack)stack);
            itemTag.func_74782_a("tank", (NBTBase)tankTag);
        }
        drops.add(stack);
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    public boolean hasFastRenderer() {
        return true;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.tankCapabilityWrapper;
        }
        return (T)super.getCapability(capability, facing);
    }

    private class RenderUpdateListeners
    implements ISyncListener {
        private FluidStack prevFluidStack;
        private int prevLuminosity;

        private RenderUpdateListeners() {
        }

        private boolean isSameFluid(FluidStack currentFluid) {
            if (currentFluid == null) {
                return this.prevFluidStack == null;
            }
            return currentFluid.isFluidEqual(this.prevFluidStack);
        }

        public void onSync(Set<ISyncableObject> changes) {
            if (changes.contains(TileEntityTank.this.tank)) {
                FluidStack fluidStack = TileEntityTank.this.tank.getFluid();
                if (!this.isSameFluid(fluidStack)) {
                    int luminosity;
                    TileEntityTank.this.field_145850_b.func_175704_b(TileEntityTank.this.field_174879_c, TileEntityTank.this.field_174879_c);
                    this.prevFluidStack = fluidStack;
                    int n = luminosity = fluidStack != null ? fluidStack.getFluid().getLuminosity(fluidStack) : 0;
                    if (luminosity != this.prevLuminosity) {
                        TileEntityTank.this.field_145850_b.func_175664_x(TileEntityTank.this.field_174879_c);
                        this.prevLuminosity = luminosity;
                    }
                }
                TileEntityTank.this.renderLogic.updateFluid(fluidStack);
            }
        }
    }
}

