/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import openblocks.OpenBlocks;
import openblocks.client.gui.GuiXPBottler;
import openblocks.common.LiquidXpUtils;
import openblocks.common.container.ContainerXPBottler;
import openmods.api.IHasGui;
import openmods.api.INeighbourAwareTile;
import openmods.api.INeighbourTeAwareTile;
import openmods.api.IValueProvider;
import openmods.api.IValueReceiver;
import openmods.fixers.GenericInventoryTeFixerWalker;
import openmods.fixers.RegisterFixer;
import openmods.gamelogic.WorkerLogic;
import openmods.gui.misc.IConfigurableGuiSlots;
import openmods.include.IncludeInterface;
import openmods.inventory.GenericInventory;
import openmods.inventory.IInventoryProvider;
import openmods.inventory.ItemMover;
import openmods.inventory.TileEntityInventory;
import openmods.liquids.SidedFluidCapabilityWrapper;
import openmods.sync.ISyncableObject;
import openmods.sync.SyncMap;
import openmods.sync.SyncableFlags;
import openmods.sync.SyncableInt;
import openmods.sync.SyncableSides;
import openmods.sync.SyncableTank;
import openmods.tileentity.SyncedTileEntity;
import openmods.utils.MiscUtils;
import openmods.utils.SidedInventoryAdapter;
import openmods.utils.SidedItemHandlerAdapter;
import openmods.utils.bitmap.BitMapUtils;
import openmods.utils.bitmap.IReadableBitMap;
import openmods.utils.bitmap.IRpcDirectionBitMap;
import openmods.utils.bitmap.IRpcIntBitMap;
import openmods.utils.bitmap.IWriteableBitMap;

@RegisterFixer(value=GenericInventoryTeFixerWalker.class)
public class TileEntityXPBottler
extends SyncedTileEntity
implements IInventoryProvider,
IHasGui,
IConfigurableGuiSlots<AutoSlots>,
INeighbourAwareTile,
INeighbourTeAwareTile,
ITickable {
    public static final int TANK_CAPACITY = LiquidXpUtils.xpToLiquidRatio(8);
    public static final int PROGRESS_TICKS = 40;
    protected static final ItemStack GLASS_BOTTLE = new ItemStack(Items.field_151069_bo, 1);
    protected static final ItemStack XP_BOTTLE = new ItemStack(Items.field_151062_by, 1);
    private boolean needsTankUpdate;
    private final GenericInventory inventory = this.registerInventoryCallback((GenericInventory)new TileEntityInventory((TileEntity)this, "xpbottler", true, 2){

        public boolean func_94041_b(int slot, @Nonnull ItemStack itemstack) {
            if (slot != Slots.input.ordinal()) {
                return false;
            }
            return itemstack.func_77973_b() == Items.field_151069_bo;
        }
    });
    @IncludeInterface(value=ISidedInventory.class)
    private final SidedInventoryAdapter sided = new SidedInventoryAdapter((IInventory)this.inventory);
    private final SidedItemHandlerAdapter itemHandlerCapability = new SidedItemHandlerAdapter(this.inventory.getHandler());
    private SyncableInt progress;
    private SyncableSides glassSides;
    private SyncableSides xpBottleSides;
    private SyncableSides xpSides;
    private SyncableFlags automaticSlots;
    private SyncableTank tank;
    private final WorkerLogic logic = new WorkerLogic(this.progress, 40);
    private final SidedFluidCapabilityWrapper tankCapability = SidedFluidCapabilityWrapper.wrap((IFluidHandler)this.tank, (IReadableBitMap)this.xpSides, (boolean)false, (boolean)true);

    protected void createSyncedFields() {
        this.progress = new SyncableInt();
        this.glassSides = new SyncableSides();
        this.xpBottleSides = new SyncableSides();
        this.xpSides = new SyncableSides();
        this.automaticSlots = SyncableFlags.create((int)AutoSlots.values().length);
        this.tank = new SyncableTank(TANK_CAPACITY, new Fluid[]{OpenBlocks.Fluids.xpJuice});
    }

    protected void onSyncMapCreate(SyncMap syncMap) {
        syncMap.addSyncListener(this.itemHandlerCapability.createSyncListener());
    }

    public TileEntityXPBottler() {
        this.sided.registerSlot((Enum)Slots.input, (IReadableBitMap)this.glassSides, true, false);
        this.sided.registerSlot((Enum)Slots.output, (IReadableBitMap)this.xpBottleSides, false, true);
        this.itemHandlerCapability.registerSlot((Enum)Slots.input, (IReadableBitMap)this.glassSides, true, false);
        this.itemHandlerCapability.registerSlot((Enum)Slots.output, (IReadableBitMap)this.xpBottleSides, false, true);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.tankCapability.hasHandler(facing);
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemHandlerCapability.hasHandler(facing);
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.tankCapability.getHandler(facing);
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.itemHandlerCapability.getHandler(facing);
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.automaticSlots.get((Enum)AutoSlots.xp)) {
                if (this.needsTankUpdate) {
                    this.tank.updateNeighbours(this.field_145850_b, this.field_174879_c);
                    this.needsTankUpdate = false;
                }
                this.tank.fillFromSides(10, this.field_145850_b, this.field_174879_c, this.xpSides.getValue());
            }
            ItemMover mover = new ItemMover(this.field_145850_b, this.field_174879_c).breakAfterFirstTry().randomizeSides().setMaxSize(1);
            if (this.shouldAutoOutput() && this.hasOutputStack()) {
                mover.setSides(this.xpBottleSides.getValue()).pushFromSlot((IItemHandler)this.inventory.getHandler(), Slots.output.ordinal());
            }
            if (this.shouldAutoInput() && !this.hasGlassInInput()) {
                mover.setSides(this.glassSides.getValue()).pullToSlot((IItemHandler)this.inventory.getHandler(), Slots.input.ordinal());
            }
            this.logic.checkWorkCondition(this.hasSpaceInOutput() && this.hasGlassInInput() && this.isTankFull());
            if (this.logic.update()) {
                this.playSoundAtBlock(OpenBlocks.Sounds.BLOCK_XPBOTTLER_DONE, 0.5f, 0.8f);
                this.inventory.func_70298_a(Slots.input.ordinal(), 1);
                this.tank.setFluid(null);
                ItemStack outputStack = this.inventory.func_70301_a(Slots.output.ordinal());
                if (outputStack.func_190926_b()) {
                    this.inventory.func_70299_a(Slots.output.ordinal(), XP_BOTTLE.func_77946_l());
                } else {
                    outputStack.func_190917_f(1);
                }
                this.inventory.onInventoryChanged(Slots.output.ordinal());
            }
            this.sync();
        }
    }

    public Object getServerGui(EntityPlayer player) {
        return new ContainerXPBottler((IInventory)player.field_71071_by, this);
    }

    public Object getClientGui(EntityPlayer player) {
        return new GuiXPBottler(new ContainerXPBottler((IInventory)player.field_71071_by, this));
    }

    public boolean canOpenGui(EntityPlayer player) {
        return true;
    }

    public IValueProvider<Integer> getProgress() {
        return this.progress;
    }

    public boolean hasOutputStack() {
        ItemStack outputStack = this.inventory.func_70301_a(1);
        return !outputStack.func_190926_b();
    }

    public boolean shouldAutoInput() {
        return this.automaticSlots.get((Enum)AutoSlots.input);
    }

    public boolean shouldAutoOutput() {
        return this.automaticSlots.get((Enum)AutoSlots.output);
    }

    public boolean hasGlassInInput() {
        ItemStack inputStack = this.inventory.func_70301_a(Slots.input.ordinal());
        return !inputStack.func_190926_b() && inputStack.func_77969_a(GLASS_BOTTLE);
    }

    public boolean hasSpaceInOutput() {
        ItemStack outputStack = this.inventory.func_70301_a(Slots.output.ordinal());
        return outputStack.func_190926_b() || outputStack.func_77969_a(XP_BOTTLE) && outputStack.func_190916_E() < outputStack.func_77976_d();
    }

    public boolean isTankFull() {
        return this.tank.getFluidAmount() == this.tank.getCapacity();
    }

    public IValueProvider<FluidStack> getFluidProvider() {
        return this.tank;
    }

    public IInventory getInventory() {
        return this.inventory;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag = super.func_189515_b(tag);
        this.inventory.writeToNBT(tag);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.inventory.readFromNBT(tag);
    }

    private SyncableSides selectSlotMap(AutoSlots slot) {
        switch (slot) {
            case input: {
                return this.glassSides;
            }
            case output: {
                return this.xpBottleSides;
            }
            case xp: {
                return this.xpSides;
            }
        }
        throw MiscUtils.unhandledEnum((Enum)slot);
    }

    public IValueProvider<Set<EnumFacing>> createAllowedDirectionsProvider(AutoSlots slot) {
        return this.selectSlotMap(slot);
    }

    public IWriteableBitMap<EnumFacing> createAllowedDirectionsReceiver(AutoSlots slot) {
        SyncableSides dirs = this.selectSlotMap(slot);
        return BitMapUtils.createRpcAdapter((IRpcDirectionBitMap)((IRpcDirectionBitMap)this.createRpcProxy((ISyncableObject)dirs, IRpcDirectionBitMap.class, new Class[0])));
    }

    public IValueProvider<Boolean> createAutoFlagProvider(AutoSlots slot) {
        return BitMapUtils.singleBitProvider((IReadableBitMap)this.automaticSlots, (Object)slot.ordinal());
    }

    public IValueReceiver<Boolean> createAutoSlotReceiver(AutoSlots slot) {
        IRpcIntBitMap bits = (IRpcIntBitMap)this.createRpcProxy((ISyncableObject)this.automaticSlots, IRpcIntBitMap.class, new Class[0]);
        return BitMapUtils.singleBitReceiver((IRpcIntBitMap)bits, (int)slot.ordinal());
    }

    public void func_145829_t() {
        super.func_145829_t();
        this.needsTankUpdate = true;
    }

    public void onNeighbourChanged(BlockPos neighbourPos, Block neighbourBlock) {
        this.needsTankUpdate = true;
    }

    public void onNeighbourTeChanged(BlockPos pos) {
        this.needsTankUpdate = true;
    }

    public static enum AutoSlots {
        input,
        output,
        xp;

    }

    public static enum Slots {
        input,
        output;

    }
}

