/*
 * Decompiled with CFR 0.152.
 */
package ferro2000.immersivetech.client.connectors;

import blusunrize.immersiveengineering.client.models.smart.ConnModelReal;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.common.model.IModelState;

public class ITConnLoader
implements ICustomModelLoader {
    public static final String RESOURCE_LOCATION = "models/block/smartmodel/conns_";
    public static Map<String, ImmutableMap<String, String>> textureReplacements = new HashMap<String, ImmutableMap<String, String>>();
    public static Map<String, ResourceLocation> baseModels = new HashMap<String, ResourceLocation>();

    public void func_110549_a(IResourceManager resourceManager) {
        ConnModelReal.cache.clear();
    }

    public boolean accepts(ResourceLocation modelLocation) {
        return modelLocation.func_110623_a().contains(RESOURCE_LOCATION);
    }

    public IModel loadModel(ResourceLocation modelLocation) throws IOException {
        String name;
        ResourceLocation r;
        String resourcePath = modelLocation.func_110623_a();
        int pos = resourcePath.indexOf("conns_");
        if (pos >= 0 && (r = baseModels.get(name = resourcePath.substring(pos += 6))) != null) {
            if (textureReplacements.containsKey(name)) {
                return new ConnModelBase(r, textureReplacements.get(name));
            }
            return new ConnModelBase(r);
        }
        return ModelLoaderRegistry.getMissingModel();
    }

    static {
        baseModels.put("conn_timer", new ResourceLocation("immersivetech:block/connector/connectors_timer.obj.ie"));
    }

    private class ConnModelBase
    implements IModel {
        ResourceLocation base;
        ImmutableMap<String, String> texReplace;

        public ConnModelBase(ResourceLocation b, ImmutableMap<String, String> t) {
            this.base = b;
            this.texReplace = t;
        }

        public ConnModelBase(ResourceLocation b) {
            this(b, (ImmutableMap<String, String>)ImmutableMap.of((Object)"", (Object)""));
        }

        public Collection<ResourceLocation> getDependencies() {
            return ImmutableList.of((Object)this.base);
        }

        public Collection<ResourceLocation> getTextures() {
            try {
                ArrayList<ResourceLocation> ret = new ArrayList<ResourceLocation>(ModelLoaderRegistry.getModel((ResourceLocation)this.base).getTextures());
                for (String tex : this.texReplace.values()) {
                    ret.add(new ResourceLocation(tex));
                }
                ret.add(new ResourceLocation("immersivetech".toLowerCase(Locale.ENGLISH) + ":blocks/wire"));
                return ret;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
            try {
                IModel model = ModelLoaderRegistry.getModel((ResourceLocation)this.base);
                if (model instanceof OBJModel) {
                    model = model.retexture(this.texReplace);
                    OBJModel obj = (OBJModel)model;
                    model = obj.process(ImmutableMap.of((Object)"flip-v", (Object)"true"));
                }
                return new ConnModelReal(model.bake(state, format, bakedTextureGetter));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public IModelState getDefaultState() {
            return null;
        }
    }
}

