/*
 * Decompiled with CFR 0.152.
 */
package ferro2000.immersivetech.common;

import blusunrize.immersiveengineering.api.MultiblockHandler;
import blusunrize.immersiveengineering.api.crafting.MixerRecipe;
import ferro2000.immersivetech.api.craftings.BoilerRecipes;
import ferro2000.immersivetech.api.craftings.DistillerRecipes;
import ferro2000.immersivetech.api.craftings.SolarTowerRecipes;
import ferro2000.immersivetech.api.energy.SteamHandler;
import ferro2000.immersivetech.common.blocks.BlockITBase;
import ferro2000.immersivetech.common.blocks.BlockITFluid;
import ferro2000.immersivetech.common.blocks.metal.BlockConnectors;
import ferro2000.immersivetech.common.blocks.metal.BlockMetalMultiblock;
import ferro2000.immersivetech.common.blocks.metal.multiblocks.MultiblockAlternator;
import ferro2000.immersivetech.common.blocks.metal.multiblocks.MultiblockBoiler;
import ferro2000.immersivetech.common.blocks.metal.multiblocks.MultiblockDistiller;
import ferro2000.immersivetech.common.blocks.metal.multiblocks.MultiblockSolarReflector;
import ferro2000.immersivetech.common.blocks.metal.multiblocks.MultiblockSolarTower;
import ferro2000.immersivetech.common.blocks.metal.multiblocks.MultiblockSteamTurbine;
import ferro2000.immersivetech.common.blocks.metal.tileentities.TileEntityAlternator;
import ferro2000.immersivetech.common.blocks.metal.tileentities.TileEntityBoiler;
import ferro2000.immersivetech.common.blocks.metal.tileentities.TileEntityDistiller;
import ferro2000.immersivetech.common.blocks.metal.tileentities.TileEntitySolarReflector;
import ferro2000.immersivetech.common.blocks.metal.tileentities.TileEntitySolarTower;
import ferro2000.immersivetech.common.blocks.metal.tileentities.TileEntitySteamTurbine;
import ferro2000.immersivetech.common.blocks.metal.tileentities.TileEntityTimer;
import ferro2000.immersivetech.common.items.ItemITBase;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;

@Mod.EventBusSubscriber(modid="immersivetech")
public class ITContent {
    public static ArrayList<Block> registeredITBlocks = new ArrayList();
    public static BlockITBase blockMetalMultiblock;
    public static BlockITBase blockConnectors;
    public static BlockITFluid blockFluidDistWater;
    public static BlockITFluid blockFluidSteam;
    public static BlockITFluid blockFluidSlime;
    public static ArrayList<Item> registeredITItems;
    public static Item itemMaterial;
    public static Fluid fluidDistWater;
    public static Fluid fluidSteam;
    public static Fluid fluidSlime;

    public static void preInit() {
        blockMetalMultiblock = new BlockMetalMultiblock();
        blockConnectors = new BlockConnectors();
        fluidDistWater = new Fluid("dist_water", new ResourceLocation("immersivetech:blocks/fluid/dist_water_still"), new ResourceLocation("immersivetech:blocks/fluid/dist_water_flow")).setDensity(1000).setViscosity(1000);
        if (!FluidRegistry.registerFluid((Fluid)fluidDistWater)) {
            fluidDistWater = FluidRegistry.getFluid((String)"distwater");
        }
        FluidRegistry.addBucketForFluid((Fluid)fluidDistWater);
        fluidSteam = new Fluid("steam", new ResourceLocation("immersivetech:blocks/fluid/steam_still"), new ResourceLocation("immersivetech:blocks/fluid/steam_flow")).setDensity(-100).setViscosity(500).setGaseous(true);
        if (!FluidRegistry.registerFluid((Fluid)fluidSteam)) {
            fluidSteam = FluidRegistry.getFluid((String)"steam");
        }
        FluidRegistry.addBucketForFluid((Fluid)fluidSteam);
        fluidSlime = new Fluid("slime", new ResourceLocation("immersivetech:blocks/fluid/slime_still"), new ResourceLocation("immersivetech:blocks/fluid/slime_flow")).setDensity(5000).setViscosity(5000);
        if (!FluidRegistry.registerFluid((Fluid)fluidSlime)) {
            fluidSlime = FluidRegistry.getFluid((String)"slime");
        }
        FluidRegistry.addBucketForFluid((Fluid)fluidSlime);
        blockFluidDistWater = new BlockITFluid("fluidDistWater", fluidDistWater, Material.field_151586_h);
        blockFluidSteam = new BlockITFluid("fluidSteam", fluidSteam, Material.field_151586_h);
        blockFluidSlime = new BlockITFluid("fluidSlime", fluidSlime, Material.field_151586_h);
        itemMaterial = new ItemITBase("material", 64, "salt");
    }

    public static void init() {
        ITContent.registerTile(TileEntityDistiller.class);
        ITContent.registerTile(TileEntitySolarTower.class);
        ITContent.registerTile(TileEntitySolarReflector.class);
        ITContent.registerTile(TileEntitySteamTurbine.class);
        ITContent.registerTile(TileEntityBoiler.class);
        ITContent.registerTile(TileEntityAlternator.class);
        ITContent.registerTile(TileEntityTimer.class);
        MultiblockHandler.registerMultiblock((MultiblockHandler.IMultiblock)MultiblockDistiller.instance);
        MultiblockHandler.registerMultiblock((MultiblockHandler.IMultiblock)MultiblockSolarTower.instance);
        MultiblockHandler.registerMultiblock((MultiblockHandler.IMultiblock)MultiblockSolarReflector.instance);
        MultiblockHandler.registerMultiblock((MultiblockHandler.IMultiblock)MultiblockSteamTurbine.instance);
        MultiblockHandler.registerMultiblock((MultiblockHandler.IMultiblock)MultiblockBoiler.instance);
        MultiblockHandler.registerMultiblock((MultiblockHandler.IMultiblock)MultiblockAlternator.instance);
        DistillerRecipes.addRecipe(new FluidStack(fluidDistWater, 100), new FluidStack(FluidRegistry.WATER, 200), new ItemStack(itemMaterial, 1, 0), 50, 1, 0.0025f);
        SolarTowerRecipes.addRecipe(new FluidStack(fluidSteam, 100), new FluidStack(FluidRegistry.WATER, 200), 10);
        SolarTowerRecipes.addRecipe(new FluidStack(fluidSteam, 150), new FluidStack(fluidDistWater, 200), 10);
        BoilerRecipes.addRecipe(new FluidStack(fluidSteam, 100), new FluidStack(FluidRegistry.WATER, 200), 10);
        BoilerRecipes.addRecipe(new FluidStack(fluidSteam, 150), new FluidStack(fluidDistWater, 200), 10);
        MixerRecipe.addRecipe((FluidStack)new FluidStack(fluidSlime, 500), (FluidStack)new FluidStack(FluidRegistry.WATER, 500), (Object[])new Object[]{Items.field_151119_aD, Items.field_151015_O}, (int)1600);
        SteamHandler.registerSteam(fluidSteam, 50);
        SteamHandler.registerSteam(FluidRegistry.getFluid((String)"steam"), 50);
    }

    public static void registerTile(Class<? extends TileEntity> tile) {
        String s = tile.getSimpleName();
        s = s.substring(s.indexOf("TileEntity") + "TileEntity".length());
        GameRegistry.registerTileEntity(tile, (String)("immersivetech:" + s));
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        for (Block block : registeredITBlocks) {
            event.getRegistry().register(block.setRegistryName(ITContent.createRegistryName(block.func_149739_a())));
        }
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        for (Item item : registeredITItems) {
            event.getRegistry().register(item.setRegistryName(ITContent.createRegistryName(item.func_77658_a())));
        }
    }

    private static ResourceLocation createRegistryName(String unlocalized) {
        unlocalized = unlocalized.substring(unlocalized.indexOf("immersive"));
        unlocalized = unlocalized.replaceFirst("\\.", ":");
        return new ResourceLocation(unlocalized);
    }

    private static Fluid setupFluid(Fluid fluid) {
        FluidRegistry.addBucketForFluid((Fluid)fluid);
        if (!FluidRegistry.registerFluid((Fluid)fluid)) {
            return FluidRegistry.getFluid((String)fluid.getName());
        }
        return fluid;
    }

    static {
        registeredITItems = new ArrayList();
    }
}

