/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.entity;

import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.entity.EntityRollingStock;
import cam72cam.immersiverailroading.items.ItemRollingStockComponent;
import cam72cam.immersiverailroading.items.nbt.ItemComponent;
import cam72cam.immersiverailroading.items.nbt.ItemDefinition;
import cam72cam.immersiverailroading.items.nbt.ItemGauge;
import cam72cam.immersiverailroading.items.nbt.ItemPlateType;
import cam72cam.immersiverailroading.library.AssemblyStep;
import cam72cam.immersiverailroading.library.ChatText;
import cam72cam.immersiverailroading.library.ItemComponentType;
import cam72cam.immersiverailroading.net.BuildableStockSyncPacket;
import cam72cam.immersiverailroading.util.BufferUtil;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class EntityBuildableRollingStock
extends EntityRollingStock {
    private boolean isBuilt = false;
    private List<ItemComponentType> builtItems = new ArrayList<ItemComponentType>();

    public EntityBuildableRollingStock(World world, String defID) {
        super(world, defID);
    }

    @Override
    public void readSpawnData(ByteBuf additionalData) {
        super.readSpawnData(additionalData);
        this.setComponents(BufferUtil.readItemComponentTypes(additionalData));
    }

    @Override
    public void writeSpawnData(ByteBuf buffer) {
        super.writeSpawnData(buffer);
        BufferUtil.writeItemComponentTypes(buffer, this.builtItems);
    }

    @Override
    protected void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74757_a("isBuilt", this.isBuilt);
        int[] items = new int[this.builtItems.size()];
        for (int i = 0; i < items.length; ++i) {
            items[i] = this.builtItems.get(i).ordinal();
        }
        nbt.func_74783_a("builtItems", items);
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.isBuilt = nbt.func_74767_n("isBuilt");
        if (this.isBuilt) {
            this.setComponents(this.getDefinition().getItemComponents());
        } else {
            ArrayList<ItemComponentType> newItems = new ArrayList<ItemComponentType>();
            int[] items = nbt.func_74759_k("builtItems");
            for (int i = 0; i < items.length; ++i) {
                newItems.add(ItemComponentType.values()[items[i]]);
            }
            this.setComponents(newItems);
        }
    }

    public void setComponents(List<ItemComponentType> items) {
        this.builtItems = new ArrayList<ItemComponentType>(items);
        this.isBuilt = false;
        this.isBuilt = this.getMissingItemComponents().isEmpty();
        if (!this.field_70170_p.field_72995_K) {
            this.sendToObserving(new BuildableStockSyncPacket(this));
        }
        if (this.isBuilt()) {
            this.onAssemble();
        } else {
            this.onDissassemble();
        }
    }

    public List<ItemComponentType> getItemComponents() {
        return this.builtItems;
    }

    public boolean isBuilt() {
        return this.isBuilt;
    }

    public boolean areWheelsBuilt() {
        if (this.isBuilt) {
            return this.isBuilt;
        }
        for (ItemComponentType item : this.getMissingItemComponents()) {
            if (!item.isWheelPart()) continue;
            return false;
        }
        return true;
    }

    public List<ItemComponentType> getMissingItemComponents() {
        ArrayList<ItemComponentType> missing = new ArrayList<ItemComponentType>();
        if (this.isBuilt) {
            return missing;
        }
        missing.addAll(this.getDefinition().getItemComponents());
        for (ItemComponentType item : this.getItemComponents()) {
            missing.remove((Object)item);
        }
        return missing;
    }

    public boolean hasAllWheels() {
        for (ItemComponentType item : this.getMissingItemComponents()) {
            if (!item.isWheelPart()) continue;
            return false;
        }
        return true;
    }

    public void addComponent(ItemComponentType item) {
        this.builtItems.add(item);
        this.isBuilt = this.getMissingItemComponents().isEmpty();
        if (this.isBuilt) {
            this.onAssemble();
        }
        this.sendToObserving(new BuildableStockSyncPacket(this));
    }

    public void addNextComponent(EntityPlayer player) {
        if (this.isBuilt()) {
            player.func_145747_a((ITextComponent)ChatText.STOCK_BUILT.getMessage(this.getDefinition().name));
            return;
        }
        ArrayList<ItemComponentType> toAdd = new ArrayList<ItemComponentType>();
        for (AssemblyStep step : AssemblyStep.values()) {
            for (ItemComponentType component : this.getMissingItemComponents()) {
                if (component.step != step) continue;
                toAdd.add(component);
            }
            if (toAdd.size() != 0) break;
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemComponentType type;
            ItemStack found = player.field_71071_by.func_70301_a(i);
            if (found.func_77973_b() != ImmersiveRailroading.ITEM_ROLLING_STOCK_COMPONENT || !ItemDefinition.getID(found).equals(this.defID) || !player.func_184812_l_() && ItemGauge.get(found) != this.gauge || ItemRollingStockComponent.requiresHammering(found) || !toAdd.contains((Object)(type = ItemComponent.getComponentType(found)))) continue;
            this.addComponent(type);
            player.field_71071_by.func_70298_a(i, 1);
            return;
        }
        int largePlates = 0;
        int mediumPlates = 0;
        int smallPlates = 0;
        block17: for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack found = player.field_71071_by.func_70301_a(i);
            if (found.func_77973_b() != ImmersiveRailroading.ITEM_PLATE || ItemGauge.get(found) != this.gauge) continue;
            switch (ItemPlateType.get(found)) {
                case LARGE: {
                    largePlates += found.func_190916_E();
                    continue block17;
                }
                case MEDIUM: {
                    mediumPlates += found.func_190916_E();
                    continue block17;
                }
                case SMALL: {
                    smallPlates += found.func_190916_E();
                    continue block17;
                }
            }
        }
        block18: for (ItemComponentType type : toAdd) {
            ItemStack itemUsed;
            ItemStack found;
            int platesStart = 0;
            int platesUsed = 0;
            switch (type.crafting) {
                case PLATE_LARGE: {
                    platesStart = largePlates;
                    break;
                }
                case PLATE_MEDIUM: {
                    platesStart = mediumPlates;
                    break;
                }
                case PLATE_SMALL: {
                    platesStart = smallPlates;
                    break;
                }
                default: {
                    continue block18;
                }
            }
            platesUsed = type.getPlateCost(this.gauge, this.getDefinition());
            if (platesStart < platesUsed) continue;
            for (int i = 0; i < player.field_71071_by.func_70302_i_() && ((found = player.field_71071_by.func_70301_a(i)).func_77973_b() != ImmersiveRailroading.ITEM_PLATE || ItemGauge.get(found) != this.gauge || ItemPlateType.get(found) != type.getPlateType() || (platesUsed -= (itemUsed = player.field_71071_by.func_70298_a(i, platesUsed)).func_190916_E()) > 0); ++i) {
            }
            this.addComponent(type);
            return;
        }
        HashMap<ItemComponentType, Integer> addMap = new HashMap<ItemComponentType, Integer>();
        for (ItemComponentType component : toAdd) {
            if (!addMap.containsKey((Object)component)) {
                addMap.put(component, 0);
            }
            addMap.put(component, (Integer)addMap.get((Object)component) + 1);
        }
        player.func_145747_a((ITextComponent)ChatText.STOCK_MISSING.getMessage(""));
        for (ItemComponentType component : addMap.keySet()) {
            String str = String.format("%d x %s", new Object[]{addMap.get((Object)component), component});
            switch (component.crafting) {
                case CASTING: 
                case CASTING_HAMMER: 
                case PLATE_BOILER: {
                    str = str + String.format(" (%s)", component.crafting.toString());
                    break;
                }
                case PLATE_LARGE: 
                case PLATE_MEDIUM: 
                case PLATE_SMALL: {
                    str = str + String.format(" (%d x %s)", new Object[]{component.getPlateCost(this.gauge, this.getDefinition()) * (Integer)addMap.get((Object)component), component.getPlateType()});
                    break;
                }
            }
            player.func_145747_a((ITextComponent)new TextComponentString(str));
        }
    }

    public ItemComponentType removeNextComponent(EntityPlayer player) {
        if (this.isBuilt) {
            this.onDissassemble();
        }
        this.isBuilt = false;
        if (this.builtItems.size() <= 1) {
            player.func_145747_a((ITextComponent)ChatText.STOCK_DISSASEMBLED.getMessage(this.getDefinition().name));
            return null;
        }
        ItemComponentType toRemove = null;
        for (AssemblyStep step : AssemblyStep.reverse()) {
            for (ItemComponentType component : this.builtItems) {
                if (component == ItemComponentType.FRAME || component.step != step) continue;
                toRemove = component;
                break;
            }
            if (toRemove != null) break;
        }
        this.builtItems.remove((Object)toRemove);
        this.sendToObserving(new BuildableStockSyncPacket(this));
        ItemStack item = new ItemStack((Item)ImmersiveRailroading.ITEM_ROLLING_STOCK_COMPONENT, 1, 0);
        ItemDefinition.setID(item, this.defID);
        ItemGauge.set(item, this.gauge);
        ItemComponent.setComponentType(item, toRemove);
        this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, item));
        return toRemove;
    }

    @Override
    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (super.func_184230_a(player, hand)) {
            return true;
        }
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        if (player.func_184586_b(hand).func_77973_b() == ImmersiveRailroading.ITEM_LARGE_WRENCH || player.func_184586_b(hand).func_77973_b() == ImmersiveRailroading.ITEM_ROLLING_STOCK_COMPONENT) {
            if (!player.func_70093_af()) {
                this.addNextComponent(player);
            } else {
                this.removeNextComponent(player);
            }
            return true;
        }
        return false;
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.isBuilt) {
            ItemStack item = new ItemStack((Item)ImmersiveRailroading.ITEM_ROLLING_STOCK, 1, 0);
            ItemDefinition.setID(item, this.defID);
            ItemGauge.set(item, this.gauge);
            this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, item));
        } else {
            for (ItemComponentType component : this.builtItems) {
                ItemStack item = new ItemStack((Item)ImmersiveRailroading.ITEM_ROLLING_STOCK_COMPONENT, 1, 0);
                ItemDefinition.setID(item, this.defID);
                ItemGauge.set(item, this.gauge);
                ItemComponent.setComponentType(item, component);
                this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, item));
            }
        }
        this.isBuilt = false;
        this.builtItems = new ArrayList<ItemComponentType>();
    }

    public void onAssemble() {
    }

    public void onDissassemble() {
    }
}

