/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.entity;

import cam72cam.immersiverailroading.Config;
import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.entity.EntityRidableRollingStock;
import cam72cam.immersiverailroading.library.Augment;
import cam72cam.immersiverailroading.net.MRSSyncPacket;
import cam72cam.immersiverailroading.physics.MovementSimulator;
import cam72cam.immersiverailroading.physics.TickPos;
import cam72cam.immersiverailroading.tile.TileRail;
import cam72cam.immersiverailroading.tile.TileRailBase;
import cam72cam.immersiverailroading.util.BlockUtil;
import cam72cam.immersiverailroading.util.BufferUtil;
import cam72cam.immersiverailroading.util.RedstoneUtil;
import cam72cam.immersiverailroading.util.Speed;
import cam72cam.immersiverailroading.util.VecUtil;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class EntityMoveableRollingStock
extends EntityRidableRollingStock {
    private Float frontYaw;
    private Float rearYaw;
    public float distanceTraveled = 0.0f;
    public float renderDistanceTraveled = 0.0f;
    public double tickPosID = 0.0;
    private Speed currentSpeed;
    public List<TickPos> positions = new ArrayList<TickPos>();
    private AxisAlignedBB boundingBox;

    public EntityMoveableRollingStock(World world, String defID) {
        super(world, defID);
    }

    @Override
    public void readSpawnData(ByteBuf additionalData) {
        super.readSpawnData(additionalData);
        this.frontYaw = BufferUtil.readFloat(additionalData);
        this.rearYaw = BufferUtil.readFloat(additionalData);
        this.tickPosID = additionalData.readInt();
    }

    @Override
    public void writeSpawnData(ByteBuf buffer) {
        super.writeSpawnData(buffer);
        BufferUtil.writeFloat(buffer, this.frontYaw);
        BufferUtil.writeFloat(buffer, this.rearYaw);
        buffer.writeInt((int)this.tickPosID);
        this.sendToObserving(new MRSSyncPacket(this, this.positions));
    }

    @Override
    protected void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        if (this.frontYaw != null) {
            nbttagcompound.func_74776_a("frontYaw", this.frontYaw.floatValue());
        }
        if (this.rearYaw != null) {
            nbttagcompound.func_74776_a("rearYaw", this.rearYaw.floatValue());
        }
        nbttagcompound.func_74776_a("distanceTraveled", this.distanceTraveled);
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        if (nbttagcompound.func_74764_b("frontYaw")) {
            this.frontYaw = Float.valueOf(nbttagcompound.func_74760_g("frontYaw"));
        }
        if (nbttagcompound.func_74764_b("rearYaw")) {
            this.rearYaw = Float.valueOf(nbttagcompound.func_74760_g("rearYaw"));
        }
        this.distanceTraveled = nbttagcompound.func_74760_g("distanceTraveled");
        if (this.frontYaw == null) {
            this.frontYaw = Float.valueOf(this.field_70177_z);
        }
        if (this.rearYaw == null) {
            this.rearYaw = Float.valueOf(this.field_70177_z);
        }
        this.initPositions();
    }

    public void initPositions() {
        this.positions = new ArrayList<TickPos>();
        this.positions.add(new TickPos((int)this.tickPosID, this.getCurrentSpeed(), this.func_174791_d(), this.field_70177_z, this.field_70177_z, this.field_70177_z, this.field_70125_A, false));
    }

    public void initPositions(TickPos tp) {
        this.positions = new ArrayList<TickPos>();
        this.positions.add(tp);
    }

    public AxisAlignedBB func_70046_E() {
        return this.func_174813_aQ().func_191195_a(0.0, 0.5, 0.0).func_72317_d(0.0, 0.5, 0.0);
    }

    public AxisAlignedBB func_174813_aQ() {
        if (this.boundingBox == null) {
            this.boundingBox = this.getDefinition().getBounds(this, this.gauge);
        }
        return this.boundingBox;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_184177_bl() {
        return this.func_174813_aQ().func_186662_g(50.0);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
    }

    public void func_70016_h(double x, double y, double z) {
    }

    public Speed getCurrentSpeed() {
        if (this.currentSpeed == null) {
            float speed = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
            if (Float.isNaN(speed)) {
                speed = 0.0f;
            }
            this.currentSpeed = Speed.fromMinecraft(speed);
        }
        return this.currentSpeed;
    }

    public void setCurrentSpeed(Speed newSpeed) {
        this.currentSpeed = newSpeed;
    }

    public void handleTickPosPacket(List<TickPos> newPositions) {
        if (newPositions.size() != 0) {
            this.clearPositionCache();
            if (this.field_70173_aa > 5) {
                ImmersiveRailroading.proxy.addTickMetric(this.tickPosID - (double)newPositions.get((int)0).tickID);
            }
            this.tickPosID = newPositions.get((int)0).tickID;
        }
        this.positions = newPositions;
    }

    public TickPos getTickPos(int tickID) {
        if (this.positions.size() == 0) {
            return null;
        }
        for (TickPos pos : this.positions) {
            if (pos.tickID != tickID) continue;
            return pos;
        }
        return this.positions.get(this.positions.size() - 1);
    }

    public TickPos getCurrentTickPosAndPrune() {
        if (this.positions.size() == 0) {
            return null;
        }
        if (this.positions.get((int)0).tickID != (int)this.tickPosID) {
            while (this.positions.get((int)0).tickID < (int)this.tickPosID && this.positions.size() > 1) {
                this.positions.remove(0);
            }
        }
        return this.positions.get(0);
    }

    public int getRemainingPositions() {
        return this.positions.size();
    }

    private double skewScalar(double curr, double next) {
        if (this.field_70170_p.field_72995_K) {
            return curr + (next - curr) * ImmersiveRailroading.proxy.serverTicksPerClientTick();
        }
        return next;
    }

    private float skewScalar(float curr, float next) {
        if (this.field_70170_p.field_72995_K) {
            return curr + (next - curr) * (float)ImmersiveRailroading.proxy.serverTicksPerClientTick();
        }
        return next;
    }

    private float fixAngleInterp(float curr, float next) {
        if (curr - next > 180.0f) {
            curr -= 360.0f;
        }
        if (next - curr > 180.0f) {
            curr += 360.0f;
        }
        return curr;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        this.tickPosID += this.field_70170_p.field_72995_K ? ImmersiveRailroading.proxy.serverTicksPerClientTick() : 1.0;
        TickPos currentPos = this.getCurrentTickPosAndPrune();
        if (currentPos == null) {
            return;
        }
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.field_70142_S = this.field_70165_t;
        this.field_70137_T = this.field_70163_u;
        this.field_70136_U = this.field_70161_v;
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
        this.field_70165_t = this.skewScalar(this.field_70165_t, currentPos.position.field_72450_a);
        this.field_70163_u = this.skewScalar(this.field_70163_u, currentPos.position.field_72448_b);
        this.field_70161_v = this.skewScalar(this.field_70161_v, currentPos.position.field_72449_c);
        if (this.field_70170_p.field_72995_K) {
            this.field_70126_B = this.fixAngleInterp(this.field_70126_B, currentPos.rotationYaw);
            this.field_70177_z = this.fixAngleInterp(this.field_70177_z, currentPos.rotationYaw);
            this.frontYaw = Float.valueOf(this.fixAngleInterp(this.frontYaw == null ? this.field_70177_z : this.frontYaw.floatValue(), currentPos.frontYaw));
            this.rearYaw = Float.valueOf(this.fixAngleInterp(this.rearYaw == null ? this.field_70177_z : this.rearYaw.floatValue(), currentPos.rearYaw));
        }
        this.field_70177_z = this.skewScalar(this.field_70177_z, currentPos.rotationYaw);
        this.field_70125_A = this.skewScalar(this.field_70125_A, currentPos.rotationPitch);
        this.frontYaw = Float.valueOf(this.skewScalar(this.frontYaw == null ? this.field_70177_z : this.frontYaw.floatValue(), currentPos.frontYaw));
        this.rearYaw = Float.valueOf(this.skewScalar(this.rearYaw == null ? this.field_70177_z : this.rearYaw.floatValue(), currentPos.rearYaw));
        this.currentSpeed = currentPos.speed;
        this.distanceTraveled = this.skewScalar(this.distanceTraveled, this.distanceTraveled + (float)this.currentSpeed.minecraft());
        this.field_70159_w = this.field_70165_t - this.field_70169_q;
        this.field_70181_x = this.field_70163_u - this.field_70167_r;
        this.field_70179_y = this.field_70161_v - this.field_70166_s;
        if (Math.abs(this.field_70159_w) + Math.abs(this.field_70181_x) + Math.abs(this.field_70179_y) > 0.001) {
            this.clearPositionCache();
        }
        List entitiesWithin = this.field_70170_p.func_72872_a(Entity.class, this.func_70046_E());
        for (Entity entity : entitiesWithin) {
            if (entity instanceof EntityMoveableRollingStock || entity.func_184187_bx() instanceof EntityMoveableRollingStock || !(entity instanceof EntityLivingBase) || !this.func_70046_E().func_72326_a(entity.func_174813_aQ())) continue;
            entity.field_70159_w = this.field_70159_w * 2.0;
            entity.field_70181_x = 0.0;
            entity.field_70179_y = this.field_70179_y * 2.0;
            entity.func_70071_h_();
            double speedDamage = this.getCurrentSpeed().metric() / Config.entitySpeedDamage;
            if (!(speedDamage > 1.0)) continue;
            entity.func_70097_a(new DamageSource("immersiverailroading:hitByTrain").func_76348_h(), (float)speedDamage);
        }
        AxisAlignedBB bb = this.func_70046_E();
        bb = bb.func_72317_d(0.0, this.getDefinition().getHeight(this.gauge) + 1.0, 0.0);
        List entitiesAbove = this.field_70170_p.func_72872_a(Entity.class, bb);
        for (Entity entity : entitiesAbove) {
            if (entity instanceof EntityMoveableRollingStock || this.func_184196_w(entity) || !(entity instanceof EntityLivingBase) || !bb.func_72326_a(entity.func_174813_aQ())) continue;
            Vec3d pos = entity.func_174791_d();
            pos = pos.func_72441_c(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            entity.func_70107_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
        }
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa % 10 != 0 && Config.TrainsBreakBlocks && this.getCurrentSpeed().metric() > 0.5) {
            bb = this.func_70046_E();
            for (Vec3d pos : this.getDefinition().getBlocksInBounds(this.gauge)) {
                pos = VecUtil.rotateYaw(pos, this.field_70177_z);
                BlockPos bp = new BlockPos(pos = pos.func_178787_e(this.func_174791_d()));
                IBlockState state = this.field_70170_p.func_180495_p(bp);
                if (state.func_177230_c() == Blocks.field_150350_a) continue;
                if (!BlockUtil.isRail(this.field_70170_p, bp)) {
                    if (!bb.func_72318_a(pos) || BlockUtil.isRail(this.field_70170_p, bp.func_177984_a())) continue;
                    this.field_70170_p.func_175655_b(bp, true);
                    continue;
                }
                TileRailBase te = TileRailBase.get((IBlockAccess)this.field_70170_p, bp);
                if (te == null) continue;
                te.cleanSnow();
            }
        }
    }

    protected void clearPositionCache() {
        this.boundingBox = null;
    }

    public TickPos moveRollingStock(double moveDistance, int lastTickID) {
        TickPos lastPos = this.getTickPos(lastTickID);
        return new MovementSimulator(this.field_70170_p, lastPos, this.getDefinition().getBogeyFront(this.gauge), this.getDefinition().getBogeyRear(this.gauge), this.gauge.value()).nextPosition(moveDistance);
    }

    public float getFrontYaw() {
        if (this.frontYaw != null) {
            return this.frontYaw.floatValue();
        }
        return this.field_70177_z;
    }

    public float getRearYaw() {
        if (this.rearYaw != null) {
            return this.rearYaw.floatValue();
        }
        return this.field_70177_z;
    }

    protected TickPos getCurrentTickPosOrFake() {
        return new TickPos(0, Speed.fromMetric(0.0), this.func_174791_d(), this.getFrontYaw(), this.getRearYaw(), this.field_70177_z, this.field_70125_A, false);
    }

    public PosRot predictFrontBogeyPosition(float offset) {
        return this.predictFrontBogeyPosition(this.getCurrentTickPosOrFake(), offset);
    }

    public PosRot predictFrontBogeyPosition(TickPos pos, float offset) {
        Vec3d front;
        MovementSimulator sim = new MovementSimulator(this.field_70170_p, pos, this.getDefinition().getBogeyFront(this.gauge), this.getDefinition().getBogeyRear(this.gauge), this.gauge.value());
        Vec3d nextFront = front = sim.frontBogeyPosition();
        while (offset > 0.0f) {
            nextFront = sim.nextPosition(nextFront, pos.rotationYaw, pos.frontYaw, Math.min(0.1, (double)offset));
            offset = (float)((double)offset - 0.1);
        }
        Vec3d frontDelta = front.func_72444_a(nextFront);
        return new PosRot(nextFront.func_72444_a(pos.position), VecUtil.toYaw(frontDelta));
    }

    public PosRot predictRearBogeyPosition(float offset) {
        return this.predictRearBogeyPosition(this.getCurrentTickPosOrFake(), offset);
    }

    public PosRot predictRearBogeyPosition(TickPos pos, float offset) {
        Vec3d rear;
        MovementSimulator sim = new MovementSimulator(this.field_70170_p, pos, this.getDefinition().getBogeyFront(this.gauge), this.getDefinition().getBogeyRear(this.gauge), this.gauge.value());
        Vec3d nextRear = rear = sim.rearBogeyPosition();
        while (offset > 0.0f) {
            nextRear = sim.nextPosition(nextRear, pos.rotationYaw + 180.0f, pos.rearYaw + 180.0f, Math.min(0.1, (double)offset));
            offset = (float)((double)offset - 0.1);
        }
        Vec3d rearDelta = rear.func_72444_a(nextRear);
        return new PosRot(nextRear.func_72444_a(pos.position), VecUtil.toYaw(rearDelta));
    }

    public int getSpeedRetarderSlowdown(TickPos latest) {
        int over = 0;
        for (Vec3d pos : this.getDefinition().getBlocksInBounds(this.gauge)) {
            TileRailBase tmp;
            TileRail parent;
            TileRailBase te;
            pos = VecUtil.rotateYaw(pos, this.field_70177_z);
            pos = pos.func_178787_e(latest.position);
            BlockPos bp = new BlockPos(pos);
            IBlockState state = this.field_70170_p.func_180495_p(bp = bp.func_177977_b());
            if (state.func_177230_c() == Blocks.field_150350_a || !BlockUtil.isIRRail(this.field_70170_p, bp) || (te = TileRailBase.get((IBlockAccess)this.field_70170_p, bp)) == null || te.getAugment() != Augment.SPEED_RETARDER || (parent = te.getParentTile()) == null) continue;
            int max = 0;
            BlockPos tmpPos = bp;
            while ((tmp = TileRailBase.get((IBlockAccess)this.field_70170_p, tmpPos = tmpPos.func_177972_a(parent.getFacing()))) != null && tmp.getAugment() == Augment.SPEED_RETARDER) {
                max = Math.max(max, RedstoneUtil.getPower(this.field_70170_p, tmpPos));
            }
            while ((tmp = TileRailBase.get((IBlockAccess)this.field_70170_p, tmpPos = tmpPos.func_177972_a(parent.getFacing().func_176734_d()))) != null && tmp.getAugment() == Augment.SPEED_RETARDER) {
                max = Math.max(max, RedstoneUtil.getPower(this.field_70170_p, tmpPos));
            }
            over += max;
        }
        return over;
    }

    public class PosRot
    extends Vec3d {
        private float rotation;

        public PosRot(double xIn, double yIn, double zIn, float rotation) {
            super(xIn, yIn, zIn);
            this.rotation = rotation;
        }

        public PosRot(Vec3d nextFront, float yaw) {
            this(nextFront.field_72450_a, nextFront.field_72448_b, nextFront.field_72449_c, yaw);
        }

        public float getRotation() {
            return this.rotation;
        }
    }
}

