/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.entity;

import cam72cam.immersiverailroading.entity.EntityBuildableRollingStock;
import cam72cam.immersiverailroading.entity.EntityCoupleableRollingStock;
import cam72cam.immersiverailroading.library.KeyTypes;
import cam72cam.immersiverailroading.net.PassengerPositionsPacket;
import cam72cam.immersiverailroading.util.BufferUtil;
import cam72cam.immersiverailroading.util.VecUtil;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public abstract class EntityRidableRollingStock
extends EntityBuildableRollingStock {
    public Map<UUID, Vec3d> passengerPositions = new HashMap<UUID, Vec3d>();
    private final double pressDist = 0.05;

    public EntityRidableRollingStock(World world, String defID) {
        super(world, defID);
    }

    @Override
    public void readSpawnData(ByteBuf additionalData) {
        this.passengerPositions = BufferUtil.readPlayerPositions(additionalData);
        super.readSpawnData(additionalData);
    }

    @Override
    public void writeSpawnData(ByteBuf buffer) {
        BufferUtil.writePlayerPositions(buffer, this.passengerPositions);
        super.writeSpawnData(buffer);
    }

    @Override
    protected void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        if (this.passengerPositions.size() > 0) {
            NBTTagCompound offsetTag = nbttagcompound.func_74775_l("passengerOffsets");
            ArrayList<String> passengers = new ArrayList<String>();
            for (UUID passenger : this.passengerPositions.keySet()) {
                passengers.add(passenger.toString());
                offsetTag.func_74780_a(passenger.toString() + ".x", this.passengerPositions.get((Object)passenger).field_72450_a);
                offsetTag.func_74780_a(passenger.toString() + ".y", this.passengerPositions.get((Object)passenger).field_72448_b);
                offsetTag.func_74780_a(passenger.toString() + ".z", this.passengerPositions.get((Object)passenger).field_72449_c);
            }
            offsetTag.func_74778_a("passengers", String.join((CharSequence)"|", passengers));
            nbttagcompound.func_74782_a("passengerOffsets", (NBTBase)offsetTag);
        }
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        if (nbttagcompound.func_74764_b("passengerOffsets")) {
            NBTTagCompound offsetTag = nbttagcompound.func_74775_l("passengerOffsets");
            for (String passenger : offsetTag.func_74779_i("passengers").split("\\|")) {
                Vec3d pos = new Vec3d(offsetTag.func_74769_h(passenger + ".x"), offsetTag.func_74769_h(passenger + ".y"), offsetTag.func_74769_h(passenger + ".z"));
                this.passengerPositions.put(UUID.fromString(passenger), pos);
            }
        }
    }

    @Override
    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (super.func_184230_a(player, hand)) {
            return true;
        }
        if (player.func_70093_af()) {
            return false;
        }
        if (player.func_184218_aH() && player.func_184187_bx().getPersistentID() == this.getPersistentID()) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K) {
            this.passengerPositions.put(player.getPersistentID(), new Vec3d(0.0, 0.0, 0.0));
            player.func_184220_m((Entity)this);
        }
        return true;
    }

    protected boolean func_184219_q(Entity passenger) {
        return this.func_184188_bt().size() < this.getDefinition().getMaxPassengers();
    }

    public boolean canRiderInteract() {
        return false;
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public void handleKeyPress(Entity source, KeyTypes key) {
        Vec3d movement = null;
        switch (key) {
            case PLAYER_FORWARD: {
                movement = new Vec3d(0.05, 0.0, 0.0);
                break;
            }
            case PLAYER_BACKWARD: {
                movement = new Vec3d(-0.05, 0.0, 0.0);
                break;
            }
            case PLAYER_LEFT: {
                movement = new Vec3d(0.0, 0.0, -0.05);
                break;
            }
            case PLAYER_RIGHT: {
                movement = new Vec3d(0.0, 0.0, 0.05);
                break;
            }
            default: {
                return;
            }
        }
        if (source.func_184187_bx() == this) {
            movement = VecUtil.rotateYaw(movement, source.func_70079_am());
            movement = VecUtil.rotateYaw(movement, 180.0f - this.field_70177_z);
            Vec3d pos = this.passengerPositions.get(source.getPersistentID()).func_178787_e(movement);
            if (this instanceof EntityCoupleableRollingStock) {
                if (this.getDefinition().isAtFront(this.gauge, pos) && ((EntityCoupleableRollingStock)this).isCoupled(EntityCoupleableRollingStock.CouplerType.FRONT)) {
                    source.func_184220_m((Entity)((EntityCoupleableRollingStock)this).getCoupled(EntityCoupleableRollingStock.CouplerType.FRONT));
                    return;
                }
                if (this.getDefinition().isAtRear(this.gauge, pos) && ((EntityCoupleableRollingStock)this).isCoupled(EntityCoupleableRollingStock.CouplerType.BACK)) {
                    source.func_184220_m((Entity)((EntityCoupleableRollingStock)this).getCoupled(EntityCoupleableRollingStock.CouplerType.BACK));
                    return;
                }
            }
            pos = this.getDefinition().correctPassengerBounds(this.gauge, pos);
            this.passengerPositions.put(source.getPersistentID(), pos);
            this.sendToObserving(new PassengerPositionsPacket(this));
        }
    }

    protected void func_184200_o(Entity passenger) {
        super.func_184200_o(passenger);
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            if (!this.passengerPositions.containsKey(passenger.getPersistentID())) {
                this.passengerPositions.put(passenger.getPersistentID(), new Vec3d(0.0, 0.0, 0.0));
            }
            Vec3d pos = this.getDefinition().getPassengerCenter(this.gauge);
            pos = pos.func_178787_e(this.passengerPositions.get(passenger.getPersistentID()));
            pos = VecUtil.rotateYaw(pos, this.field_70177_z);
            pos = pos.func_178787_e(this.func_174791_d());
            passenger.func_70107_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
            passenger.field_70177_z += this.field_70177_z - this.field_70126_B;
        }
    }

    public void func_184225_p(Entity passenger) {
        super.func_184225_p(passenger);
        Vec3d delta = VecUtil.fromYaw(this.getDefinition().getPassengerCompartmentWidth(this.gauge) / 2.0 + 1.3, this.field_70177_z - 90.0f);
        passenger.func_70634_a(passenger.field_70165_t += delta.field_72450_a, passenger.field_70163_u, passenger.field_70161_v += delta.field_72449_c);
    }
}

