/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.entity;

import cam72cam.immersiverailroading.Config;
import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.entity.EntityCoupleableRollingStock;
import cam72cam.immersiverailroading.library.GuiTypes;
import cam72cam.immersiverailroading.util.VecUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public abstract class Freight
extends EntityCoupleableRollingStock {
    protected ItemStackHandler cargoItems = new ItemStackHandler(0){

        protected void onContentsChanged(int slot) {
            Freight.this.onInventoryChanged();
        }
    };
    protected static DataParameter<Integer> CARGO_ITEMS = EntityDataManager.func_187226_a(Freight.class, (DataSerializer)DataSerializers.field_187192_b);

    public Freight(World world, String defID) {
        super(world, defID);
        this.func_184212_Q().func_187214_a(CARGO_ITEMS, (Object)0);
    }

    protected void onInventoryChanged() {
        if (!this.field_70170_p.field_72995_K) {
            this.handleMass();
        }
    }

    public abstract int getInventorySize();

    @Override
    public void onAssemble() {
        super.onAssemble();
        this.cargoItems.setSize(this.getInventorySize());
    }

    @Override
    public void onDissassemble() {
        super.onDissassemble();
        if (!this.field_70170_p.field_72995_K) {
            for (int slot = 0; slot < this.cargoItems.getSlots(); ++slot) {
                ItemStack itemstack = this.cargoItems.getStackInSlot(slot);
                if (itemstack.func_190916_E() == 0) continue;
                Vec3d pos = this.func_174791_d().func_178787_e(VecUtil.fromYaw(4.0, this.field_70177_z + 90.0f));
                this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, itemstack.func_77946_l()));
                itemstack.func_190920_e(0);
            }
        }
        this.cargoItems.setSize(0);
    }

    @Override
    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (super.func_184230_a(player, hand)) {
            return true;
        }
        if (!this.isBuilt()) {
            return false;
        }
        player.openGui((Object)ImmersiveRailroading.instance, this.guiType().ordinal(), this.field_70170_p, this.func_145782_y(), 0, 0);
        return true;
    }

    protected GuiTypes guiType() {
        return GuiTypes.FREIGHT;
    }

    protected void handleMass() {
        int itemInsideCount = 0;
        for (int slot = 0; slot < this.cargoItems.getSlots(); ++slot) {
            itemInsideCount += this.cargoItems.getStackInSlot(slot).func_190916_E();
        }
        this.func_184212_Q().func_187227_b(CARGO_ITEMS, (Object)itemInsideCount);
    }

    @Override
    protected void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74782_a("items", (NBTBase)this.cargoItems.serializeNBT());
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        ItemStackHandler temp = new ItemStackHandler();
        temp.deserializeNBT((NBTTagCompound)nbttagcompound.func_74781_a("items"));
        this.cargoItems.setSize(this.getInventorySize());
        for (int slot = 0; slot < temp.getSlots(); ++slot) {
            if (slot < this.cargoItems.getSlots()) {
                this.cargoItems.setStackInSlot(slot, temp.getStackInSlot(slot));
                continue;
            }
            this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, temp.getStackInSlot(slot)));
        }
        this.handleMass();
    }

    @Override
    public void func_70106_y() {
        super.func_70106_y();
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        for (int slot = 0; slot < this.cargoItems.getSlots(); ++slot) {
            ItemStack itemstack = this.cargoItems.getStackInSlot(slot);
            if (itemstack.func_190916_E() == 0) continue;
            this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, itemstack.func_77946_l()));
            itemstack.func_190920_e(0);
        }
    }

    @Override
    public double getWeight() {
        double fLoad = Config.blockWeight * (Integer)this.func_184212_Q().func_187225_a(CARGO_ITEMS);
        return fLoad += super.getWeight();
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.cargoItems;
        }
        return (T)super.getCapability(capability, facing);
    }
}

