/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.entity;

import cam72cam.immersiverailroading.Config;
import cam72cam.immersiverailroading.entity.Freight;
import cam72cam.immersiverailroading.gui.ISyncableSlots;
import cam72cam.immersiverailroading.library.GuiTypes;
import cam72cam.immersiverailroading.util.FluidQuantity;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.ArrayUtils;

public abstract class FreightTank
extends Freight {
    private static final DataParameter<Integer> FLUID_AMOUNT = EntityDataManager.func_187226_a(FreightTank.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<String> FLUID_TYPE = EntityDataManager.func_187226_a(FreightTank.class, (DataSerializer)DataSerializers.field_187194_d);
    protected final FluidTank theTank = new FluidTank(null, 0){

        public boolean canFillFluidType(FluidStack fluid) {
            return this.canFill() && (FreightTank.this.getFluidFilter() == null || FreightTank.this.getFluidFilter().contains(fluid.getFluid()));
        }

        public void onContentsChanged() {
            if (!FreightTank.this.field_70170_p.field_72995_K) {
                FreightTank.this.onTankContentsChanged();
            }
        }
    };
    private List<ISyncableSlots> listners = new ArrayList<ISyncableSlots>();

    public FreightTank(World world, String defID) {
        super(world, defID);
        this.field_70180_af.func_187214_a(FLUID_AMOUNT, (Object)0);
        this.field_70180_af.func_187214_a(FLUID_TYPE, (Object)"EMPTY");
    }

    public abstract FluidQuantity getTankCapacity();

    @Nullable
    public abstract List<Fluid> getFluidFilter();

    protected int[] getContainerInputSlots() {
        return new int[]{0};
    }

    protected int[] getContainertOutputSlots() {
        int[] result = new int[this.getInventorySize()];
        for (int i = 0; i < this.getInventorySize(); ++i) {
            result[i] = i;
        }
        for (int i : this.getContainerInputSlots()) {
            result = ArrayUtils.removeElement((int[])result, (int)i);
        }
        return result;
    }

    @Override
    public int getInventorySize() {
        return 2;
    }

    public int getLiquidAmount() {
        return (Integer)this.field_70180_af.func_187225_a(FLUID_AMOUNT);
    }

    public Fluid getLiquid() {
        String type = (String)this.field_70180_af.func_187225_a(FLUID_TYPE);
        if (type.equals("EMPTY")) {
            return null;
        }
        return FluidRegistry.getFluid((String)type);
    }

    @Override
    public void onAssemble() {
        super.onAssemble();
        this.theTank.setCapacity(this.getTankCapacity().MilliBuckets());
        this.onTankContentsChanged();
    }

    @Override
    public void onDissassemble() {
        super.onDissassemble();
        this.theTank.drain(this.theTank.getFluidAmount(), true);
        this.theTank.setCapacity(0);
        this.onTankContentsChanged();
    }

    protected void onTankContentsChanged() {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        this.field_70180_af.func_187227_b(FLUID_AMOUNT, (Object)this.theTank.getFluidAmount());
        if (this.theTank.getFluid() == null) {
            this.field_70180_af.func_187227_b(FLUID_TYPE, (Object)"EMPTY");
        } else {
            this.field_70180_af.func_187227_b(FLUID_TYPE, (Object)FluidRegistry.getFluidName((FluidStack)this.theTank.getFluid()));
        }
    }

    public int getServerLiquidAmount() {
        return this.theTank.getFluidAmount();
    }

    @Override
    public GuiTypes guiType() {
        return GuiTypes.TANK;
    }

    @Override
    protected void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74782_a("tank", (NBTBase)this.theTank.writeToNBT(new NBTTagCompound()));
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.theTank.readFromNBT(nbttagcompound.func_74775_l("tank"));
        this.onTankContentsChanged();
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        this.checkInvent();
    }

    protected void checkInvent() {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (!this.isBuilt()) {
            return;
        }
        if (this.cargoItems.getSlots() == 0) {
            return;
        }
        for (int inputSlot : this.getContainerInputSlots()) {
            ItemStack inputCopy;
            IFluidHandlerItem containerFluidHandler;
            ItemStack input = this.cargoItems.getStackInSlot(inputSlot);
            if (input == null || (containerFluidHandler = FluidUtil.getFluidHandler((ItemStack)(inputCopy = ItemHandlerHelper.copyStackWithSize((ItemStack)input, (int)1)))) == null || input.func_190916_E() <= 0) continue;
            block1: for (Boolean doFill : new Boolean[]{false, true}) {
                FluidActionResult inputAttempt = doFill != false ? FluidUtil.tryFillContainer((ItemStack)inputCopy, (IFluidHandler)this.theTank, (int)Integer.MAX_VALUE, null, (boolean)false) : FluidUtil.tryEmptyContainer((ItemStack)inputCopy, (IFluidHandler)this.theTank, (int)Integer.MAX_VALUE, null, (boolean)false);
                if (!inputAttempt.isSuccess()) continue;
                ItemStack out = inputAttempt.getResult();
                int[] nArray = this.getContainertOutputSlots();
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    Integer slot = nArray[i];
                    if (this.cargoItems.insertItem(slot.intValue(), out, true).func_190916_E() != 0) continue;
                    if (doFill.booleanValue()) {
                        FluidUtil.tryFillContainer((ItemStack)inputCopy, (IFluidHandler)this.theTank, (int)Integer.MAX_VALUE, null, (boolean)true);
                    } else {
                        FluidUtil.tryEmptyContainer((ItemStack)inputCopy, (IFluidHandler)this.theTank, (int)Integer.MAX_VALUE, null, (boolean)true);
                    }
                    if (Config.debugInfiniteLiquids) continue;
                    this.cargoItems.extractItem(inputSlot, 1, false);
                    this.cargoItems.insertItem(slot.intValue(), out, false);
                    continue block1;
                }
            }
        }
    }

    @Override
    public double getWeight() {
        double fLoad = super.getWeight();
        if (this.getLiquidAmount() > 0) {
            fLoad += (double)(this.getLiquidAmount() * this.getLiquid().getDensity() / 1000);
        }
        return fLoad;
    }

    @Override
    protected void onInventoryChanged() {
        super.onInventoryChanged();
        if (!this.field_70170_p.field_72995_K) {
            for (ISyncableSlots container : this.listners) {
                container.syncSlots();
            }
        }
    }

    public void addListener(ISyncableSlots tankContainer) {
        this.listners.add(tankContainer);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.theTank;
        }
        return super.getCapability(capability, facing);
    }
}

