/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.entity;

import cam72cam.immersiverailroading.entity.FreightTank;
import cam72cam.immersiverailroading.library.GuiTypes;
import cam72cam.immersiverailroading.library.KeyTypes;
import cam72cam.immersiverailroading.registry.LocomotiveDefinition;
import cam72cam.immersiverailroading.util.Speed;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.world.World;

public abstract class Locomotive
extends FreightTank {
    private static DataParameter<Float> THROTTLE = EntityDataManager.func_187226_a(Locomotive.class, (DataSerializer)DataSerializers.field_187193_c);
    private static DataParameter<Float> AIR_BRAKE = EntityDataManager.func_187226_a(Locomotive.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final float throttleNotch = 0.04f;
    private static final float airBrakeNotch = 0.04f;

    public Locomotive(World world, String defID) {
        super(world, defID);
        this.func_184212_Q().func_187214_a(THROTTLE, (Object)Float.valueOf(0.0f));
        this.func_184212_Q().func_187214_a(AIR_BRAKE, (Object)Float.valueOf(0.0f));
        this.field_70144_Y = 0.99f;
    }

    @Override
    public LocomotiveDefinition getDefinition() {
        return super.getDefinition(LocomotiveDefinition.class);
    }

    @Override
    public GuiTypes guiType() {
        return null;
    }

    @Override
    protected void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74776_a("throttle", this.getThrottle());
        nbttagcompound.func_74776_a("brake", this.getAirBrake());
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.setThrottle(nbttagcompound.func_74760_g("throttle"));
        this.setAirBrake(nbttagcompound.func_74760_g("brake"));
    }

    @Override
    public void func_70106_y() {
        super.func_70106_y();
    }

    @Override
    public void handleKeyPress(Entity source, KeyTypes key) {
        switch (key) {
            case THROTTLE_UP: {
                if (!(this.getThrottle() < 1.0f)) break;
                this.setThrottle(this.getThrottle() + 0.04f);
                break;
            }
            case THROTTLE_ZERO: {
                this.setThrottle(0.0f);
                break;
            }
            case THROTTLE_DOWN: {
                if (!(this.getThrottle() > -1.0f)) break;
                this.setThrottle(this.getThrottle() - 0.04f);
                break;
            }
            case AIR_BRAKE_UP: {
                if (!(this.getAirBrake() < 1.0f)) break;
                this.setAirBrake(this.getAirBrake() + 0.04f);
                break;
            }
            case AIR_BRAKE_ZERO: {
                this.setAirBrake(0.0f);
                break;
            }
            case AIR_BRAKE_DOWN: {
                if (!(this.getAirBrake() > 0.0f)) break;
                this.setAirBrake(this.getAirBrake() - 0.04f);
                break;
            }
            default: {
                super.handleKeyPress(source, key);
            }
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        this.simulateWheelSlip();
    }

    protected abstract int getAvailableHP();

    private double getAppliedTractiveEffort(Speed speed) {
        double locoEfficiency = 0.7f;
        double outputHorsepower = Math.abs(this.getThrottle() * (float)this.getAvailableHP());
        double tractiveEffortNewtons = 2650.0 * (locoEfficiency * outputHorsepower / Math.max(1.0E-4, Math.abs(speed.metric())));
        return tractiveEffortNewtons;
    }

    private void simulateWheelSlip() {
        double actual;
        double applied = this.getAppliedTractiveEffort(this.getCurrentSpeed());
        if (applied > (actual = (double)this.getDefinition().getStartingTractionNewtons(this.gauge))) {
            double speedMultiplier = 1.0;
            this.distanceTraveled = (float)((double)this.distanceTraveled + Math.copySign(Math.min((applied / actual - 1.0) / 100.0, 0.8), (double)this.getThrottle()) * speedMultiplier);
        }
    }

    public double getTractiveEffortNewtons(Speed speed) {
        if (!this.isBuilt()) {
            return 0.0;
        }
        double tractiveEffortNewtons = this.getAppliedTractiveEffort(speed);
        if (tractiveEffortNewtons > (double)this.getDefinition().getStartingTractionNewtons(this.gauge)) {
            double us = 0.74;
            double uk = 0.57;
            tractiveEffortNewtons = (double)this.getDefinition().getStartingTractionNewtons(this.gauge) * (uk / us);
        }
        if (Math.abs(speed.minecraft()) > this.getDefinition().getMaxSpeed(this.gauge).minecraft()) {
            tractiveEffortNewtons = 0.0;
        }
        return Math.copySign(tractiveEffortNewtons, (double)this.getThrottle());
    }

    public void soundHorn() {
    }

    public float getThrottle() {
        return ((Float)this.field_70180_af.func_187225_a(THROTTLE)).floatValue();
    }

    public void setThrottle(float newThrottle) {
        if (this.getThrottle() != newThrottle) {
            this.field_70180_af.func_187227_b(THROTTLE, (Object)Float.valueOf(newThrottle));
            this.triggerResimulate();
        }
    }

    public float getAirBrake() {
        return ((Float)this.field_70180_af.func_187225_a(AIR_BRAKE)).floatValue();
    }

    public void setAirBrake(float newAirBrake) {
        if (this.getAirBrake() != newAirBrake) {
            this.field_70180_af.func_187227_b(AIR_BRAKE, (Object)Float.valueOf(newAirBrake));
            this.triggerResimulate();
        }
    }
}

