/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.entity;

import blusunrize.immersiveengineering.api.energy.DieselHandler;
import cam72cam.immersiverailroading.Config;
import cam72cam.immersiverailroading.entity.EntityRollingStock;
import cam72cam.immersiverailroading.entity.Locomotive;
import cam72cam.immersiverailroading.library.Gauge;
import cam72cam.immersiverailroading.library.GuiTypes;
import cam72cam.immersiverailroading.library.KeyTypes;
import cam72cam.immersiverailroading.registry.LocomotiveDieselDefinition;
import cam72cam.immersiverailroading.util.FluidQuantity;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class LocomotiveDiesel
extends Locomotive {
    public LocomotiveDiesel(World world) {
        this(world, null);
    }

    public LocomotiveDiesel(World world, String defID) {
        super(world, defID);
    }

    @Override
    public LocomotiveDieselDefinition getDefinition() {
        return super.getDefinition(LocomotiveDieselDefinition.class);
    }

    @Override
    public GuiTypes guiType() {
        return GuiTypes.DIESEL_LOCOMOTIVE;
    }

    @Override
    public void handleKeyPress(Entity source, KeyTypes key) {
        super.handleKeyPress(source, key);
        this.mapTrain(this, true, false, this::setThrottleMap);
    }

    private void setThrottleMap(EntityRollingStock stock, boolean direction) {
        if (stock instanceof LocomotiveDiesel) {
            ((LocomotiveDiesel)stock).setThrottle(this.getThrottle() * (float)(direction ? 1 : -1));
            ((LocomotiveDiesel)stock).setAirBrake(this.getAirBrake());
        }
    }

    @Override
    protected int getAvailableHP() {
        if (!Config.ModelFuelRequired && this.gauge == Gauge.MODEL) {
            return this.getDefinition().getHorsePower(this.gauge);
        }
        return this.getLiquidAmount() > 0 ? this.getDefinition().getHorsePower(this.gauge) : 0;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.getLiquidAmount() > 0 && this.getThrottle() != 0.0f) {
            int burnTime = DieselHandler.getBurnTime((Fluid)this.getLiquid());
            if (burnTime == 0) {
                burnTime = 200;
            }
            burnTime = (int)((float)burnTime * ((float)this.getDefinition().getFuelEfficiency() / 100.0f));
            burnTime = (int)((float)burnTime / (Math.abs(this.getThrottle()) * 10.0f));
            if (this.field_70173_aa % (burnTime = (int)((double)burnTime * (1.0 / this.gauge.scale()))) == 0) {
                this.theTank.drain(1, true);
            }
        }
    }

    @Override
    public List<Fluid> getFluidFilter() {
        ArrayList<Fluid> filter = new ArrayList<Fluid>();
        filter.add(FluidRegistry.getFluid((String)"oil"));
        filter.add(FluidRegistry.getFluid((String)"fuel"));
        filter.add(FluidRegistry.getFluid((String)"diesel"));
        filter.add(FluidRegistry.getFluid((String)"ethanol"));
        filter.add(FluidRegistry.getFluid((String)"biofuel"));
        filter.add(FluidRegistry.getFluid((String)"biodiesel"));
        return filter;
    }

    @Override
    public FluidQuantity getTankCapacity() {
        return this.getDefinition().getFuelCapacity(this.gauge);
    }
}

