/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.entity;

import cam72cam.immersiverailroading.Config;
import cam72cam.immersiverailroading.entity.EntityCoupleableRollingStock;
import cam72cam.immersiverailroading.entity.Locomotive;
import cam72cam.immersiverailroading.entity.Tender;
import cam72cam.immersiverailroading.library.Gauge;
import cam72cam.immersiverailroading.library.GuiTypes;
import cam72cam.immersiverailroading.registry.LocomotiveSteamDefinition;
import cam72cam.immersiverailroading.util.BurnUtil;
import cam72cam.immersiverailroading.util.FluidQuantity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class LocomotiveSteam
extends Locomotive {
    private static DataParameter<Float> BOILER_PRESSURE = EntityDataManager.func_187226_a(LocomotiveSteam.class, (DataSerializer)DataSerializers.field_187193_c);
    private static DataParameter<Float> BOILER_TEMPERATURE = EntityDataManager.func_187226_a(LocomotiveSteam.class, (DataSerializer)DataSerializers.field_187193_c);
    private static DataParameter<NBTTagCompound> BURN_TIME = EntityDataManager.func_187226_a(LocomotiveSteam.class, (DataSerializer)DataSerializers.field_192734_n);
    private static DataParameter<NBTTagCompound> BURN_MAX = EntityDataManager.func_187226_a(LocomotiveSteam.class, (DataSerializer)DataSerializers.field_192734_n);

    public LocomotiveSteam(World world) {
        this(world, null);
    }

    public LocomotiveSteam(World world, String defID) {
        super(world, defID);
        this.func_184212_Q().func_187214_a(BOILER_PRESSURE, (Object)Float.valueOf(0.0f));
        this.func_184212_Q().func_187214_a(BOILER_TEMPERATURE, (Object)Float.valueOf(0.0f));
        this.func_184212_Q().func_187214_a(BURN_TIME, (Object)new NBTTagCompound());
        this.func_184212_Q().func_187214_a(BURN_MAX, (Object)new NBTTagCompound());
    }

    @Override
    public LocomotiveSteamDefinition getDefinition() {
        return super.getDefinition(LocomotiveSteamDefinition.class);
    }

    @Override
    public GuiTypes guiType() {
        return GuiTypes.STEAM_LOCOMOTIVE;
    }

    @Override
    protected void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74776_a("boiler_temperature", this.getBoilerTemperature());
        nbttagcompound.func_74776_a("boiler_psi", this.getBoilerPressure());
        nbttagcompound.func_74782_a("burn_time", (NBTBase)this.field_70180_af.func_187225_a(BURN_TIME));
        nbttagcompound.func_74782_a("burn_max", (NBTBase)this.field_70180_af.func_187225_a(BURN_MAX));
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.setBoilerTemperature(nbttagcompound.func_74760_g("boiler_temperature"));
        this.setBoilerPressure(nbttagcompound.func_74760_g("boiler_psi"));
        this.field_70180_af.func_187227_b(BURN_TIME, (Object)((NBTTagCompound)nbttagcompound.func_74781_a("burn_time")));
        this.field_70180_af.func_187227_b(BURN_MAX, (Object)((NBTTagCompound)nbttagcompound.func_74781_a("burn_max")));
    }

    public float getBoilerTemperature() {
        return ((Float)this.field_70180_af.func_187225_a(BOILER_TEMPERATURE)).floatValue();
    }

    private void setBoilerTemperature(float temp) {
        this.field_70180_af.func_187227_b(BOILER_TEMPERATURE, (Object)Float.valueOf(temp));
    }

    public float getBoilerPressure() {
        return ((Float)this.field_70180_af.func_187225_a(BOILER_PRESSURE)).floatValue();
    }

    private void setBoilerPressure(float temp) {
        this.field_70180_af.func_187227_b(BOILER_PRESSURE, (Object)Float.valueOf(temp));
    }

    private NBTTagCompound mapToNBT(Map<Integer, Integer> map) {
        NBTTagCompound data = new NBTTagCompound();
        for (Integer slot : map.keySet()) {
            data.func_74768_a("" + slot, map.get(slot).intValue());
        }
        return data;
    }

    private Map<Integer, Integer> NBTtoMap(NBTTagCompound nbt) {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        for (String key : nbt.func_150296_c()) {
            map.put(Integer.parseInt(key), nbt.func_74762_e(key));
        }
        return map;
    }

    public Map<Integer, Integer> getBurnTime() {
        return this.NBTtoMap((NBTTagCompound)this.field_70180_af.func_187225_a(BURN_TIME));
    }

    private void setBurnTime(Map<Integer, Integer> burnTime) {
        this.field_70180_af.func_187227_b(BURN_TIME, (Object)this.mapToNBT(burnTime));
    }

    public Map<Integer, Integer> getBurnMax() {
        return this.NBTtoMap((NBTTagCompound)this.field_70180_af.func_187225_a(BURN_MAX));
    }

    private void setBurnMax(Map<Integer, Integer> burnMax) {
        this.field_70180_af.func_187227_b(BURN_MAX, (Object)this.mapToNBT(burnMax));
    }

    @Override
    protected int getAvailableHP() {
        if (!Config.ModelFuelRequired && this.gauge == Gauge.MODEL) {
            return this.getDefinition().getHorsePower(this.gauge);
        }
        return (int)((double)this.getDefinition().getHorsePower(this.gauge) * Math.pow(this.getBoilerPressure() / (float)this.getDefinition().getMaxPSI(this.gauge), 3.0));
    }

    @Override
    public void onDissassemble() {
        super.onDissassemble();
        this.setBoilerTemperature(0.0f);
        this.setBoilerPressure(0.0f);
        Map<Integer, Integer> burnTime = this.getBurnTime();
        for (Integer slot : burnTime.keySet()) {
            burnTime.put(slot, 0);
        }
        this.setBurnTime(burnTime);
    }

    @Override
    public void func_70071_h_() {
        float throttle;
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (!this.isBuilt()) {
            return;
        }
        if (this.getCoupled(EntityCoupleableRollingStock.CouplerType.BACK) instanceof Tender) {
            Tender tender = (Tender)this.getCoupled(EntityCoupleableRollingStock.CouplerType.BACK);
            int desiredDrain = 10;
            if (this.getTankCapacity().MilliBuckets() - this.getServerLiquidAmount() >= 10) {
                FluidUtil.tryFluidTransfer((IFluidHandler)this.theTank, (IFluidHandler)tender.theTank, (int)desiredDrain, (boolean)true);
            }
            if (this.field_70173_aa % 20 == 0) {
                for (int slot = 0; slot < this.cargoItems.getSlots() - 2; ++slot) {
                    if (BurnUtil.getBurnTime(this.cargoItems.getStackInSlot(slot)) == 0) continue;
                    for (int tenderSlot = 0; tenderSlot < tender.cargoItems.getSlots(); ++tenderSlot) {
                        if (!this.cargoItems.getStackInSlot(slot).func_77969_a(tender.cargoItems.getStackInSlot(tenderSlot)) || this.cargoItems.getStackInSlot(slot).func_77976_d() <= this.cargoItems.getStackInSlot(slot).func_190916_E()) continue;
                        ItemStack extracted = tender.cargoItems.extractItem(tenderSlot, 1, false);
                        this.cargoItems.insertItem(slot, extracted, false);
                    }
                }
            }
        }
        if (this.getBoilerTemperature() >= 100.0f && this.getTankCapacity().MilliBuckets() > 0 && this.field_70146_Z.nextInt(100) == 0) {
            int outputHorsepower = (int)Math.abs(this.getThrottle() * (float)this.getAvailableHP());
            this.theTank.drain(outputHorsepower * 10 / this.getDefinition().getHorsePower(this.gauge), true);
        }
        Map<Integer, Integer> burnTime = this.getBurnTime();
        Map<Integer, Integer> burnMax = this.getBurnMax();
        Boolean changedBurnTime = false;
        Boolean changedBurnMax = false;
        float waterLevelMB = this.getLiquidAmount();
        float boilerTemperature = this.getBoilerTemperature();
        float boilerPressure = this.getBoilerPressure();
        for (int slot = 0; slot < this.cargoItems.getSlots() - 2; ++slot) {
            int time;
            if (waterLevelMB == 0.0f) continue;
            int n = time = burnTime.containsKey(slot) ? burnTime.get(slot) : 0;
            if (time <= 0) {
                ItemStack stack = this.cargoItems.getStackInSlot(slot);
                if (stack.func_190916_E() <= 0 || !TileEntityFurnace.func_145954_b((ItemStack)stack)) continue;
                time = (int)((double)(BurnUtil.getBurnTime(stack) * 1) / this.gauge.scale());
                burnTime.put(slot, time);
                burnMax.put(slot, time);
                stack.func_190920_e(stack.func_190916_E() - 1);
                this.cargoItems.setStackInSlot(slot, stack);
                changedBurnMax = true;
            } else {
                burnTime.put(slot, time - 1);
            }
            changedBurnTime = true;
            if (boilerTemperature < 100.0f || (double)waterLevelMB < (double)this.getTankCapacity().MilliBuckets() * 0.75) {
                boilerTemperature = (float)((double)boilerTemperature + (double)(100.0f / waterLevelMB) * Math.sqrt(this.gauge.scale()));
            }
            if (!(boilerTemperature >= 100.0f)) continue;
            boilerPressure = (float)((double)boilerPressure + (double)(100.0f / waterLevelMB) * Math.sqrt(this.gauge.scale()));
            if (this.field_70146_Z.nextInt(10) != 0) continue;
            waterLevelMB -= 1.0f;
        }
        if (!changedBurnTime.booleanValue()) {
            if (boilerPressure <= 0.0f || boilerTemperature > 100.0f) {
                boilerTemperature = (float)Math.max(0.0, (double)boilerTemperature - 0.05);
            } else {
                boilerPressure = (float)Math.max(0.0, (double)boilerPressure - 0.05);
            }
        }
        if (boilerTemperature > 100.0f && this.gauge == Gauge.MODEL) {
            boilerTemperature = 100.0f;
        }
        if ((throttle = Math.abs(this.getThrottle())) != 0.0f && boilerPressure > 0.0f) {
            boilerPressure = Math.max(0.0f, boilerPressure - throttle * (float)(this.cargoItems.getSlots() - 2) * 100.0f / waterLevelMB);
        }
        if (boilerPressure > (float)this.getDefinition().getMaxPSI(this.gauge)) {
            boilerPressure = this.getDefinition().getMaxPSI(this.gauge);
        }
        if (changedBurnTime.booleanValue()) {
            this.setBurnTime(burnTime);
            this.theTank.drain(this.getLiquidAmount() - (int)waterLevelMB, true);
        }
        if (changedBurnMax.booleanValue()) {
            this.setBurnMax(burnMax);
        }
        this.setBoilerTemperature(boilerTemperature);
        this.setBoilerPressure(boilerPressure);
        if ((double)boilerPressure > (double)this.getDefinition().getMaxPSI(this.gauge) * 1.1 || (double)boilerPressure > (double)this.getDefinition().getMaxPSI(this.gauge) * 0.5 && boilerTemperature > 150.0f) {
            if (Config.explosionsEnabled) {
                this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, boilerPressure, true);
            }
            this.field_70170_p.func_72900_e((Entity)this);
        }
    }

    @Override
    public int getInventorySize() {
        return this.getDefinition().getInventorySize(this.gauge) + 2;
    }

    public int getInventoryWidth() {
        return this.getDefinition().getInventoryWidth(this.gauge);
    }

    @Override
    protected int[] getContainerInputSlots() {
        return new int[]{this.getInventorySize() - 2};
    }

    @Override
    protected int[] getContainertOutputSlots() {
        return new int[]{this.getInventorySize() - 1};
    }

    @Override
    public FluidQuantity getTankCapacity() {
        return this.getDefinition().getTankCapacity(this.gauge);
    }

    @Override
    public List<Fluid> getFluidFilter() {
        ArrayList<Fluid> filter = new ArrayList<Fluid>();
        filter.add(FluidRegistry.WATER);
        return filter;
    }
}

