/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.gui;

import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;

public abstract class ContainerGuiBase
extends GuiContainer {
    public static final ResourceLocation CHEST_GUI_TEXTURE = new ResourceLocation("textures/gui/container/generic_54.png");
    public static final int slotSize = 18;
    public static final int topOffset = 17;
    public static final int bottomOffset = 7;
    public static final int textureHeight = 222;
    public static final int paddingRight = 7;
    public static final int paddingLeft = 7;
    public static final int stdUiHorizSlots = 9;
    public static final int playerXSize = 176;
    private static final int midBarOffset = 4;
    private static final int midBarHeight = 4;

    public ContainerGuiBase(Container inventorySlotsIn) {
        super(inventorySlotsIn);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    public int drawTopBar(int x, int y, int slots) {
        this.func_73729_b(x, y, 0, 0, 7, 17);
        for (int k = 1; k <= slots; ++k) {
            this.func_73729_b(x + 7 + (k - 1) * 18, y, 7, 0, 18, 17);
        }
        this.func_73729_b(x + 7 + slots * 18, y, 169, 0, 7, 17);
        return y + 17;
    }

    public void drawSlot(int x, int y) {
        this.func_73729_b(x, y, 7, 17, 18, 18);
    }

    public int drawSlotRow(int x, int y, int slots) {
        this.func_73729_b(x, y, 0, 17, 7, 18);
        for (int k = 1; k <= slots; ++k) {
            this.drawSlot(x + 7 + (k - 1) * 18, y);
        }
        this.func_73729_b(x + 7 + slots * 18, y, 169, 17, 7, 18);
        return y + 18;
    }

    public int drawSlotBlock(int x, int y, int slotX, int slotY) {
        for (int i = 0; i < slotY; ++i) {
            y = this.drawSlotRow(x, y, slotX);
        }
        return y;
    }

    public int drawBottomBar(int x, int y, int slots) {
        this.func_73729_b(x, y, 0, 215, 7, 7);
        for (int k = 1; k <= slots; ++k) {
            this.func_73729_b(x + 7 + (k - 1) * 18, y, 7, 215, 18, 7);
        }
        this.func_73729_b(x + 7 + slots * 18, y, 169, 215, 7, 7);
        return y + 7;
    }

    public int drawPlayerTopBar(int x, int y) {
        this.func_73729_b(x, y, 0, 0, 176, 7);
        return y + 7;
    }

    public int drawPlayerMidBar(int x, int y) {
        this.func_73729_b(x, y, 0, 4, 176, 4);
        return y + 4;
    }

    public int drawPlayerInventory(int x, int y) {
        this.func_73729_b(x, y, 0, 130, 176, 96);
        return y + 96;
    }

    public int drawPlayerInventoryConnector(int x, int y, int aboveWidth, int horizSlots) {
        if (horizSlots > 9) {
            return this.drawBottomBar(x, y, horizSlots);
        }
        if (horizSlots < 9) {
            return this.drawPlayerTopBar((aboveWidth - 176) / 2, y);
        }
        return this.drawPlayerMidBar((aboveWidth - 176) / 2, y);
    }

    public void drawFluid(Fluid fluid, int x, int y, int width, int height, int scale) {
        TextureAtlasSprite sprite = this.field_146297_k.func_147117_R().func_110572_b(fluid.getStill().toString());
        if (sprite != null) {
            this.drawSprite(sprite, fluid.getColor(), x, y, width, height, scale);
        }
    }

    public void drawSprite(TextureAtlasSprite sprite, int col, int x, int y, int width, int height, int scale) {
        this.field_146297_k.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        GlStateManager.func_179131_c((float)((float)(col >> 16 & 0xFF) / 255.0f), (float)((float)(col >> 8 & 0xFF) / 255.0f), (float)((float)(col & 0xFF) / 255.0f), (float)1.0f);
        int iW = sprite.func_94211_a() * scale;
        int iH = sprite.func_94216_b() * scale;
        float minU = sprite.func_94209_e();
        float minV = sprite.func_94206_g();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        for (int offY = 0; offY < height; offY += iH) {
            int curHeight = Math.min(iH, height - offY);
            float maxVScaled = sprite.func_94207_b(16.0 * (double)curHeight / (double)iH);
            for (int offX = 0; offX < width; offX += iW) {
                int curWidth = Math.min(iW, width - offX);
                float maxUScaled = sprite.func_94214_a(16.0 * (double)curWidth / (double)iW);
                buffer.func_181662_b((double)(x + offX), (double)(y + offY), (double)this.field_73735_i).func_187315_a((double)minU, (double)minV).func_181675_d();
                buffer.func_181662_b((double)(x + offX), (double)(y + offY + curHeight), (double)this.field_73735_i).func_187315_a((double)minU, (double)maxVScaled).func_181675_d();
                buffer.func_181662_b((double)(x + offX + curWidth), (double)(y + offY + curHeight), (double)this.field_73735_i).func_187315_a((double)maxUScaled, (double)maxVScaled).func_181675_d();
                buffer.func_181662_b((double)(x + offX + curWidth), (double)(y + offY), (double)this.field_73735_i).func_187315_a((double)maxUScaled, (double)minV).func_181675_d();
            }
        }
        tessellator.func_78381_a();
        this.field_146297_k.func_110434_K().func_110577_a(CHEST_GUI_TEXTURE);
    }

    public void drawTankBlock(int x, int y, int horizSlots, int inventoryRows, Fluid fluid, float percentFull) {
        int width = horizSlots * 18;
        int height = inventoryRows * 18;
        Gui.func_73734_a((int)x, (int)y, (int)(x + width), (int)(y + height), (int)-16777216);
        if (percentFull > 0.0f && fluid != null) {
            int fullHeight = Math.max(1, (int)((float)height * percentFull));
            this.drawFluid(fluid, x, y + height - fullHeight, width, fullHeight, 2);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

