/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.gui;

import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.gui.ItemPickerGUI;
import cam72cam.immersiverailroading.items.ItemTrackBlueprint;
import cam72cam.immersiverailroading.items.nbt.ItemGauge;
import cam72cam.immersiverailroading.library.Gauge;
import cam72cam.immersiverailroading.library.GuiText;
import cam72cam.immersiverailroading.library.TrackItems;
import cam72cam.immersiverailroading.library.TrackPositionType;
import cam72cam.immersiverailroading.net.ItemRailUpdatePacket;
import cam72cam.immersiverailroading.tile.TileRailPreview;
import com.google.common.base.Predicate;
import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.config.GuiCheckBox;
import net.minecraftforge.fml.client.config.GuiSlider;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.oredict.OreDictionary;

public class TrackGui
extends GuiScreen {
    private GuiButton typeButton;
    private GuiTextField lengthInput;
    private GuiSlider quartersSlider;
    private GuiCheckBox isPreviewCB;
    private GuiButton gaugeButton;
    private int slot;
    private int length;
    private int quarters;
    private Gauge gauge;
    private boolean isPreview;
    private TrackItems type;
    private TrackPositionType posType;
    private GuiButton posTypeButton;
    private GuiButton bedTypeButton;
    private ItemPickerGUI bedSelector;
    private GuiButton bedFillButton;
    private ItemPickerGUI bedFillSelector;
    private final Predicate<String> integerFilter = new Predicate<String>(){

        public boolean apply(@Nullable String inputString) {
            int val;
            if (StringUtils.func_151246_b((String)inputString)) {
                return true;
            }
            try {
                val = Integer.parseInt(inputString);
            }
            catch (NumberFormatException e) {
                return false;
            }
            return val > 0 && val <= 100;
        }
    };
    private BlockPos tilePreviewPos;

    public TrackGui() {
        this.slot = Minecraft.func_71410_x().field_71439_g.field_71071_by.field_70461_c;
        ItemStack stack = Minecraft.func_71410_x().field_71439_g.func_184614_ca();
        this.init(stack);
    }

    public TrackGui(World world, int posX, int posY, int posZ) {
        this.tilePreviewPos = new BlockPos(posX, posY, posZ);
        TileRailPreview te = TileRailPreview.get((IBlockAccess)world, this.tilePreviewPos);
        if (te != null) {
            this.init(te.getItem());
        }
    }

    private void init(ItemStack stack) {
        stack = stack.func_77946_l();
        this.length = ItemTrackBlueprint.getLength(stack);
        this.quarters = ItemTrackBlueprint.getQuarters(stack);
        this.type = ItemTrackBlueprint.getType(stack);
        this.gauge = ItemGauge.get(stack);
        this.posType = ItemTrackBlueprint.getPosType(stack);
        this.isPreview = ItemTrackBlueprint.isPreview(stack);
        NonNullList oreDict = NonNullList.func_191196_a();
        oreDict.add((Object)new ItemStack(Items.field_190931_a));
        for (ItemStack ore : OreDictionary.getOres((String)"railBed")) {
            if (ore.func_77952_i() == Short.MAX_VALUE) {
                ore.func_77973_b().func_150895_a(ore.func_77973_b().func_77640_w(), oreDict);
                continue;
            }
            oreDict.add((Object)ore);
        }
        this.bedSelector = new ItemPickerGUI((NonNullList<ItemStack>)oreDict, bed -> {
            this.bedTypeButton.field_146126_j = GuiText.SELECTOR_RAIL_BED.toString(this.getBedstackName());
            this.field_146297_k.func_147108_a((GuiScreen)this);
        });
        this.bedSelector.choosenItem = ItemTrackBlueprint.getBed(stack);
        this.bedFillSelector = new ItemPickerGUI((NonNullList<ItemStack>)oreDict, bed -> {
            this.bedTypeButton.field_146126_j = GuiText.SELECTOR_RAIL_BED.toString(this.getBedstackName());
            this.field_146297_k.func_147108_a((GuiScreen)this);
        });
        this.bedFillSelector.choosenItem = ItemTrackBlueprint.getBedFill(stack);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.lengthInput.func_146194_f();
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    public void func_73876_c() {
        this.lengthInput.func_146178_a();
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_146280_a(Minecraft mc, int width, int height) {
        super.func_146280_a(mc, width, height);
        this.bedSelector.func_146280_a(mc, width, height);
        this.bedFillSelector.func_146280_a(mc, width, height);
    }

    public void func_183500_a(int w, int h) {
        this.func_183500_a(w, h);
        this.bedSelector.func_183500_a(w, h);
        this.bedFillSelector.func_183500_a(w, h);
    }

    public String getBedstackName() {
        if (this.bedSelector.choosenItem.func_77973_b() != Items.field_190931_a) {
            return this.bedSelector.choosenItem.func_82833_r();
        }
        return GuiText.NONE.toString();
    }

    public String getBedFillName() {
        if (this.bedFillSelector.choosenItem.func_77973_b() != Items.field_190931_a) {
            return this.bedFillSelector.choosenItem.func_82833_r();
        }
        return GuiText.NONE.toString();
    }

    public void func_73866_w_() {
        int buttonID = 0;
        this.typeButton = new GuiButton(buttonID++, this.field_146294_l / 2 - 100, this.field_146295_m / 4 - 24 + buttonID * 30, GuiText.SELECTOR_TYPE.toString(new Object[]{this.type}));
        this.field_146292_n.add(this.typeButton);
        this.lengthInput = new GuiTextField(buttonID++, this.field_146289_q, this.field_146294_l / 2 - 100, this.field_146295_m / 4 - 24 + buttonID * 30, 200, 20);
        this.lengthInput.func_146180_a("" + this.length);
        this.lengthInput.func_146203_f(3);
        this.lengthInput.func_175205_a(this.integerFilter);
        this.lengthInput.func_146195_b(true);
        this.quartersSlider = new GuiSlider(buttonID++, this.field_146294_l / 2 - 75, this.field_146295_m / 4 - 24 + buttonID * 30, GuiText.SELECTOR_QUARTERS.toString(), 1.0, 4.0, (double)this.quarters, null);
        this.quartersSlider.showDecimal = false;
        this.quartersSlider.field_146125_m = this.type == TrackItems.SWITCH || this.type == TrackItems.TURN;
        this.field_146292_n.add(this.quartersSlider);
        this.bedTypeButton = new GuiButton(buttonID++, this.field_146294_l / 2 - 100, this.field_146295_m / 4 - 24 + buttonID * 30, GuiText.SELECTOR_RAIL_BED.toString(this.getBedstackName()));
        this.field_146292_n.add(this.bedTypeButton);
        this.bedFillButton = new GuiButton(buttonID++, this.field_146294_l / 2 - 100, this.field_146295_m / 4 - 24 + buttonID * 30, GuiText.SELECTOR_RAIL_BED_FILL.toString(this.getBedFillName()));
        this.field_146292_n.add(this.bedFillButton);
        this.posTypeButton = new GuiButton(buttonID++, this.field_146294_l / 2 - 100, this.field_146295_m / 4 - 24 + buttonID * 30, GuiText.SELECTOR_POSITION.toString(new Object[]{this.posType}));
        this.field_146292_n.add(this.posTypeButton);
        this.isPreviewCB = new GuiCheckBox(buttonID++, this.field_146294_l / 2 - 75, this.field_146295_m / 4 - 24 + buttonID * 30, GuiText.SELECTOR_PLACE_BLUEPRINT.toString(), this.isPreview);
        this.field_146292_n.add(this.isPreviewCB);
        this.gaugeButton = new GuiButton(buttonID++, this.field_146294_l / 2 - 100, this.field_146295_m / 4 - 24 + buttonID * 30, GuiText.SELECTOR_GAUGE.toString(new Object[]{this.gauge}));
        this.field_146292_n.add(this.gaugeButton);
        this.bedSelector.func_73866_w_();
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button == this.typeButton) {
            this.type = TrackItems.values()[(this.type.ordinal() + 1) % TrackItems.values().length];
            this.typeButton.field_146126_j = GuiText.SELECTOR_TYPE.toString(new Object[]{this.type});
            boolean bl = this.quartersSlider.field_146125_m = this.type == TrackItems.SWITCH || this.type == TrackItems.TURN;
        }
        if (button == this.gaugeButton) {
            this.gauge = Gauge.values()[(this.gauge.ordinal() + 1) % Gauge.values().length];
            this.gaugeButton.field_146126_j = GuiText.SELECTOR_GAUGE.toString(new Object[]{this.gauge});
        }
        if (button == this.posTypeButton) {
            this.posType = TrackPositionType.values()[(this.posType.ordinal() + 1) % TrackPositionType.values().length];
            this.posTypeButton.field_146126_j = GuiText.SELECTOR_POSITION.toString(new Object[]{this.posType});
        }
        if (button == this.bedTypeButton) {
            this.field_146297_k.func_147108_a((GuiScreen)this.bedSelector);
        }
        if (button == this.bedFillButton) {
            this.field_146297_k.func_147108_a((GuiScreen)this.bedFillSelector);
        }
        if (button == this.isPreviewCB) {
            this.isPreview = this.isPreviewCB.isChecked();
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        this.lengthInput.func_146201_a(typedChar, keyCode);
        if (keyCode == 1 || keyCode == 28 || keyCode == 156) {
            if (!this.lengthInput.func_146179_b().isEmpty()) {
                if (this.tilePreviewPos != null) {
                    ImmersiveRailroading.net.sendToServer((IMessage)new ItemRailUpdatePacket(this.tilePreviewPos, Integer.parseInt(this.lengthInput.func_146179_b()), this.quartersSlider.getValueInt(), this.type, this.gauge.value(), this.posType, this.bedSelector.choosenItem, this.bedFillSelector.choosenItem, this.isPreview));
                } else {
                    ImmersiveRailroading.net.sendToServer((IMessage)new ItemRailUpdatePacket(this.slot, Integer.parseInt(this.lengthInput.func_146179_b()), this.quartersSlider.getValueInt(), this.type, this.gauge.value(), this.posType, this.bedSelector.choosenItem, this.bedFillSelector.choosenItem, this.isPreview));
                }
            }
            this.field_146297_k.func_147108_a(null);
            if (this.field_146297_k.field_71462_r == null) {
                this.field_146297_k.func_71381_h();
            }
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.lengthInput.func_146192_a(mouseX, mouseY, mouseButton);
    }
}

