/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.items;

import cam72cam.immersiverailroading.Config;
import cam72cam.immersiverailroading.items.BaseItemRollingStock;
import cam72cam.immersiverailroading.items.ItemTabs;
import cam72cam.immersiverailroading.items.nbt.ItemDefinition;
import cam72cam.immersiverailroading.items.nbt.ItemGauge;
import cam72cam.immersiverailroading.library.ChatText;
import cam72cam.immersiverailroading.library.Gauge;
import cam72cam.immersiverailroading.library.GuiText;
import cam72cam.immersiverailroading.registry.DefinitionManager;
import cam72cam.immersiverailroading.registry.EntityRollingStockDefinition;
import cam72cam.immersiverailroading.tile.TileRailBase;
import cam72cam.immersiverailroading.util.BlockUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Optional.Interface(iface="mezz.jei.api.ingredients.ISlowRenderItem", modid="jei")
public class ItemRollingStock
extends BaseItemRollingStock {
    public static final String NAME = "item_rolling_stock";

    public ItemRollingStock() {
        this.func_77655_b("immersiverailroading:item_rolling_stock");
        this.setRegistryName(new ResourceLocation("immersiverailroading", NAME));
        this.func_77637_a(ItemTabs.STOCK_TAB);
        this.func_77625_d(1);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (String defID : DefinitionManager.getDefinitionNames()) {
                ItemStack stack = new ItemStack((Item)this);
                ItemDefinition.setID(stack, defID);
                this.overrideStackDisplayName(stack);
                items.add((Object)stack);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        this.overrideStackDisplayName(stack);
        Gauge gauge = ItemGauge.get(stack);
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        EntityRollingStockDefinition def = ItemDefinition.get(stack);
        if (def != null) {
            tooltip.addAll(def.getTooltip(gauge));
        }
        tooltip.add(GuiText.GAUGE_TOOLTIP.toString(new Object[]{gauge}));
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileRailBase te;
        if (BlockUtil.isIRRail(worldIn, pos) && (te = TileRailBase.get((IBlockAccess)worldIn, pos)).getAugment() != null) {
            switch (te.getAugment()) {
                case DETECTOR: 
                case FLUID_LOADER: 
                case FLUID_UNLOADER: 
                case ITEM_LOADER: 
                case ITEM_UNLOADER: {
                    if (!worldIn.field_72995_K) {
                        boolean set = te.setAugmentFilter(ItemDefinition.getID(player.func_184586_b(hand)));
                        if (set) {
                            player.func_145747_a((ITextComponent)ChatText.SET_AUGMENT_FILTER.getMessage(ItemDefinition.get((ItemStack)player.func_184586_b((EnumHand)hand)).name));
                        } else {
                            player.func_145747_a((ITextComponent)ChatText.RESET_AUGMENT_FILTER.getMessage(new Object[0]));
                        }
                    }
                    return EnumActionResult.SUCCESS;
                }
            }
        }
        return ItemRollingStock.tryPlaceStock(player, worldIn, pos, hand, null);
    }

    public boolean isValidArmor(ItemStack stack, EntityEquipmentSlot armorType, Entity entity) {
        return armorType == EntityEquipmentSlot.HEAD && Config.trainsOnTheBrain;
    }
}

