/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.items;

import cam72cam.immersiverailroading.items.BaseItemRollingStock;
import cam72cam.immersiverailroading.items.ItemTabs;
import cam72cam.immersiverailroading.items.nbt.ItemComponent;
import cam72cam.immersiverailroading.items.nbt.ItemDefinition;
import cam72cam.immersiverailroading.items.nbt.ItemGauge;
import cam72cam.immersiverailroading.items.nbt.ItemRawCast;
import cam72cam.immersiverailroading.library.CraftingType;
import cam72cam.immersiverailroading.library.GuiText;
import cam72cam.immersiverailroading.library.ItemComponentType;
import cam72cam.immersiverailroading.registry.DefinitionManager;
import cam72cam.immersiverailroading.registry.EntityRollingStockDefinition;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Optional.Interface(iface="mezz.jei.api.ingredients.ISlowRenderItem", modid="jei")
public class ItemRollingStockComponent
extends BaseItemRollingStock {
    public static final String NAME = "item_rolling_stock_component";

    public ItemRollingStockComponent() {
        this.func_77655_b("immersiverailroading:item_rolling_stock_component");
        this.setRegistryName(new ResourceLocation("immersiverailroading", NAME));
        this.func_77637_a(ItemTabs.COMPONENT_TAB);
    }

    @Override
    protected void overrideStackDisplayName(ItemStack stack) {
        EntityRollingStockDefinition def = ItemDefinition.get(stack);
        if (def != null) {
            stack.func_151001_c(TextFormatting.RESET + def.name + " " + ItemComponent.getComponentType(stack).toString());
        }
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (String defID : DefinitionManager.getDefinitionNames()) {
                EntityRollingStockDefinition def = DefinitionManager.getDefinition(defID);
                for (ItemComponentType item : new LinkedHashSet<ItemComponentType>(def.getItemComponents())) {
                    ItemStack stack = new ItemStack((Item)this);
                    ItemDefinition.setID(stack, defID);
                    ItemComponent.setComponentType(stack, item);
                    ItemRawCast.set(stack, false);
                    this.overrideStackDisplayName(stack);
                    items.add((Object)stack);
                }
            }
        }
    }

    public static boolean requiresHammering(ItemStack stack) {
        return ItemComponent.getComponentType((ItemStack)stack).crafting == CraftingType.CASTING_HAMMER && ItemRawCast.get(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        this.overrideStackDisplayName(stack);
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add(GuiText.GAUGE_TOOLTIP.toString(new Object[]{ItemGauge.get(stack)}));
        if (ItemRollingStockComponent.requiresHammering(stack)) {
            tooltip.add("\u00a7c" + GuiText.RAW_CAST_TOOLTIP.toString() + "\u00a7f");
        }
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (ItemComponent.getComponentType(player.func_184586_b(hand)) != ItemComponentType.FRAME) {
            return EnumActionResult.FAIL;
        }
        ArrayList<ItemComponentType> frame = new ArrayList<ItemComponentType>();
        frame.add(ItemComponentType.FRAME);
        return ItemRollingStockComponent.tryPlaceStock(player, worldIn, pos, hand, frame);
    }
}

