/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.items;

import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.blocks.BlockRailBase;
import cam72cam.immersiverailroading.items.ItemTabs;
import cam72cam.immersiverailroading.items.nbt.ItemGauge;
import cam72cam.immersiverailroading.library.GuiText;
import cam72cam.immersiverailroading.library.GuiTypes;
import cam72cam.immersiverailroading.library.TrackItems;
import cam72cam.immersiverailroading.library.TrackPositionType;
import cam72cam.immersiverailroading.tile.TileRailPreview;
import cam72cam.immersiverailroading.util.RailInfo;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;

@Optional.Interface(iface="mezz.jei.api.ingredients.ISlowRenderItem", modid="jei")
public class ItemTrackBlueprint
extends Item {
    public static final String NAME = "item_rail";

    public ItemTrackBlueprint() {
        this.func_77655_b("immersiverailroading:item_rail");
        this.setRegistryName(new ResourceLocation("immersiverailroading", NAME));
        this.func_77637_a(ItemTabs.MAIN_TAB);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        if (worldIn.field_72995_K) {
            playerIn.openGui((Object)ImmersiveRailroading.instance, GuiTypes.RAIL.ordinal(), worldIn, (int)playerIn.field_70165_t, (int)playerIn.field_70163_u, (int)playerIn.field_70161_v);
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        pos = pos.func_177984_a();
        ItemStack stack = player.func_184586_b(hand);
        if (ItemTrackBlueprint.isPreview(stack)) {
            world.func_175656_a(pos, ImmersiveRailroading.BLOCK_RAIL_PREVIEW.func_176223_P());
            TileRailPreview te = TileRailPreview.get((IBlockAccess)world, pos);
            if (te != null) {
                te.init(stack, player.func_70079_am(), hitX, hitY, hitZ);
            }
            return EnumActionResult.SUCCESS;
        }
        if (player.func_130014_f_().func_180495_p(pos.func_177977_b()).func_177230_c() instanceof BlockRailBase) {
            pos = pos.func_177977_b();
        }
        RailInfo info = new RailInfo(stack, player.field_70170_p, player.func_70079_am(), pos, hitX, hitY, hitZ);
        info.build(player, pos);
        return EnumActionResult.SUCCESS;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add(GuiText.TRACK_TYPE.toString(new Object[]{ItemTrackBlueprint.getType(stack)}));
        tooltip.add(GuiText.TRACK_GAUGE.toString(new Object[]{ItemGauge.get(stack)}));
        tooltip.add(GuiText.TRACK_LENGTH.toString(ItemTrackBlueprint.getLength(stack)));
        tooltip.add(GuiText.TRACK_QUARTERS.toString(ItemTrackBlueprint.getQuarters(stack)));
        tooltip.add(GuiText.TRACK_POSITION.toString(new Object[]{ItemTrackBlueprint.getPosType(stack)}));
        tooltip.add(GuiText.TRACK_RAIL_BED.toString(ItemTrackBlueprint.getBed(stack).func_82833_r()));
        tooltip.add(GuiText.TRACK_RAIL_BED_FILL.toString(ItemTrackBlueprint.getBedFill(stack).func_82833_r()));
        tooltip.add((ItemTrackBlueprint.isPreview(stack) ? GuiText.TRACK_PLACE_BLUEPRINT_TRUE : GuiText.TRACK_PLACE_BLUEPRINT_FALSE).toString());
    }

    public static void setType(ItemStack stack, TrackItems type) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74768_a("type", type.ordinal());
    }

    public static TrackItems getType(ItemStack stack) {
        if (stack.func_77978_p() != null) {
            return TrackItems.values()[stack.func_77978_p().func_74762_e("type")];
        }
        return TrackItems.STRAIGHT;
    }

    public static void setLength(ItemStack stack, int length) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74768_a("length", length);
    }

    public static int getLength(ItemStack stack) {
        if (stack.func_77978_p() != null) {
            return stack.func_77978_p().func_74762_e("length");
        }
        return 10;
    }

    public static void setQuarters(ItemStack stack, int quarters) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74768_a("quarters", quarters);
    }

    public static int getQuarters(ItemStack stack) {
        if (stack.func_77978_p() != null) {
            return stack.func_77978_p().func_74762_e("quarters");
        }
        return 3;
    }

    public static void setPosType(ItemStack stack, TrackPositionType posType) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74768_a("pos_type", posType.ordinal());
    }

    public static TrackPositionType getPosType(ItemStack stack) {
        if (stack.func_77978_p() != null) {
            return TrackPositionType.values()[stack.func_77978_p().func_74762_e("pos_type")];
        }
        return TrackPositionType.FIXED;
    }

    public static ItemStack getBed(ItemStack stack) {
        if (stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("bedItem")) {
            return new ItemStack(stack.func_77978_p().func_74775_l("bedItem"));
        }
        return ItemStack.field_190927_a;
    }

    public static void setBed(ItemStack stack, ItemStack base) {
        stack.func_77978_p().func_74782_a("bedItem", (NBTBase)base.serializeNBT());
    }

    public static ItemStack getBedFill(ItemStack stack) {
        if (stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("bedFill")) {
            return new ItemStack(stack.func_77978_p().func_74775_l("bedFill"));
        }
        return ItemStack.field_190927_a;
    }

    public static void setBedFill(ItemStack stack, ItemStack base) {
        stack.func_77978_p().func_74782_a("bedFill", (NBTBase)base.serializeNBT());
    }

    public static boolean isPreview(ItemStack stack) {
        if (stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("isPreview")) {
            return stack.func_77978_p().func_74767_n("isPreview");
        }
        return false;
    }

    public static void setPreview(ItemStack stack, boolean value) {
        stack.func_77978_p().func_74757_a("isPreview", value);
    }
}

