/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.model;

import cam72cam.immersiverailroading.library.Gauge;
import cam72cam.immersiverailroading.library.RenderComponentType;
import cam72cam.immersiverailroading.registry.EntityRollingStockDefinition;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import net.minecraft.util.math.Vec3d;

public class RenderComponent {
    public final RenderComponentType type;
    public final EntityRollingStockDefinition def;
    public final int id;
    public final String side;
    public final Set<String> modelIDs;
    public final String pos;
    public final double scale;

    public static RenderComponent parse(RenderComponentType name, EntityRollingStockDefinition def, Set<String> groups) {
        return RenderComponent.parse(name, def, groups, -1, "", "");
    }

    public static RenderComponent parseID(RenderComponentType name, EntityRollingStockDefinition def, Set<String> groups, int id) {
        return RenderComponent.parse(name, def, groups, id, "", "");
    }

    public static RenderComponent parseSide(RenderComponentType name, EntityRollingStockDefinition def, Set<String> groups, String side) {
        return RenderComponent.parse(name, def, groups, -1, side, "");
    }

    public static RenderComponent parsePos(RenderComponentType name, EntityRollingStockDefinition def, Set<String> groups, String pos) {
        return RenderComponent.parse(name, def, groups, -1, "", pos);
    }

    public static RenderComponent parsePosID(RenderComponentType name, EntityRollingStockDefinition def, Set<String> groups, String pos, int id) {
        return RenderComponent.parse(name, def, groups, id, "", pos);
    }

    private static RenderComponent parse(RenderComponentType name, EntityRollingStockDefinition def, Set<String> groups, int id, String side, String pos) {
        RenderComponent comp = new RenderComponent(name, def, id, side, pos);
        String idStr = id != -1 ? "" + id : "";
        for (String group : groups) {
            if (!Pattern.matches(name.regex.replace("#SIDE#", side).replaceAll("#ID#", idStr).replaceAll("#POS#", pos), group)) continue;
            comp.modelIDs.add(group);
        }
        if (comp.modelIDs.size() == 0) {
            return null;
        }
        groups.removeAll(comp.modelIDs);
        return comp;
    }

    private RenderComponent(RenderComponentType name, EntityRollingStockDefinition def, int wheel, String side, String pos) {
        this.modelIDs = new HashSet<String>();
        this.type = name;
        this.def = def;
        this.id = wheel;
        this.side = side;
        this.pos = pos;
        this.scale = 1.0;
    }

    protected RenderComponent(EntityRollingStockDefinition def) {
        this(null, def, 0, null, null);
    }

    private RenderComponent(Set<String> modelIDs, RenderComponentType type, EntityRollingStockDefinition def, int id, String side, String pos, double scale) {
        this.modelIDs = modelIDs;
        this.type = type;
        this.def = def;
        this.id = id;
        this.side = side;
        this.pos = pos;
        this.scale = scale;
    }

    public Vec3d min() {
        return this.def.getModel().minOfGroup(this.modelIDs).func_186678_a(this.scale);
    }

    public Vec3d max() {
        return this.def.getModel().maxOfGroup(this.modelIDs).func_186678_a(this.scale);
    }

    public Vec3d center() {
        Vec3d min = this.min();
        Vec3d max = this.max();
        return new Vec3d((min.field_72450_a + max.field_72450_a) / 2.0, (min.field_72448_b + max.field_72448_b) / 2.0, (min.field_72449_c + max.field_72449_c) / 2.0);
    }

    public double height() {
        Vec3d min = this.min();
        Vec3d max = this.max();
        return max.field_72448_b - min.field_72448_b;
    }

    public double length() {
        Vec3d min = this.min();
        Vec3d max = this.max();
        return max.field_72450_a - min.field_72450_a;
    }

    public double width() {
        Vec3d min = this.min();
        Vec3d max = this.max();
        return max.field_72449_c - min.field_72449_c;
    }

    public RenderComponent scale(Gauge gauge) {
        return new RenderComponent(this.modelIDs, this.type, this.def, this.id, this.side, this.pos, gauge.scale());
    }
}

