/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.model.obj;

import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.model.obj.Face;
import cam72cam.immersiverailroading.model.obj.Material;
import cam72cam.immersiverailroading.model.obj.Vec2f;
import cam72cam.immersiverailroading.util.RelativeResource;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;

public class OBJModel {
    public List<String> materialPaths = new ArrayList<String>();
    public Map<String, List<Face>> groups = new LinkedHashMap<String, List<Face>>();
    public List<Vec3d> vertices = new ArrayList<Vec3d>();
    public List<Vec3d> vertexNormals = new ArrayList<Vec3d>();
    public List<Vec2f> vertexTextures = new ArrayList<Vec2f>();
    public Map<String, Material> materials = new HashMap<String, Material>();
    public float darken;
    private Map<Iterable<String>, Vec3d> mins = new HashMap<Iterable<String>, Vec3d>();
    private Map<Iterable<String>, Vec3d> maxs = new HashMap<Iterable<String>, Vec3d>();

    public OBJModel(ResourceLocation modelLoc, float darken) throws Exception {
        InputStream input = ImmersiveRailroading.proxy.getResourceStream(modelLoc);
        Scanner reader = new Scanner(input);
        this.darken = darken;
        String currentGroupName = "defaultName";
        ArrayList<Face> currentGroup = new ArrayList<Face>();
        this.groups.put(currentGroupName, currentGroup);
        ArrayList<String> materialPaths = new ArrayList<String>();
        String currentMaterial = null;
        block47: while (reader.hasNextLine()) {
            String line = reader.nextLine();
            if (line.startsWith("#") || line.length() == 0) continue;
            String[] parts = line.split(" ");
            String cmd = parts[0];
            String[] args = Arrays.copyOfRange(parts, 1, parts.length);
            switch (cmd) {
                case "mtllib": {
                    materialPaths.add(args[0]);
                    continue block47;
                }
                case "usemtl": {
                    currentMaterial = args[0];
                    continue block47;
                }
                case "o": 
                case "g": {
                    currentGroupName = args[0];
                    currentGroup = new ArrayList();
                    this.groups.put(currentGroupName, currentGroup);
                    continue block47;
                }
                case "v": {
                    this.vertices.add(new Vec3d((double)Float.parseFloat(args[0]), (double)Float.parseFloat(args[1]), (double)Float.parseFloat(args[2])));
                    continue block47;
                }
                case "vn": {
                    this.vertexNormals.add(new Vec3d((double)Float.parseFloat(args[0]), (double)Float.parseFloat(args[1]), (double)Float.parseFloat(args[2])));
                    continue block47;
                }
                case "vt": {
                    this.vertexTextures.add(new Vec2f(Float.parseFloat(args[0]), Float.parseFloat(args[1])));
                    continue block47;
                }
                case "f": {
                    currentGroup.addAll(Face.parse(args, currentMaterial));
                    continue block47;
                }
                case "s": {
                    continue block47;
                }
                case "l": {
                    continue block47;
                }
            }
            ImmersiveRailroading.debug("OBJ: ignored line '" + line + "'", new Object[0]);
        }
        reader.close();
        if (materialPaths.size() == 0) {
            return;
        }
        for (String materialPath : materialPaths) {
            Material currentMTL = null;
            input = ImmersiveRailroading.proxy.getResourceStream(RelativeResource.getRelative(modelLoc, materialPath));
            reader = new Scanner(input);
            block49: while (reader.hasNextLine()) {
                String line = reader.nextLine();
                if (line.startsWith("#") || line.length() == 0) continue;
                String[] parts = line.split(" ");
                switch (parts[0]) {
                    case "newmtl": {
                        if (currentMTL != null) {
                            this.materials.put(currentMTL.name, currentMTL);
                        }
                        currentMTL = new Material();
                        currentMTL.name = parts[1];
                        continue block49;
                    }
                    case "Ka": {
                        currentMTL.Ka = ByteBuffer.allocateDirect(16).asFloatBuffer();
                        currentMTL.Ka.put(Float.parseFloat(parts[1]));
                        currentMTL.Ka.put(Float.parseFloat(parts[2]));
                        currentMTL.Ka.put(Float.parseFloat(parts[3]));
                        if (parts.length > 4) {
                            currentMTL.Ka.put(Float.parseFloat(parts[4]));
                        } else {
                            currentMTL.Ka.put(1.0f);
                        }
                        currentMTL.Ka.position(0);
                        continue block49;
                    }
                    case "Kd": {
                        currentMTL.Kd = ByteBuffer.allocateDirect(16).asFloatBuffer();
                        currentMTL.Kd.put(Float.parseFloat(parts[1]));
                        currentMTL.Kd.put(Float.parseFloat(parts[2]));
                        currentMTL.Kd.put(Float.parseFloat(parts[3]));
                        if (parts.length > 4) {
                            currentMTL.Kd.put(Float.parseFloat(parts[4]));
                        } else {
                            currentMTL.Kd.put(1.0f);
                        }
                        currentMTL.Kd.position(0);
                        continue block49;
                    }
                    case "Ks": {
                        currentMTL.Ks = ByteBuffer.allocateDirect(16).asFloatBuffer();
                        currentMTL.Ks.put(Float.parseFloat(parts[1]));
                        currentMTL.Ks.put(Float.parseFloat(parts[2]));
                        currentMTL.Ks.put(Float.parseFloat(parts[3]));
                        if (parts.length > 4) {
                            currentMTL.Ks.put(Float.parseFloat(parts[4]));
                        } else {
                            currentMTL.Ks.put(1.0f);
                        }
                        currentMTL.Ks.position(0);
                        continue block49;
                    }
                    case "map_Kd": {
                        currentMTL.texKd = RelativeResource.getRelative(modelLoc, parts[1]);
                        continue block49;
                    }
                    case "Ns": {
                        continue block49;
                    }
                    case "Ke": {
                        continue block49;
                    }
                    case "Ni": {
                        continue block49;
                    }
                    case "d": {
                        continue block49;
                    }
                    case "illum": {
                        continue block49;
                    }
                }
                ImmersiveRailroading.debug("MTL: ignored line '" + line + "'", new Object[0]);
            }
            if (currentMTL == null) continue;
            this.materials.put(currentMTL.name, currentMTL);
        }
    }

    public Set<String> groups() {
        return this.groups.keySet();
    }

    public Vec3d minOfGroup(Iterable<String> groupNames) {
        if (!this.mins.containsKey(groupNames)) {
            Vec3d min = null;
            for (String group : groupNames) {
                List<Face> faces = this.groups.get(group);
                for (Face face : faces) {
                    for (int[] point : face.points) {
                        Vec3d v = this.vertices.get(point[0]);
                        if (min == null) {
                            min = new Vec3d(v.field_72450_a, v.field_72448_b, v.field_72449_c);
                            continue;
                        }
                        if (min.field_72450_a > v.field_72450_a) {
                            min = new Vec3d(v.field_72450_a, min.field_72448_b, min.field_72449_c);
                        }
                        if (min.field_72448_b > v.field_72448_b) {
                            min = new Vec3d(min.field_72450_a, v.field_72448_b, min.field_72449_c);
                        }
                        if (!(min.field_72449_c > v.field_72449_c)) continue;
                        min = new Vec3d(min.field_72450_a, min.field_72448_b, v.field_72449_c);
                    }
                }
            }
            if (min == null) {
                ImmersiveRailroading.error("EMPTY " + groupNames, new Object[0]);
                min = new Vec3d(0.0, 0.0, 0.0);
            }
            this.mins.put(groupNames, min);
        }
        return this.mins.get(groupNames);
    }

    public Vec3d maxOfGroup(Iterable<String> groupNames) {
        if (!this.maxs.containsKey(groupNames)) {
            Vec3d max = null;
            for (String group : groupNames) {
                List<Face> faces = this.groups.get(group);
                for (Face face : faces) {
                    for (int[] point : face.points) {
                        Vec3d v = this.vertices.get(point[0]);
                        if (max == null) {
                            max = new Vec3d(v.field_72450_a, v.field_72448_b, v.field_72449_c);
                            continue;
                        }
                        if (max.field_72450_a < v.field_72450_a) {
                            max = new Vec3d(v.field_72450_a, max.field_72448_b, max.field_72449_c);
                        }
                        if (max.field_72448_b < v.field_72448_b) {
                            max = new Vec3d(max.field_72450_a, v.field_72448_b, max.field_72449_c);
                        }
                        if (!(max.field_72449_c < v.field_72449_c)) continue;
                        max = new Vec3d(max.field_72450_a, max.field_72448_b, v.field_72449_c);
                    }
                }
            }
            if (max == null) {
                ImmersiveRailroading.error("EMPTY " + groupNames, new Object[0]);
                max = new Vec3d(0.0, 0.0, 0.0);
            }
            this.maxs.put(groupNames, max);
        }
        return this.maxs.get(groupNames);
    }

    public Vec3d centerOfGroups(Iterable<String> groupNames) {
        Vec3d min = this.minOfGroup(groupNames);
        Vec3d max = this.maxOfGroup(groupNames);
        return new Vec3d((min.field_72450_a + max.field_72450_a) / 2.0, (min.field_72448_b + max.field_72448_b) / 2.0, (min.field_72449_c + max.field_72449_c) / 2.0);
    }

    public double heightOfGroups(Iterable<String> groupNames) {
        Vec3d min = this.minOfGroup(groupNames);
        Vec3d max = this.maxOfGroup(groupNames);
        return max.field_72448_b - min.field_72448_b;
    }

    public double lengthOfGroups(Iterable<String> groupNames) {
        Vec3d min = this.minOfGroup(groupNames);
        Vec3d max = this.maxOfGroup(groupNames);
        return max.field_72450_a - min.field_72450_a;
    }

    public double widthOfGroups(Iterable<String> groupNames) {
        Vec3d min = this.minOfGroup(groupNames);
        Vec3d max = this.maxOfGroup(groupNames);
        return max.field_72449_c - min.field_72449_c;
    }
}

