/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.multiblock;

import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.items.nbt.ItemComponent;
import cam72cam.immersiverailroading.items.nbt.ItemDefinition;
import cam72cam.immersiverailroading.items.nbt.ItemGauge;
import cam72cam.immersiverailroading.items.nbt.ItemPlateType;
import cam72cam.immersiverailroading.library.ItemComponentType;
import cam72cam.immersiverailroading.library.PlateType;
import cam72cam.immersiverailroading.multiblock.Multiblock;
import cam72cam.immersiverailroading.multiblock.MultiblockComponent;
import cam72cam.immersiverailroading.tile.TileMultiblock;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class BoilerRollerMultiblock
extends Multiblock {
    private static MultiblockComponent slab = new MultiblockComponent((Block)Blocks.field_150333_U);
    public static final String NAME = "BOILER_MACHINE";
    private static final BlockPos render = new BlockPos(2, 0, 0);
    private static final BlockPos power = new BlockPos(5, 0, 3);
    private static final BlockPos crafting = new BlockPos(2, 0, 4);

    private static MultiblockComponent[][][] componentGenerator() {
        MultiblockComponent[] bed = new MultiblockComponent[]{BoilerRollerMultiblock.L_ENG(), BoilerRollerMultiblock.L_ENG(), BoilerRollerMultiblock.L_ENG(), BoilerRollerMultiblock.L_ENG(), BoilerRollerMultiblock.H_ENG(), BoilerRollerMultiblock.H_ENG()};
        MultiblockComponent[] table = new MultiblockComponent[]{slab, slab, slab, slab, AIR, AIR};
        MultiblockComponent[][][] result = new MultiblockComponent[][][]{{table}, {table}, {table}, {bed}, {bed}, {table}, {table}, {table}};
        return result;
    }

    public BoilerRollerMultiblock() {
        super(NAME, BoilerRollerMultiblock.componentGenerator());
    }

    @Override
    public BlockPos placementPos() {
        return new BlockPos(2, 0, 0);
    }

    @Override
    protected Multiblock.MultiblockInstance newInstance(World world, BlockPos origin, Rotation rot) {
        return new BoilerRollerInstance(world, origin, rot);
    }

    public class BoilerRollerInstance
    extends Multiblock.MultiblockInstance {
        public BoilerRollerInstance(World world, BlockPos origin, Rotation rot) {
            super(world, origin, rot);
        }

        @Override
        public boolean onBlockActivated(EntityPlayer player, EnumHand hand, BlockPos offset) {
            if (!player.func_70093_af()) {
                ItemStack held = player.func_184586_b(hand);
                if (held.func_190926_b()) {
                    TileMultiblock craftTe = this.getTile(crafting);
                    if (craftTe == null) {
                        return false;
                    }
                    player.func_184611_a(hand, craftTe.getContainer().getStackInSlot(1));
                    craftTe.getContainer().setStackInSlot(1, ItemStack.field_190927_a);
                } else if (held.func_77973_b() == ImmersiveRailroading.ITEM_PLATE && ItemPlateType.get(held) == PlateType.BOILER) {
                    TileMultiblock craftTe = this.getTile(crafting);
                    if (craftTe == null) {
                        return false;
                    }
                    if (craftTe.getContainer().getStackInSlot(0).func_190926_b()) {
                        ItemStack inputStack = held.func_77946_l();
                        inputStack.func_190920_e(1);
                        craftTe.getContainer().setStackInSlot(0, inputStack);
                        held.func_190918_g(1);
                        player.func_184611_a(hand, held);
                    }
                }
            }
            return false;
        }

        @Override
        public boolean isRender(BlockPos offset) {
            return offset.equals((Object)render);
        }

        @Override
        public int getInvSize(BlockPos offset) {
            return offset.equals((Object)crafting) ? 2 : 0;
        }

        @Override
        public void tick(BlockPos offset) {
            if (!offset.equals((Object)crafting)) {
                return;
            }
            TileMultiblock craftTe = this.getTile(crafting);
            if (craftTe == null) {
                return;
            }
            TileMultiblock powerTe = this.getTile(power);
            if (powerTe == null) {
                return;
            }
            if (!this.hasPower()) {
                return;
            }
            if (this.world.field_72995_K) {
                if (craftTe.getRenderTicks() % 10L == 0L && craftTe.getCraftProgress() != 0) {
                    this.world.func_184134_a((double)craftTe.func_174877_v().func_177958_n(), (double)craftTe.func_174877_v().func_177956_o(), (double)craftTe.func_174877_v().func_177952_p(), SoundEvents.field_187692_g, SoundCategory.BLOCKS, 1.0f, 0.2f, false);
                }
                return;
            }
            if (craftTe.getCraftProgress() != 0) {
                IEnergyStorage energy = (IEnergyStorage)powerTe.getCapability(CapabilityEnergy.ENERGY, null);
                energy.extractEnergy(32, false);
                craftTe.setCraftProgress(Math.max(0, craftTe.getCraftProgress() - 1));
            }
            float progress = craftTe.getCraftProgress();
            ItemStack input = craftTe.getContainer().getStackInSlot(0);
            ItemStack output = craftTe.getContainer().getStackInSlot(1);
            if (progress == 0.0f && input.func_77973_b() == ImmersiveRailroading.ITEM_PLATE && ItemPlateType.get(input) == PlateType.BOILER && output.func_190926_b()) {
                progress = 100.0f;
                craftTe.setCraftProgress(100);
            }
            if (progress == 1.0f) {
                ItemStack out = new ItemStack((Item)ImmersiveRailroading.ITEM_ROLLING_STOCK_COMPONENT, 1);
                ItemGauge.set(out, ItemGauge.get(input));
                ItemDefinition.setID(out, ItemDefinition.getID(input));
                ItemComponent.setComponentType(out, ItemComponentType.BOILER_SEGMENT);
                craftTe.getContainer().setStackInSlot(1, out);
                input.func_190918_g(1);
                craftTe.getContainer().setStackInSlot(0, input);
            }
        }

        @Override
        public boolean canInsertItem(BlockPos pos, int slot, ItemStack stack) {
            return false;
        }

        @Override
        public boolean isOutputSlot(BlockPos pos, int slot) {
            return false;
        }

        @Override
        public int getSlotLimit(BlockPos offset, int slot) {
            return offset.equals((Object)crafting) ? 1 : 0;
        }

        @Override
        public boolean canRecievePower(BlockPos offset) {
            return offset.equals((Object)power);
        }

        public boolean hasPower() {
            TileMultiblock powerTe = this.getTile(power);
            if (powerTe == null) {
                return false;
            }
            IEnergyStorage energy = (IEnergyStorage)powerTe.getCapability(CapabilityEnergy.ENERGY, null);
            return energy.getEnergyStored() > 32;
        }

        public boolean hasInput() {
            TileMultiblock craftTe = this.getTile(crafting);
            if (craftTe == null) {
                return false;
            }
            return !craftTe.getContainer().getStackInSlot(0).func_190926_b();
        }

        public boolean hasOutput() {
            TileMultiblock craftTe = this.getTile(crafting);
            if (craftTe == null) {
                return false;
            }
            return !craftTe.getContainer().getStackInSlot(1).func_190926_b();
        }
    }
}

