/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.multiblock;

import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.BlockTypes_MetalsAll;
import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.items.nbt.ItemComponent;
import cam72cam.immersiverailroading.items.nbt.ItemDefinition;
import cam72cam.immersiverailroading.items.nbt.ItemGauge;
import cam72cam.immersiverailroading.library.GuiTypes;
import cam72cam.immersiverailroading.library.ItemComponentType;
import cam72cam.immersiverailroading.multiblock.Multiblock;
import cam72cam.immersiverailroading.multiblock.MultiblockComponent;
import cam72cam.immersiverailroading.net.MultiblockSelectCraftPacket;
import cam72cam.immersiverailroading.tile.TileMultiblock;
import cam72cam.immersiverailroading.util.ParticleUtil;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class CastingMultiblock
extends Multiblock {
    private static MultiblockComponent STONE = new MultiblockComponent(Blocks.field_150417_aV);
    private static MultiblockComponent SAND = new MultiblockComponent((Block)Blocks.field_150354_m);
    public static final String NAME = "CASTING";
    private static final BlockPos render = new BlockPos(3, 3, 7);
    private static final BlockPos fluid = new BlockPos(3, 3, 3);
    private static final BlockPos craft = new BlockPos(3, 2, 3);
    private static final BlockPos output = new BlockPos(3, 2, 14);
    private static final BlockPos power = new BlockPos(3, 7, 0);
    public static final double max_volume = 810.0;

    private static MultiblockComponent[][][] blueprint() {
        int z;
        MultiblockComponent[][][] bp = new MultiblockComponent[23][][];
        for (z = 0; z < 7; ++z) {
            MultiblockComponent[] base = new MultiblockComponent[]{AIR, AIR, AIR, AIR, AIR, AIR, AIR};
            if (z > 0 && z < 6) {
                base = z > 1 && z < 5 ? new MultiblockComponent[]{AIR, CastingMultiblock.STEEL(), CastingMultiblock.STEEL(), CastingMultiblock.STEEL(), CastingMultiblock.STEEL(), CastingMultiblock.STEEL(), AIR} : new MultiblockComponent[]{AIR, AIR, CastingMultiblock.STEEL(), CastingMultiblock.STEEL(), CastingMultiblock.STEEL(), AIR, AIR};
            }
            MultiblockComponent[] top = new MultiblockComponent[]{AIR, AIR, CastingMultiblock.CASING(), CastingMultiblock.H_ENG(), CastingMultiblock.CASING(), AIR, AIR};
            MultiblockComponent[] topfirst = new MultiblockComponent[]{AIR, AIR, CastingMultiblock.CASING(), CastingMultiblock.H_ENG(), CastingMultiblock.CASING(), AIR, AIR};
            if (z > 0 && z < 6) {
                if (z > 1 && z < 5) {
                    top = new MultiblockComponent[]{CastingMultiblock.CASING(), AIR, AIR, AIR, AIR, AIR, CastingMultiblock.CASING()};
                    topfirst = new MultiblockComponent[]{CastingMultiblock.CASING(), CastingMultiblock.CASING(), CastingMultiblock.CASING(), CastingMultiblock.H_ENG(), CastingMultiblock.CASING(), CastingMultiblock.CASING(), CastingMultiblock.CASING()};
                } else {
                    top = new MultiblockComponent[]{AIR, CastingMultiblock.CASING(), AIR, AIR, AIR, CastingMultiblock.CASING(), AIR};
                    topfirst = new MultiblockComponent[]{AIR, CastingMultiblock.CASING(), CastingMultiblock.CASING(), CastingMultiblock.H_ENG(), CastingMultiblock.CASING(), CastingMultiblock.CASING(), AIR};
                }
            }
            bp[z] = new MultiblockComponent[8][];
            for (int y = 0; y < 8; ++y) {
                bp[z][y] = y < 3 ? base : (y == 3 ? topfirst : top);
            }
        }
        for (z = 7; z < 23; ++z) {
            bp[z] = z == 7 ? new MultiblockComponent[][]{{AIR, STONE, STONE, STONE, STONE, STONE, AIR}, {AIR, STONE, STONE, STONE, STONE, STONE, AIR}, {AIR, STONE, STONE, STONE, STONE, STONE, AIR}, {AIR, AIR, AIR, CastingMultiblock.STEEL(), AIR, AIR, AIR}} : (z == 22 ? new MultiblockComponent[][]{{AIR, STONE, STONE, STONE, STONE, STONE, AIR}, {AIR, STONE, STONE, STONE, STONE, STONE, AIR}, {AIR, STONE, STONE, STONE, STONE, STONE, AIR}} : new MultiblockComponent[][]{{AIR, STONE, SAND, SAND, SAND, STONE, AIR}, {AIR, STONE, SAND, SAND, SAND, STONE, AIR}, {AIR, STONE, SAND, SAND, SAND, STONE, AIR}});
        }
        return bp;
    }

    public CastingMultiblock() {
        super(NAME, CastingMultiblock.blueprint());
    }

    @Override
    public BlockPos placementPos() {
        return new BlockPos(3, 0, 0);
    }

    @Override
    protected Multiblock.MultiblockInstance newInstance(World world, BlockPos origin, Rotation rot) {
        return new CastingInstance(world, origin, rot);
    }

    public class CastingInstance
    extends Multiblock.MultiblockInstance {
        public CastingInstance(World world, BlockPos origin, Rotation rot) {
            super(world, origin, rot);
        }

        @Override
        public boolean onBlockActivated(EntityPlayer player, EnumHand hand, BlockPos offset) {
            TileMultiblock outTe = this.getTile(output);
            if (outTe == null) {
                return false;
            }
            TileMultiblock craftTe = this.getTile(craft);
            if (craftTe == null) {
                return false;
            }
            if (!outTe.getContainer().getStackInSlot(0).func_190926_b()) {
                if (!this.world.field_72995_K) {
                    this.world.func_72838_d((Entity)new EntityItem(this.world, player.field_70165_t, player.field_70163_u, player.field_70161_v, outTe.getContainer().getStackInSlot(0)));
                    outTe.getContainer().setStackInSlot(0, ItemStack.field_190927_a);
                }
            } else if (craftTe.getCraftItem() != null && !craftTe.getCraftItem().func_190926_b()) {
                System.out.println("CRAFTING");
            } else if (this.world.field_72995_K) {
                BlockPos pos = this.getPos(craft);
                player.openGui((Object)ImmersiveRailroading.instance, GuiTypes.CASTING.ordinal(), this.world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
            return true;
        }

        @Override
        public boolean isRender(BlockPos offset) {
            return render.equals((Object)offset);
        }

        @Override
        public int getInvSize(BlockPos offset) {
            return output.equals((Object)offset) ? 1 : 0;
        }

        @Override
        public void tick(BlockPos offset) {
            TileMultiblock fluidTe;
            if (this.world.field_72995_K) {
                if (offset.func_177952_p() > 7 && offset.func_177956_o() > 1 && this.isPouring()) {
                    Vec3d pos = new Vec3d((Vec3i)this.getPos(offset).func_177982_a(0, 1, 0)).func_72441_c(0.5, 0.5, 0.5);
                    if (Math.random() < 0.01) {
                        ParticleUtil.spawnParticle(this.world, EnumParticleTypes.SMOKE_NORMAL, pos);
                        ParticleUtil.spawnParticle(this.world, EnumParticleTypes.SMOKE_NORMAL, pos);
                    }
                    if (Math.random() < 0.001) {
                        this.world.func_184134_a(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 1.0f, 0.25f, false);
                    }
                }
                return;
            }
            if (offset.equals((Object)fluid)) {
                fluidTe = this.getTile(fluid);
                if (fluidTe == null) {
                    return;
                }
                AxisAlignedBB bb = new AxisAlignedBB(this.getPos(offset.func_177982_a(0, 1, 0))).func_72314_b(3.0, 0.0, 3.0);
                List items = this.world.func_72872_a(EntityItem.class, bb);
                for (Object item : items) {
                    ItemStack stack = item.func_92059_d();
                    if (this.steelBlock().func_77969_a(stack)) {
                        while (stack.func_190916_E() != 0 && (double)fluidTe.getCraftProgress() < 819.0 && this.hasPower()) {
                            stack.func_190918_g(1);
                            fluidTe.setCraftProgress(fluidTe.getCraftProgress() + 9);
                        }
                        continue;
                    }
                    if (fluidTe.getCraftProgress() <= 0) continue;
                    this.world.func_72900_e((Entity)item);
                }
                List living = this.world.func_72872_a(EntityLivingBase.class, bb.func_72314_b(0.0, 2.0, 0.0));
                for (EntityLivingBase alive : living) {
                    alive.func_70097_a(new DamageSource("immersiverailroading:casting"), 5.0f);
                }
            }
            if (offset.equals((Object)craft)) {
                if (!this.hasPower()) {
                    return;
                }
                fluidTe = this.getTile(fluid);
                if (fluidTe == null) {
                    return;
                }
                TileMultiblock craftTe = this.getTile(craft);
                if (craftTe == null) {
                    return;
                }
                TileMultiblock outTe = this.getTile(output);
                if (outTe == null) {
                    return;
                }
                ItemStack item = craftTe.getCraftItem();
                if (item == null || item.func_190926_b()) {
                    return;
                }
                int cost = 0;
                if (item.func_77973_b() == ImmersiveRailroading.ITEM_ROLLING_STOCK_COMPONENT) {
                    ItemComponentType component = ItemComponent.getComponentType(item);
                    cost = component.getCastCost(ItemDefinition.get(item), ItemGauge.get(item));
                } else if (item.func_77973_b() == ImmersiveRailroading.ITEM_CAST_RAIL) {
                    cost = (int)Math.ceil(20.0 * ItemGauge.get(item).scale());
                } else if (item.func_77973_b() == ImmersiveRailroading.ITEM_AUGMENT) {
                    cost = (int)Math.ceil(8.0 * ItemGauge.get(item).scale());
                    item.func_190920_e(8);
                } else {
                    System.out.println("BAD CAST");
                    cost = 10;
                }
                if (craftTe.getCraftProgress() >= cost) {
                    craftTe.setCraftProgress(0);
                    craftTe.setCraftItem(ItemStack.field_190927_a);
                    outTe.getContainer().setStackInSlot(0, item.func_77946_l());
                } else if (craftTe.getRenderTicks() % 10L == 0L && craftTe.getCraftProgress() + fluidTe.getCraftProgress() >= cost && outTe.getContainer().getStackInSlot(0).func_190926_b() && fluidTe.getCraftProgress() > 0) {
                    fluidTe.setCraftProgress(fluidTe.getCraftProgress() - 1);
                    craftTe.setCraftProgress(craftTe.getCraftProgress() + 1);
                }
            }
            if (offset.equals((Object)power)) {
                TileMultiblock powerTe = this.getTile(power);
                if (powerTe == null) {
                    return;
                }
                IEnergyStorage energy = (IEnergyStorage)powerTe.getCapability(CapabilityEnergy.ENERGY, null);
                energy.extractEnergy(32, false);
            }
        }

        @Override
        public boolean canInsertItem(BlockPos offset, int slot, ItemStack stack) {
            return false;
        }

        @Override
        public boolean isOutputSlot(BlockPos offset, int slot) {
            return false;
        }

        @Override
        public int getSlotLimit(BlockPos offset, int slot) {
            return output.equals((Object)offset) ? 1 : 0;
        }

        @Override
        public boolean canRecievePower(BlockPos offset) {
            return offset.equals((Object)power);
        }

        public boolean hasPower() {
            TileMultiblock powerTe = this.getTile(power);
            if (powerTe == null) {
                return false;
            }
            IEnergyStorage energy = (IEnergyStorage)powerTe.getCapability(CapabilityEnergy.ENERGY, null);
            return energy.getEnergyStored() > 32;
        }

        public ItemStack steelBlock() {
            return new ItemStack((Block)IEContent.blockStorage, 1, BlockTypes_MetalsAll.STEEL.getMeta());
        }

        public boolean isPouring() {
            TileMultiblock craftTe = this.getTile(craft);
            if (craftTe == null) {
                return false;
            }
            return craftTe.getCraftProgress() != 0;
        }

        public double getSteelLevel() {
            TileMultiblock fluidTe = this.getTile(fluid);
            if (fluidTe == null) {
                return 0.0;
            }
            return (double)fluidTe.getCraftProgress() * 4.5 / 810.0;
        }

        public void setCraftItem(ItemStack stack) {
            ImmersiveRailroading.net.sendToServer((IMessage)new MultiblockSelectCraftPacket(this.getPos(craft), stack));
        }

        public ItemStack getCraftItem() {
            TileMultiblock craftingTe = this.getTile(craft);
            if (craftingTe == null) {
                return ItemStack.field_190927_a;
            }
            return craftingTe.getCraftItem();
        }
    }
}

