/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.multiblock;

import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.BlockTypes_MetalsAll;
import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.library.GuiTypes;
import cam72cam.immersiverailroading.multiblock.Multiblock;
import cam72cam.immersiverailroading.multiblock.MultiblockComponent;
import cam72cam.immersiverailroading.net.MultiblockSelectCraftPacket;
import cam72cam.immersiverailroading.tile.TileMultiblock;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PlateRollerMultiblock
extends Multiblock {
    public static final String NAME = "PLATE_MACHINE";
    private static final BlockPos render = new BlockPos(2, 0, 0);
    private static final BlockPos crafter = new BlockPos(2, 0, 14);
    private static final BlockPos input = new BlockPos(2, 0, 0);
    private static final BlockPos output = new BlockPos(2, 0, 29);
    private static final BlockPos power = new BlockPos(1, 4, 14);

    private static MultiblockComponent[][][] componentGenerator() {
        MultiblockComponent[][][] result = new MultiblockComponent[30][][];
        MultiblockComponent[] bed = new MultiblockComponent[]{PlateRollerMultiblock.L_ENG(), PlateRollerMultiblock.S_SCAF(), PlateRollerMultiblock.S_SCAF(), PlateRollerMultiblock.S_SCAF(), PlateRollerMultiblock.L_ENG()};
        MultiblockComponent[] mid = new MultiblockComponent[]{PlateRollerMultiblock.L_ENG(), AIR, AIR, AIR, PlateRollerMultiblock.L_ENG()};
        MultiblockComponent[] top = new MultiblockComponent[]{PlateRollerMultiblock.H_ENG(), PlateRollerMultiblock.H_ENG(), PlateRollerMultiblock.H_ENG(), PlateRollerMultiblock.H_ENG(), PlateRollerMultiblock.H_ENG()};
        for (int i = 0; i < 30; ++i) {
            if (i >= 11 && i <= 18) {
                if (i >= 13 && i <= 16) {
                    if (i == 14) {
                        result[i] = new MultiblockComponent[][]{bed, mid, top, {AIR, PlateRollerMultiblock.L_ENG(), PlateRollerMultiblock.L_ENG(), PlateRollerMultiblock.L_ENG(), AIR}, {AIR, PlateRollerMultiblock.H_ENG(), AIR, AIR, AIR}};
                        continue;
                    }
                    result[i] = new MultiblockComponent[][]{bed, mid, top, {AIR, PlateRollerMultiblock.L_ENG(), PlateRollerMultiblock.L_ENG(), PlateRollerMultiblock.L_ENG(), AIR}};
                    continue;
                }
                result[i] = new MultiblockComponent[][]{bed, mid, top};
                continue;
            }
            result[i] = new MultiblockComponent[][]{bed};
        }
        return result;
    }

    public PlateRollerMultiblock() {
        super(NAME, PlateRollerMultiblock.componentGenerator());
    }

    @Override
    public BlockPos placementPos() {
        return new BlockPos(2, 0, 0);
    }

    @Override
    protected Multiblock.MultiblockInstance newInstance(World world, BlockPos origin, Rotation rot) {
        return new PlateRollerInstance(world, origin, rot);
    }

    public class PlateRollerInstance
    extends Multiblock.MultiblockInstance {
        public PlateRollerInstance(World world, BlockPos origin, Rotation rot) {
            super(world, origin, rot);
        }

        @Override
        public boolean onBlockActivated(EntityPlayer player, EnumHand hand, BlockPos offset) {
            if (!player.func_70093_af()) {
                ItemStack held = player.func_184586_b(hand);
                if (held.func_190926_b()) {
                    TileMultiblock outputTe = this.getTile(output);
                    if (outputTe == null) {
                        return false;
                    }
                    if (!outputTe.getContainer().getStackInSlot(0).func_190926_b()) {
                        if (!this.world.field_72995_K) {
                            player.func_184611_a(hand, outputTe.getContainer().getStackInSlot(0));
                            outputTe.getContainer().setStackInSlot(0, ItemStack.field_190927_a);
                        }
                        return true;
                    }
                } else if (held.func_77969_a(this.steelBlock())) {
                    TileMultiblock inputTe = this.getTile(input);
                    if (inputTe == null) {
                        return false;
                    }
                    if (inputTe.getContainer().getStackInSlot(0).func_190926_b() && !this.world.field_72995_K) {
                        ItemStack inputStack = held.func_77946_l();
                        inputStack.func_190920_e(1);
                        inputTe.getContainer().setStackInSlot(0, inputStack);
                        held.func_190918_g(1);
                        player.func_184611_a(hand, held);
                    }
                    return true;
                }
                if (this.world.field_72995_K) {
                    BlockPos pos = this.getPos(offset);
                    player.openGui((Object)ImmersiveRailroading.instance, GuiTypes.PLATE_ROLLER.ordinal(), this.world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean isRender(BlockPos offset) {
            return render.equals((Object)offset);
        }

        @Override
        public int getInvSize(BlockPos offset) {
            return offset.equals((Object)input) || offset.equals((Object)output) ? 1 : 0;
        }

        @Override
        public void tick(BlockPos offset) {
            if (!offset.equals((Object)crafter)) {
                return;
            }
            TileMultiblock craftingTe = this.getTile(crafter);
            if (craftingTe == null) {
                return;
            }
            TileMultiblock powerTe = this.getTile(power);
            if (powerTe == null) {
                return;
            }
            TileMultiblock inputTe = this.getTile(input);
            if (inputTe == null) {
                return;
            }
            TileMultiblock outputTe = this.getTile(output);
            if (outputTe == null) {
                return;
            }
            if (!this.hasPower()) {
                return;
            }
            if (this.world.field_72995_K) {
                if (craftingTe.getRenderTicks() % 10L == 0L && craftingTe.getCraftProgress() != 0) {
                    this.world.func_184134_a((double)craftingTe.func_174877_v().func_177958_n(), (double)craftingTe.func_174877_v().func_177956_o(), (double)craftingTe.func_174877_v().func_177952_p(), SoundEvents.field_187692_g, SoundCategory.BLOCKS, 1.0f, 0.2f, false);
                }
                return;
            }
            if (craftingTe.getCraftProgress() != 0) {
                IEnergyStorage energy = (IEnergyStorage)powerTe.getCapability(CapabilityEnergy.ENERGY, null);
                energy.extractEnergy(32, false);
                craftingTe.setCraftProgress(Math.max(0, craftingTe.getCraftProgress() - 1));
            }
            float progress = craftingTe.getCraftProgress();
            ItemStack input = inputTe.getContainer().getStackInSlot(0);
            ItemStack output = outputTe.getContainer().getStackInSlot(0);
            if (progress == 0.0f && input.func_77969_a(this.steelBlock()) && output.func_190926_b() && !craftingTe.getCraftItem().func_190926_b()) {
                input.func_190920_e(input.func_190916_E() - 1);
                inputTe.getContainer().setStackInSlot(0, input);
                progress = 100.0f;
                craftingTe.setCraftProgress(100);
            }
            if (progress == 1.0f) {
                outputTe.getContainer().setStackInSlot(0, craftingTe.getCraftItem().func_77946_l());
            }
        }

        @Override
        public boolean canInsertItem(BlockPos offset, int slot, ItemStack stack) {
            return offset.equals((Object)input) && stack.func_77969_a(this.steelBlock());
        }

        @Override
        public boolean isOutputSlot(BlockPos offset, int slot) {
            return offset.equals((Object)output);
        }

        @Override
        public int getSlotLimit(BlockPos offset, int slot) {
            return offset.equals((Object)input) || offset.equals((Object)output) ? 1 : 0;
        }

        @Override
        public boolean canRecievePower(BlockPos offset) {
            return offset.equals((Object)power);
        }

        public boolean hasPower() {
            TileMultiblock powerTe = this.getTile(power);
            if (powerTe == null) {
                return false;
            }
            IEnergyStorage energy = (IEnergyStorage)powerTe.getCapability(CapabilityEnergy.ENERGY, null);
            return energy.getEnergyStored() > 32;
        }

        public ItemStack steelBlock() {
            return new ItemStack((Block)IEContent.blockStorage, 1, BlockTypes_MetalsAll.STEEL.getMeta());
        }

        public void setCraftItem(ItemStack stack) {
            ImmersiveRailroading.net.sendToServer((IMessage)new MultiblockSelectCraftPacket(this.getPos(crafter), stack));
        }

        public ItemStack getCraftItem() {
            TileMultiblock craftingTe = this.getTile(crafter);
            if (craftingTe == null) {
                return ItemStack.field_190927_a;
            }
            return craftingTe.getCraftItem();
        }
    }
}

